/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.service.standard;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.InvalidProviderNameException;
import com.sas.dpro.common.ProviderNotAvailableException;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.provider.ProviderFactory;
import com.sas.dpro.service.AbstractInternalService;
import com.sas.dpro.service.ServiceInfo;
import com.sas.dpro.service.ServiceResults;
import com.sas.dpro.service.ServiceResultsImpl;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class PingDProServer
extends AbstractInternalService {
    public static final String SERVICE_NAME = "PingDProServer";
    public static final String PARAM_SERVER = "server";
    public static final int RC_AVAILABLE = 0;
    public static final int RC_UNAVAILABLE = 1;
    public static final String MSG = "com.sas.dpro.service.standard.PingDProServer";

    public PingDProServer() {
        super(SERVICE_NAME);
    }

    protected ResourceBundle getErrorBundle() {
        return ResourceBundle.getBundle(MSG);
    }

    @Override
    protected ServiceResults runServiceImpl(ContainerContext container, Logger logger) throws ServiceFailedException {
        int available = 1;
        String providerName = (String)this.getParameter(PARAM_SERVER);
        try {
            ProviderFactory.getProvider(providerName);
            available = 0;
        }
        catch (ProviderNotAvailableException providerNotAvailableException) {
        }
        catch (InvalidProviderNameException ipne) {
            String desc = this.getErrorBundle().getString("Error.InvalidProviderName.fmt.txt");
            desc = MessageFormat.format(desc, providerName);
            throw new ServiceFailedException(desc, ipne);
        }
        ServiceInfo info = this.createServiceInfo();
        ServiceResultsImpl res = new ServiceResultsImpl(info, container);
        res.setReturnCode(available);
        return res;
    }
}

