/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.service.standard;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.DirListImpl;
import com.sas.dpro.common.SerializableMap;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.service.AbstractInternalService;
import com.sas.dpro.service.ServiceResults;
import com.sas.dpro.service.ServiceResultsImpl;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class MakeDir
extends AbstractInternalService {
    public static final String SERVICE_NAME = "MakeDir";
    public static final String PARAM_DIR = "dir";
    public static final String PARAM_FAIL_IF_NO_CREATE = "failIfNoCreate";
    public static final String PARAM_MAKE_PARENTS = "makeParents";
    public static final String PARAM_SUBDIR = "subDir";
    private static final String MSG = "com.sas.dpro.service.standard.MakeDir";
    private static final ResourceBundle msg = ResourceBundle.getBundle("com.sas.dpro.service.standard.MakeDir");

    public MakeDir() {
        super(SERVICE_NAME);
    }

    private static final String ensureEndingSlash(String dir) {
        if (dir != null && !dir.endsWith("/") && !dir.endsWith("\\")) {
            dir = dir + '/';
        }
        return dir;
    }

    @Override
    protected ServiceResults runServiceImpl(ContainerContext container, Logger logger) throws ServiceFailedException {
        SerializableMap params = this.getParameters();
        String[] dirs = (String[])params.get(PARAM_DIR);
        boolean finc = this.getBooleanParameter(PARAM_FAIL_IF_NO_CREATE, true);
        boolean createParentDirs = this.getBooleanParameter(PARAM_MAKE_PARENTS, true);
        String subDir = (String)this.getParameter(PARAM_SUBDIR);
        if (subDir != null) {
            subDir = MakeDir.ensureEndingSlash(subDir);
        }
        String rootDir = container.getDirectory();
        String p = this.getHost();
        DirListImpl outputDirs = new DirListImpl(rootDir, p, null);
        int count = dirs == null ? 0 : dirs.length;
        for (int i = 0; i < count; ++i) {
            if (subDir != null) {
                dirs[i] = subDir + dirs[i];
            }
            File dir = MakeDir.getAbsoluteFile(container, dirs[i]);
            boolean created = false;
            if (!dir.exists()) {
                boolean bl = created = createParentDirs ? dir.mkdirs() : dir.mkdir();
                if (created) {
                    outputDirs.add(dirs[i]);
                    continue;
                }
                if (!finc) continue;
                String desc = msg.getString("Error.CouldNotCreateDir.fmt.txt");
                desc = MessageFormat.format(desc, this.getName(), dir.getAbsolutePath());
                throw new ServiceFailedException(desc);
            }
            if (!finc) continue;
            String desc = msg.getString("Error.FileOrDirAlreadyExists.fmt.txt");
            desc = MessageFormat.format(desc, this.getName(), dir.getAbsolutePath());
            throw new ServiceFailedException(desc);
        }
        ServiceResultsImpl results = new ServiceResultsImpl(this.createServiceInfo(), container);
        results.setOutputDirs(outputDirs);
        results.setReturnCode(0);
        return results;
    }
}

