/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.service.standard;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.FileList;
import com.sas.dpro.common.FileSet;
import com.sas.dpro.common.InvalidProviderNameException;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.provider.Provider;
import com.sas.dpro.provider.ProviderFactory;
import com.sas.dpro.service.AbstractInternalService;
import com.sas.dpro.service.ServiceResults;
import com.sas.dpro.service.ServiceResultsImpl;
import com.sas.dpro.service.standard.Copy;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class Mail
extends AbstractInternalService {
    public static final String SERVICE_NAME = "Mail";
    public static final String MIME_TYPE_TEXT_PLAIN = "text/plain";
    public static final String MIME_TYPE_TEXT_HTML = "text/html";
    public static final String PARAM_ATTACHMENTS = "attachments";
    public static final String PARAM_ATTACHMENTS_CONTAINERS = "_attachmentsContainers";
    public static final String PARAM_BCC = "bcc";
    public static final String PARAM_BODY = "body";
    public static final String PARAM_BODY_HTML = "bodyHtml";
    public static final String PARAM_CC = "cc";
    public static final String PARAM_FILE_LIST_ATTACHMENTS = "_fileListAttachments";
    public static final String PARAM_FILE_SET_ATTACHMENTS = "_fileSetAttachments";
    public static final String PARAM_FROM = "from";
    public static final String PARAM_SMTP_SERVER = "smtpServer";
    public static final String PARAM_SUBJECT = "subject";
    public static final String PARAM_TO = "to";
    private static final String JAVAMAIL_SMTP_HOST_PROP = "mail.smtp.host";

    public Mail() {
        super(SERVICE_NAME);
    }

    private int attachFileList(FileList fl, List attachList, List attachCCList) throws Exception {
        for (int j = 0; j < fl.getSize(); ++j) {
            attachList.add(fl.getAbsolute(j));
            attachCCList.add(null);
        }
        return fl.getSize();
    }

    private static final String getFileName(String file) {
        if (file == null) {
            return "Unknown";
        }
        int pos = Math.max(file.lastIndexOf(47), file.lastIndexOf(92));
        if (pos > -1) {
            file = file.substring(pos + 1);
        }
        return file;
    }

    private static File handleAddFileAttachmentPart(int index, String fileName, ContainerContext[] attachCCs, MimeBodyPart attachPart) throws MessagingException, IOException, InvalidProviderNameException {
        File tempFile = null;
        String origName = fileName;
        if (attachCCs != null && attachCCs.length > index && attachCCs[index] != null) {
            tempFile = File.createTempFile("dproMailTemp_", null);
            ContainerContext cont = attachCCs[index];
            Provider p = ProviderFactory.getProvider(cont.getProviderName());
            fileName = p.getAbsoluteFilePath(cont, fileName);
            Copy.copyFromRemote(tempFile, p, fileName, false);
            fileName = tempFile.getAbsolutePath();
        }
        FileDataSource source = new FileDataSource(fileName);
        attachPart.setDataHandler(new DataHandler((DataSource)source));
        attachPart.setFileName(Mail.getFileName(origName));
        return tempFile;
    }

    @Override
    protected ServiceResults runServiceImpl(ContainerContext container, Logger logger) throws ServiceFailedException {
        int i;
        String smtpServer = (String)this.getParameter(PARAM_SMTP_SERVER);
        String to = (String)this.getParameter(PARAM_TO);
        String cc = (String)this.getParameter(PARAM_CC);
        String bcc = (String)this.getParameter(PARAM_BCC);
        String from = (String)this.getParameter(PARAM_FROM);
        String subject = (String)this.getParameter(PARAM_SUBJECT);
        String body = (String)this.getParameter(PARAM_BODY);
        String htmlBody = (String)this.getParameter(PARAM_BODY_HTML);
        String[] attachments = (String[])this.getParameter(PARAM_ATTACHMENTS);
        ContainerContext[] attachCCs = (ContainerContext[])this.getParameter(PARAM_ATTACHMENTS_CONTAINERS);
        FileList[] flas = (FileList[])this.getParameter(PARAM_FILE_LIST_ATTACHMENTS);
        FileSet[] fsas = (FileSet[])this.getParameter(PARAM_FILE_SET_ATTACHMENTS);
        ArrayList<String> attachList = new ArrayList<String>(1);
        ArrayList<ContainerContext> attachCCList = new ArrayList<ContainerContext>(1);
        if (attachments != null) {
            try {
                for (i = 0; i < attachments.length; ++i) {
                    if (attachCCs == null || attachCCs.length <= i || attachCCs[i] == null) {
                        String abs = container.getAbsoluteFilePath(attachments[i]);
                        attachList.add(abs);
                        attachCCList.add(null);
                        continue;
                    }
                    attachList.add(attachments[i]);
                    attachCCList.add(attachCCs[i]);
                }
            }
            catch (Exception e) {
                String text = e.getMessage();
                if (text == null) {
                    text = e.toString();
                }
                throw new ServiceFailedException(text, e);
            }
        }
        if (flas != null && flas.length > 0) {
            for (i = 0; i < flas.length; ++i) {
                try {
                    this.attachFileList(flas[i], attachList, attachCCList);
                    continue;
                }
                catch (Exception e) {
                    throw new ServiceFailedException(e);
                }
            }
        }
        if (fsas != null && fsas.length > 0) {
            for (i = 0; i < fsas.length; ++i) {
                FileSet fs = fsas[i];
                try {
                    FileList fl = fs.getMatchingFiles();
                    this.attachFileList(fl, attachList, attachCCList);
                    continue;
                }
                catch (Exception e) {
                    throw new ServiceFailedException(e);
                }
            }
        }
        if (attachList.size() > 0) {
            attachments = new String[attachList.size()];
            attachments = attachList.toArray(attachments);
            attachCCs = new ContainerContext[attachCCList.size()];
            attachCCs = attachCCList.toArray(attachCCs);
        } else {
            attachments = null;
            attachCCs = null;
        }
        try {
            Mail.send(smtpServer, to, from, cc, bcc, subject, body, htmlBody, attachments, attachCCs);
        }
        catch (Exception e) {
            String text = e.getMessage();
            if (text == null) {
                text = e.toString();
            }
            throw new ServiceFailedException(text, e);
        }
        return new ServiceResultsImpl(this.createServiceInfo(), container, 0);
    }

    public static void send(String smtpServer, String to, String from, String subject, String body, String htmlBody) throws MessagingException, IOException, InvalidProviderNameException {
        Mail.send(smtpServer, to, from, null, null, subject, body, htmlBody);
    }

    public static void send(String smtpServer, String to, String from, String cc, String bcc, String subject, String body, String htmlBody) throws MessagingException, IOException, InvalidProviderNameException {
        Mail.send(smtpServer, to, from, cc, bcc, subject, body, htmlBody, null);
    }

    public static void send(String smtpServer, String to, String from, String cc, String bcc, String subject, String body, String htmlBody, String[] attachments) throws MessagingException, IOException, InvalidProviderNameException {
        Mail.send(smtpServer, to, from, cc, bcc, subject, body, htmlBody, attachments, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void send(String smtpServer, String to, String from, String cc, String bcc, String subject, String body, String htmlBody, String[] attachments, ContainerContext[] attachmentCCs) throws MessagingException, IOException, InvalidProviderNameException {
        MimeBodyPart messageBody;
        Properties props = System.getProperties();
        if (smtpServer == null) {
            Provider p = ProviderFactory.getProvider("server-local");
            smtpServer = p.getProperty(JAVAMAIL_SMTP_HOST_PROP);
        }
        if (smtpServer == null) {
            throw new IOException("Mail service not configured");
        }
        props.put(JAVAMAIL_SMTP_HOST_PROP, smtpServer);
        Session session = Session.getDefaultInstance((Properties)props, null);
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(from));
        msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to, (boolean)false));
        if (cc != null) {
            msg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)cc, (boolean)false));
        }
        if (bcc != null) {
            msg.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)bcc, (boolean)false));
        }
        if (subject != null) {
            msg.setSubject(subject);
        }
        MimeMultipart multipart = new MimeMultipart();
        MimeMultipart bodyPart = new MimeMultipart("alternative");
        MimeBodyPart temp = new MimeBodyPart();
        temp.setContent((Multipart)bodyPart);
        multipart.addBodyPart((BodyPart)temp);
        if (body != null) {
            messageBody = new MimeBodyPart();
            messageBody.setText(body);
            bodyPart.addBodyPart((BodyPart)messageBody);
        }
        if (htmlBody != null) {
            messageBody = new MimeBodyPart();
            messageBody.setContent((Object)htmlBody, MIME_TYPE_TEXT_HTML);
            bodyPart.addBodyPart((BodyPart)messageBody);
        }
        ArrayList<File> filesToDelete = null;
        if (attachments != null) {
            for (int i = 0; i < attachments.length; ++i) {
                String fileName = attachments[i];
                MimeBodyPart attachPart = new MimeBodyPart();
                File toDelete = Mail.handleAddFileAttachmentPart(i, fileName, attachmentCCs, attachPart);
                if (toDelete != null) {
                    if (filesToDelete == null) {
                        filesToDelete = new ArrayList<File>(1);
                    }
                    filesToDelete.add(toDelete);
                }
                multipart.addBodyPart((BodyPart)attachPart);
            }
        }
        try {
            msg.setSentDate(new Date());
            msg.setContent((Multipart)multipart);
            Transport.send((Message)msg);
        }
        finally {
            if (filesToDelete != null) {
                for (File file : filesToDelete) {
                    file.delete();
                }
            }
        }
    }
}

