/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.service.standard;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.FileList;
import com.sas.dpro.common.FileSet;
import com.sas.dpro.common.SerializableMap;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.formatter.FormatterWriterImpl;
import com.sas.dpro.formatter.ResultsFormatter;
import com.sas.dpro.formatter.ResultsFormatterFactory;
import com.sas.dpro.service.AbstractInternalService;
import com.sas.dpro.service.ServiceResults;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;

public class Format
extends AbstractInternalService {
    public static final String SERVICE_NAME = "Format";
    private static final String MSG = "com.sas.dpro.service.standard.Format";
    private static ResourceBundle errorMsg;
    public static final String PARAM_CONTAINER_TO_FORMAT = "_ContainerToFormat";
    public static final String PARAM_FILES_TO_FORMAT = "_filesToFormat";
    public static final String PARAM_FILE_LISTS_TO_FORMAT = "_fileListsToFormat";
    public static final String PARAM_FILE_SETS_TO_FORMAT = "_fileSetsToFormat";
    public static final String PARAM_FORMAT_TYPE = "formatType";
    public static final String PARAM_PARAM_START = "_PARAM_";
    public static final String PARAM_RESULTS_COLLECTION = "resultsCollection";

    public Format() {
        super(SERVICE_NAME);
    }

    private static synchronized ResourceBundle getErrorBundle() {
        if (errorMsg == null) {
            errorMsg = ResourceBundle.getBundle(MSG);
        }
        return errorMsg;
    }

    private List getFileCollectionList(SerializableMap params) {
        FileSet[] fssToFormat;
        ArrayList<Cloneable> fcList = null;
        FileList[] flsToFormat = (FileList[])params.get(PARAM_FILE_LISTS_TO_FORMAT);
        if (flsToFormat != null && flsToFormat.length > 0) {
            if (fcList == null) {
                fcList = new ArrayList<Cloneable>(1);
            }
            for (int i = 0; i < flsToFormat.length; ++i) {
                fcList.add(flsToFormat[i]);
            }
        }
        if ((fssToFormat = (FileSet[])params.get(PARAM_FILE_SETS_TO_FORMAT)) != null && fssToFormat.length > 0) {
            if (fcList == null) {
                fcList = new ArrayList(1);
            }
            for (int i = 0; i < fssToFormat.length; ++i) {
                fcList.add(fssToFormat[i]);
            }
        }
        return fcList;
    }

    @Override
    protected ServiceResults runServiceImpl(ContainerContext container, Logger logger) throws ServiceFailedException {
        String formatType = (String)this.getParameter(PARAM_FORMAT_TYPE);
        String resCol = (String)this.getParameter(PARAM_RESULTS_COLLECTION);
        ContainerContext toFormat = (ContainerContext)this.getParameter(PARAM_CONTAINER_TO_FORMAT);
        ResultsFormatterFactory factory = ResultsFormatterFactory.getInstance();
        ResultsFormatter formatter = null;
        try {
            formatter = factory.getResultsFormatter(formatType);
        }
        catch (Exception e) {
            ResourceBundle msg = Format.getErrorBundle();
            String key = "Error.GettingFormatter.fmt.txt";
            String desc = DProUtil.formatString(msg, key, this.getName(), formatType);
            throw new ServiceFailedException(desc, e);
        }
        if (formatter == null) {
            ResourceBundle msg = Format.getErrorBundle();
            String key = "Error.NoFormatter.fmt.txt";
            String desc = DProUtil.formatString(msg, key, this.getName(), formatType);
            throw new ServiceFailedException(desc);
        }
        HashMap params2 = new HashMap();
        SerializableMap params = this.getParameters();
        Iterator i = params.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (((String)entry.getKey()).startsWith(PARAM_PARAM_START)) {
                i.remove();
                String key = (String)entry.getKey();
                key = key.substring(PARAM_PARAM_START.length());
                params2.put(key, entry.getValue());
                continue;
            }
            params2.put((String)entry.getKey(), entry.getValue());
        }
        params2.put(PARAM_RESULTS_COLLECTION, resCol);
        String[] filesToFormat = (String[])params.get(PARAM_FILES_TO_FORMAT);
        List fcList = this.getFileCollectionList(params);
        FormatterWriterImpl w = null;
        try {
            w = new FormatterWriterImpl();
        }
        catch (ParserConfigurationException pce) {
            String text = pce.getMessage();
            if (text == null) {
                text = pce.toString();
            }
            ResourceBundle msg = Format.getErrorBundle();
            String key = "Error.ParserConfig.fmt.txt";
            String desc = DProUtil.formatString(msg, key, this.getName(), text);
            throw new ServiceFailedException(desc, pce);
        }
        ServiceResults res = formatter.doFormat(this, container, toFormat, filesToFormat, fcList, w, params2);
        return res;
    }
}

