/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.service.standard;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.DirList;
import com.sas.dpro.common.DirSet;
import com.sas.dpro.common.FileList;
import com.sas.dpro.common.FileListImpl;
import com.sas.dpro.common.FileSet;
import com.sas.dpro.common.SerializableMap;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.service.AbstractInternalService;
import com.sas.dpro.service.ServiceResults;
import com.sas.dpro.service.ServiceResultsImpl;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class Echo
extends AbstractInternalService {
    public static final String SERVICE_NAME = "Echo";
    public static final String DESTINATION_STDOUT = "stdout";
    public static final String DESTINATION_STDERR = "stderr";
    public static final String DESTINATION_FILE_PREFIX = "file:///";
    public static final String DESTINATION_VARIABLE_PREFIX = "variable:///";
    public static final String PARAM_ADD_ENDING_NEWLINE = "extraNewline";
    public static final String PARAM_APPEND = "append";
    public static final String PARAM_DESTINATION = "dest";
    public static final String PARAM_MESSAGE = "message";
    public static final String PARAM_FILE = "file";
    public static final String PARAM_FILE_LIST = "fileList";
    public static final String PARAM_FILE_SET = "fileSet";
    public static final String PARAM_INPUT_FILE_ENCODING = "fileEncoding";
    public static final String PARAM_OUTPUT_FILE_ENCODING = "destEncoding";
    public static final String PARAM_DIR_LIST = "dirList";
    public static final String PARAM_DIR_SET = "dirSet";
    private static final String BUNDLE = "com.sas.dpro.service.standard.Echo";
    private static final ResourceBundle msg = ResourceBundle.getBundle("com.sas.dpro.service.standard.Echo");

    public Echo() {
        super(SERVICE_NAME);
    }

    private String getMessage(ContainerContext container) throws ServiceFailedException {
        SerializableMap params = this.getParameters();
        String message = (String)params.get(PARAM_MESSAGE);
        if (message == null) {
            String fileName = (String)params.get(PARAM_FILE);
            if (fileName != null) {
                message = this.getMessageFromFile(container, fileName);
            } else {
                FileList fl = (FileList)params.get(PARAM_FILE_LIST);
                if (fl != null) {
                    message = this.getMessageFromFileList(container, fl);
                } else {
                    FileSet fs = (FileSet)params.get(PARAM_FILE_SET);
                    if (fs != null) {
                        message = this.getMessageFromFileSet(container, fs);
                    } else {
                        DirList dl = (DirList)params.get(PARAM_DIR_LIST);
                        if (dl != null) {
                            message = this.getMessageFromDirList(container, dl);
                        } else {
                            DirSet ds = (DirSet)params.get(PARAM_DIR_SET);
                            if (ds != null) {
                                message = this.getMessageFromDirSet(container, ds);
                            }
                        }
                    }
                }
            }
        }
        return message;
    }

    private String getMessageFromDirList(ContainerContext cc, DirList dl) throws ServiceFailedException {
        int count = dl.getSize();
        StringBuilder sb = new StringBuilder();
        sb.append("dirList ID:     ").append(dl.getID()).append('\n');
        sb.append("dirList server: ").append(dl.getProvider()).append('\n');
        sb.append("dirList root:   ").append(dl.getRoot()).append('\n');
        sb.append("dirList dirs (").append(count).append("):\n");
        for (int i = 0; i < count; ++i) {
            sb.append(i + 1).append(". ").append(dl.get(i)).append('\n');
        }
        return sb.toString();
    }

    private String getMessageFromDirSet(ContainerContext cc, DirSet ds) throws ServiceFailedException {
        DirList dl = null;
        try {
            dl = ds.getMatchingDirs();
        }
        catch (RemoteException re) {
            throw new ServiceFailedException(re.getCause());
        }
        catch (Exception e) {
            throw new ServiceFailedException(e);
        }
        int count = dl.getSize();
        StringBuilder sb = new StringBuilder();
        sb.append("dirSet ID:     ").append(ds.getID()).append('\n');
        sb.append("dirSet server: ").append(ds.getProvider()).append('\n');
        sb.append("dirSet root:   ").append(ds.getRoot()).append('\n');
        sb.append("dirSet matched dirs (").append(count).append("):\n");
        for (int i = 0; i < count; ++i) {
            sb.append(i + 1).append(". ").append(dl.get(i)).append('\n');
        }
        return sb.toString();
    }

    private String getMessageFromFile(ContainerContext cc, String fileName) throws ServiceFailedException {
        String message = null;
        File file = Echo.getAbsoluteFile(cc, fileName);
        if (!file.isFile()) {
            String desc = msg.getString("Error.FileDoesntExist.fmt.txt");
            desc = MessageFormat.format(desc, this.getName(), file.getAbsolutePath());
            throw new ServiceFailedException(desc);
        }
        Charset cs = this.getCharsetSpecified(PARAM_INPUT_FILE_ENCODING);
        try {
            message = DProUtil.getLocalFileContents(file, cs);
        }
        catch (IOException ioe) {
            String desc = msg.getString("Error.ReadingFile.fmt.txt");
            desc = MessageFormat.format(desc, this.getName(), ioe.getMessage());
            throw new ServiceFailedException(desc, ioe);
        }
        return message;
    }

    private String getMessageFromFileList(ContainerContext cc, FileList fl) throws ServiceFailedException {
        int count = fl.getSize();
        StringBuilder sb = new StringBuilder();
        sb.append("fileList ID:     ").append(fl.getID()).append('\n');
        sb.append("fileList server: ").append(fl.getProvider()).append('\n');
        sb.append("fileList root:   ").append(fl.getRoot()).append('\n');
        sb.append("fileList files (").append(count).append("):\n");
        for (int i = 0; i < count; ++i) {
            sb.append(i + 1).append(". ").append(fl.get(i)).append('\n');
        }
        return sb.toString();
    }

    private String getMessageFromFileSet(ContainerContext cc, FileSet fs) throws ServiceFailedException {
        FileList fl = null;
        try {
            fl = fs.getMatchingFiles();
        }
        catch (RemoteException re) {
            throw new ServiceFailedException(re.getCause());
        }
        catch (Exception e) {
            throw new ServiceFailedException(e);
        }
        int count = fl.getSize();
        StringBuilder sb = new StringBuilder();
        sb.append("fileSet ID:     ").append(fs.getID()).append('\n');
        sb.append("fileSet server: ").append(fs.getProvider()).append('\n');
        sb.append("fileSet root:   ").append(fs.getRoot()).append('\n');
        sb.append("fileSet matched files (").append(count).append("):\n");
        for (int i = 0; i < count; ++i) {
            sb.append(i + 1).append(". ").append(fl.get(i)).append('\n');
        }
        return sb.toString();
    }

    @Override
    protected ServiceResults runServiceImpl(ContainerContext container, Logger logger) throws ServiceFailedException {
        String destination;
        ServiceResultsImpl results = new ServiceResultsImpl(this.createServiceInfo(), container, 0);
        FileListImpl fileList = null;
        SerializableMap params = this.getParameters();
        String message = this.getMessage(container);
        boolean addNewline = true;
        String temp = (String)params.get(PARAM_ADD_ENDING_NEWLINE);
        if (temp != null) {
            addNewline = Boolean.parseBoolean(temp);
        }
        if ((destination = (String)params.get(PARAM_DESTINATION)) == null || DESTINATION_STDOUT.equals(destination)) {
            if (addNewline) {
                System.out.println(message);
            } else {
                System.out.print(message);
                System.out.flush();
            }
            results.setStdout(message);
        } else if (DESTINATION_STDERR.equals(destination)) {
            if (addNewline) {
                System.err.println(message);
            } else {
                System.err.print(message);
                System.err.flush();
            }
            results.setStderr(message);
        } else if (destination.startsWith(DESTINATION_FILE_PREFIX)) {
            String fileName = destination.substring(DESTINATION_FILE_PREFIX.length());
            File file = Echo.getAbsoluteFile(container, fileName);
            boolean append = this.getBooleanParameter(PARAM_APPEND, false);
            boolean utf8BOM = false;
            String csName = (String)this.getParameter(PARAM_OUTPUT_FILE_ENCODING);
            if ("UTF-8BOM".equalsIgnoreCase(csName) || "UTF8BOM".equalsIgnoreCase(csName)) {
                utf8BOM = true;
                csName = "UTF-8";
            }
            Charset cs = this.getCharsetSpecified(PARAM_OUTPUT_FILE_ENCODING);
            try {
                Echo.writeLocalTextFile(file, append, cs, utf8BOM, message);
            }
            catch (IOException ioe) {
                String desc = msg.getString("Error.WritingToFile.fmt.txt");
                desc = MessageFormat.format(desc, this.getName(), ioe.getMessage());
                throw new ServiceFailedException(desc, ioe);
            }
            fileList = new FileListImpl(file.getParent(), this.getHost(), null);
            fileList.add(file.getName());
        } else if (destination.startsWith(DESTINATION_VARIABLE_PREFIX)) {
            results.setStdout(message);
        } else {
            String desc = msg.getString("Error.InvalidDest.fmt.txt");
            desc = MessageFormat.format(desc, this.getName(), destination);
            throw new ServiceFailedException(desc);
        }
        if (fileList != null) {
            results.setOutputFiles(fileList);
        }
        return results;
    }

    public static void writeLocalTextFile(File file, boolean append, Charset charset, String content) throws IOException {
        Echo.writeLocalTextFile(file, append, charset, false, content);
    }

    public static void writeLocalTextFile(File file, boolean append, Charset charset, boolean utf8BOM, String content) throws IOException {
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        FileOutputStream fos = new FileOutputStream(file, append);
        DProUtil.possiblyWriteBOM(fos, charset, utf8BOM);
        PrintWriter w = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)fos, charset)));
        w.print(content);
        w.close();
    }
}

