/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.service.standard;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.DirList;
import com.sas.dpro.common.DirSet;
import com.sas.dpro.common.ExternalProcessUtil;
import com.sas.dpro.common.FileList;
import com.sas.dpro.common.FileSet;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.service.ServiceResults;
import com.sas.dpro.service.ServiceResultsImpl;
import com.sas.dpro.service.standard.AbstractExternalProcessService;
import com.sas.dpro.service.standard.StandardServiceNames;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class Chmod
extends AbstractExternalProcessService
implements StandardServiceNames {
    public static final String SERVICE_NAME = "Chmod";
    public static final String PARAM_FAIL_IF_NO_INPUT = "failIfNoInput";
    public static final String PARAM_INPUT_FILE_SETS = "_inputFileSets";
    public static final String PARAM_INPUT_DIR_SETS = "_inputDirSets";
    public static final String PARAM_INPUT_ORDER = "_inputOrder";
    public static final String PARAM_MODE = "mode";
    public static final String PARAM_PRESERVE_OPTIONAL_ACL = "preserveACLs";
    public static final String PARAM_RECURSIVE = "recursive";
    public static final int INPUT_ORDER_FILE_SET = 0;
    public static final int INPUT_ORDER_DIR_SET = 1;
    public static final String PROPERTY_EXE_LOCATION = "com.sas.dpro.service.standard.Chmod.command";
    private static final String MSG = "com.sas.dpro.service.standard.Chmod";

    public Chmod() {
        this("chmod");
    }

    public Chmod(String command) {
        super(SERVICE_NAME, command);
    }

    protected ResourceBundle getErrorBundle() {
        return ResourceBundle.getBundle(MSG);
    }

    @Override
    public boolean isInternalService() {
        return true;
    }

    @Override
    protected ServiceResults runServiceImpl(ContainerContext container, Logger logger) throws ServiceFailedException {
        int count;
        String desc;
        ServiceResultsImpl results = new ServiceResultsImpl(this.createServiceInfo(), container, 0);
        if (DProUtil.osIsWindows()) {
            return results;
        }
        ArrayList<String> extraArgList = new ArrayList<String>();
        if (this.getBooleanParameter(PARAM_PRESERVE_OPTIONAL_ACL, false)) {
            extraArgList.add("-A");
        }
        if (this.getBooleanParameter(PARAM_RECURSIVE, false)) {
            extraArgList.add("-R");
        }
        extraArgList.add((String)this.getParameter(PARAM_MODE));
        int[] inputOrder = (int[])this.getParameter(PARAM_INPUT_ORDER);
        FileSet[] fileSets = (FileSet[])this.getParameter(PARAM_INPUT_FILE_SETS);
        DirSet[] dirSets = (DirSet[])this.getParameter(PARAM_INPUT_DIR_SETS);
        int fileSetCount = fileSets == null ? 0 : fileSets.length;
        int dirSetCount = dirSets == null ? 0 : dirSets.length;
        ArrayList<String> fileArgList = new ArrayList<String>(1);
        try {
            if (inputOrder == null) {
                for (int i = 0; i < fileSetCount; ++i) {
                    FileList fl = fileSets[i].getMatchingFiles();
                    for (int j = 0; j < fl.getSize(); ++j) {
                        fileArgList.add(fl.getAbsolute(j));
                    }
                }
            } else {
                int totalInputsCount = fileSetCount + dirSetCount;
                if (inputOrder.length != totalInputsCount) {
                    ResourceBundle msg = this.getErrorBundle();
                    String desc2 = msg.getString("Error.InvalidOrderArray.fmt.txt");
                    desc2 = MessageFormat.format(desc2, this.getName(), "" + inputOrder.length, "" + totalInputsCount);
                    throw new ServiceFailedException(desc2);
                }
                int fileSetPos = 0;
                int dirSetPos = 0;
                block10: for (int i = 0; i < totalInputsCount; ++i) {
                    int temp = inputOrder[i];
                    switch (temp) {
                        case 1: {
                            if (dirSetPos == dirSetCount) {
                                ResourceBundle msg = this.getErrorBundle();
                                String desc3 = msg.getString("Error.InvalidOrderItem.fmt.txt");
                                desc3 = MessageFormat.format(desc3, this.getName(), "" + temp, "" + i);
                                throw new ServiceFailedException(desc3);
                            }
                            DirSet ds = dirSets[dirSetPos++];
                            DirList dl = ds.getMatchingDirs();
                            for (int j = 0; j < dl.getSize(); ++j) {
                                fileArgList.add(dl.getAbsolute(j));
                            }
                            continue block10;
                        }
                        case 0: {
                            if (fileSetPos == fileSetCount) {
                                ResourceBundle msg = this.getErrorBundle();
                                desc = msg.getString("Error.InvalidOrderItem.fmt.txt");
                                desc = MessageFormat.format(desc, this.getName(), "" + temp, "" + i);
                                throw new ServiceFailedException(desc);
                            }
                            FileSet fs = fileSets[fileSetPos++];
                            FileList fl = fs.getMatchingFiles();
                            for (int j = 0; j < fl.getSize(); ++j) {
                                fileArgList.add(fl.getAbsolute(j));
                            }
                            continue block10;
                        }
                        default: {
                            ResourceBundle msg = this.getErrorBundle();
                            String desc4 = msg.getString("Error.InvalidOrderItem.fmt.txt");
                            desc4 = MessageFormat.format(desc4, this.getName(), "" + temp, "" + i);
                            throw new ServiceFailedException(desc4);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            ResourceBundle msg = this.getErrorBundle();
            String desc5 = msg.getString("Error.GettingInputFileList.fmt.txt");
            String text = e.getMessage();
            if (text == null) {
                text = e.toString();
            }
            desc5 = MessageFormat.format(desc5, text);
            throw new ServiceFailedException(desc5, e);
        }
        if ((count = fileArgList.size()) == 0) {
            boolean failIfNoInput = true;
            String failStr = (String)this.getParameter(PARAM_FAIL_IF_NO_INPUT);
            if (failStr != null) {
                failIfNoInput = Boolean.parseBoolean(failStr);
            }
            if (failIfNoInput) {
                ResourceBundle msg = this.getErrorBundle();
                String desc6 = msg.getString("Error.NoInputFiles.txt");
                throw new ServiceFailedException(desc6);
            }
            return results;
        }
        for (int i = 0; i < count; ++i) {
            extraArgList.add((String)fileArgList.get(i));
        }
        count = extraArgList.size();
        String[] extraArgArray = new String[count];
        extraArgArray = extraArgList.toArray(extraArgArray);
        String[] commandArray = this.createCommandLineArray(extraArgArray);
        File dir = new File(container.getDirectory());
        Map envVars = null;
        Process p = this.startProcess(commandArray, envVars, true, dir, false);
        int rc = 0;
        try {
            rc = ExternalProcessUtil.waitFor(p, null, null, null, null);
        }
        catch (Exception ie) {
            if (p != null) {
                p.destroy();
            }
            desc = this.getErrorBundle().getString("Error.ServiceFailedGeneric.fmt.txt");
            String param2 = ie.getMessage();
            if (param2 == null) {
                param2 = ie.toString();
            }
            desc = MessageFormat.format(desc, param2);
            ServiceFailedException sfe = new ServiceFailedException(desc, ie);
            String commandExecuted = ExternalProcessUtil.createCommandString(commandArray);
            sfe.setCommandExecuted(commandExecuted);
            throw sfe;
        }
        results.setReturnCode(rc);
        results.setCommandExecuted(ExternalProcessUtil.createCommandString(extraArgArray));
        return results;
    }
}

