/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.service.standard;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.FileList;
import com.sas.dpro.common.FileListImpl;
import com.sas.dpro.common.FileSet;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.service.AbstractInternalService;
import com.sas.dpro.service.ServiceResults;
import com.sas.dpro.service.ServiceResultsImpl;
import com.sas.dpro.service.standard.Copy;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class ChangeEncoding
extends AbstractInternalService {
    public static final String SERVICE_NAME = "ChangeEncoding";
    public static final String PARAM_FAIL_IF_NO_INPUT = "failIfNoInput";
    public static final String PARAM_FILES = "_files";
    public static final String PARAM_FILE_LISTS = "_fileLists";
    public static final String PARAM_FILE_SETS = "_fileSets";
    public static final String PARAM_INPUT_CHARSET = "from";
    public static final String PARAM_OUTPUT_CHARSET = "to";
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final String TEMP_FILE_PREFIX = "dproTemp_ChangeEncoding_";
    private static final String MSG = "com.sas.dpro.service.standard.ChangeEncoding";

    public ChangeEncoding() {
        super(SERVICE_NAME);
    }

    public static boolean convertFile(String fileName, Charset inCS, Charset outCS, File root, char[] buf) throws IOException {
        return ChangeEncoding.convertFile(fileName, inCS, outCS, false, root, buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean convertFile(String fileName, Charset inCS, Charset outCS, boolean outUTF8BOM, File root, char[] buf) throws IOException {
        File file = new File(fileName);
        if (!file.isFile()) {
            ResourceBundle msg = ResourceBundle.getBundle(MSG);
            String key = "Error.FileDoesNotExist.fmt.txt";
            String text = DProUtil.formatString(msg, key, file.getAbsolutePath());
            throw new IOException(text);
        }
        if (inCS == null) {
            inCS = Charset.defaultCharset();
        }
        if (outCS == null) {
            outCS = Charset.defaultCharset();
        }
        if (inCS.equals(outCS)) {
            return false;
        }
        if (buf == null) {
            buf = new char[8192];
        }
        if (root == null) {
            String tempDir = System.getProperty("java.io.tmpdir");
            root = new File(tempDir);
        }
        InputStream in = new FileInputStream(file);
        in = DProUtil.possiblyReadBOM(in, inCS);
        File temp = null;
        try (BufferedReader r = new BufferedReader(new InputStreamReader(in, inCS));){
            temp = File.createTempFile(TEMP_FILE_PREFIX, null, root);
            FileOutputStream out = new FileOutputStream(temp);
            DProUtil.possiblyWriteBOM(out, outCS, outUTF8BOM);
            try (PrintWriter w = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)out, outCS)));){
                int count = 0;
                while ((count = r.read(buf)) != -1) {
                    w.write(buf, 0, count);
                }
            }
        }
        file.delete();
        if (!temp.renameTo(file)) {
            Copy.copyLocal(file, temp, true);
        }
        if (temp.exists()) {
            ResourceBundle msg = ResourceBundle.getBundle(MSG);
            String key = "Error.DeletingTempFile.fmt.txt";
            String text = DProUtil.formatString(msg, key, temp.getAbsolutePath());
            throw new IOException(text);
        }
        return true;
    }

    private int convertFileList(FileList fl, Charset inCS, Charset outCS, boolean outUTF8BOM, File root, List completedList, char[] buf) throws IOException {
        if (fl == null) {
            return 0;
        }
        int converted = 0;
        for (int j = 0; j < fl.getSize(); ++j) {
            String file = fl.getAbsolute(j);
            if (!this.handleConvertFile(file, inCS, outCS, outUTF8BOM, root, completedList, buf)) continue;
            ++converted;
        }
        return converted;
    }

    private boolean handleConvertFile(String file, Charset inCS, Charset outCS, boolean outUTF8BOM, File root, List completedList, char[] buf) throws IOException {
        boolean success = false;
        if (Collections.binarySearch(completedList, file) < 0) {
            success = ChangeEncoding.convertFile(file, inCS, outCS, outUTF8BOM, root, buf);
            completedList.add(file);
            Collections.sort(completedList);
        }
        return success;
    }

    @Override
    protected ServiceResults runServiceImpl(ContainerContext container, Logger logger) throws ServiceFailedException {
        int i;
        ServiceResultsImpl results = new ServiceResultsImpl(this.createServiceInfo(), container, 0);
        Charset inCS = this.getCharsetSpecified(PARAM_INPUT_CHARSET);
        Charset outCS = this.getCharsetSpecified(PARAM_OUTPUT_CHARSET);
        boolean outUtf8BOM = false;
        String csName = (String)this.getParameter(PARAM_OUTPUT_CHARSET);
        if ("UTF-8BOM".equalsIgnoreCase(csName) || "UTF8BOM".equalsIgnoreCase(csName)) {
            outUtf8BOM = true;
        }
        if (inCS.equals(outCS)) {
            return results;
        }
        String[] files = (String[])this.getParameter(PARAM_FILES);
        FileList[] fileLists = (FileList[])this.getParameter(PARAM_FILE_LISTS);
        FileSet[] fileSets = (FileSet[])this.getParameter(PARAM_FILE_SETS);
        String rootDir = container.getDirectory();
        String provider = container.getProviderName();
        FileListImpl outputFiles = new FileListImpl(rootDir, provider, null);
        File root = new File(rootDir);
        int bufSize = this.getFileIOBufferSize();
        if (bufSize == -1) {
            bufSize = 8192;
        }
        char[] buf = new char[bufSize];
        ArrayList completedList = new ArrayList();
        int changeCount = 0;
        int count = files == null ? 0 : files.length;
        for (i = 0; i < count; ++i) {
            String file = files[i];
            file = ChangeEncoding.getAbsoluteFile(container, file).getAbsolutePath();
            try {
                if (!this.handleConvertFile(file, inCS, outCS, outUtf8BOM, root, completedList, buf)) continue;
                ++changeCount;
                continue;
            }
            catch (IOException ioe) {
                ResourceBundle msg = ResourceBundle.getBundle(MSG);
                String key = "Error.ConvertingFile.fmt.txt";
                String text = DProUtil.formatString(msg, key, this.getName(), file, ioe.getMessage());
                throw new ServiceFailedException(text, ioe);
            }
        }
        count = fileLists == null ? 0 : fileLists.length;
        for (i = 0; i < count; ++i) {
            FileList fl = fileLists[i];
            try {
                changeCount += this.convertFileList(fl, inCS, outCS, outUtf8BOM, root, completedList, buf);
                continue;
            }
            catch (IOException ioe) {
                ResourceBundle msg = ResourceBundle.getBundle(MSG);
                String key = "Error.ConvertingFileList.fmt.txt";
                String text = DProUtil.formatString(msg, key, this.getName(), ioe.getMessage());
                throw new ServiceFailedException(text, ioe);
            }
        }
        count = fileSets == null ? 0 : fileSets.length;
        for (i = 0; i < count; ++i) {
            FileSet fs = fileSets[i];
            FileList fl = null;
            try {
                fl = fs.getMatchingFiles();
            }
            catch (Exception e) {
                ResourceBundle msg = ResourceBundle.getBundle(MSG);
                String key = "Error.EvaluatingFileSet.fmt.txt";
                String text = DProUtil.formatString(msg, key, this.getName(), fs.getID(), e.getMessage());
                throw new ServiceFailedException(text, e);
            }
            try {
                changeCount += this.convertFileList(fl, inCS, outCS, outUtf8BOM, root, completedList, buf);
                continue;
            }
            catch (IOException ioe) {
                ResourceBundle msg = ResourceBundle.getBundle(MSG);
                String key = "Error.ConvertingFileList.fmt.txt";
                String text = DProUtil.formatString(msg, key, this.getName(), ioe.getMessage());
                throw new ServiceFailedException(text, ioe);
            }
        }
        boolean doFail = true;
        String failIfNoInputStr = (String)this.getParameter(PARAM_FAIL_IF_NO_INPUT);
        if (failIfNoInputStr != null) {
            doFail = Boolean.parseBoolean(failIfNoInputStr);
        }
        if (doFail && changeCount == 0) {
            ResourceBundle msg = ResourceBundle.getBundle(MSG);
            String key = "Error.NoInput.fmt.txt";
            String text = DProUtil.formatString(msg, key, this.getName());
            throw new ServiceFailedException(text);
        }
        results.setOutputFiles(outputFiles);
        return results;
    }
}

