/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.service.standard;

import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.service.AbstractInternalService;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ResourceBundle;

public abstract class AbstractReflectionBasedInternalService
extends AbstractInternalService {
    private static final String MSG = "com.sas.dpro.service.standard.AbstractReflectionBasedInternalService";
    private static ResourceBundle errorMsg;

    public AbstractReflectionBasedInternalService(String name) {
        super(name);
    }

    protected Class getClass(String className) throws ServiceFailedException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            ResourceBundle msg = AbstractReflectionBasedInternalService.getReflectionErrorBundle();
            String key = "Error.ClassNotFound.fmt.txt";
            String desc = DProUtil.formatString(msg, key, this.getName(), className);
            throw new ServiceFailedException(desc, cnfe);
        }
    }

    protected Constructor getConstructor(Class clazz, Class[] paramTypes) throws ServiceFailedException {
        try {
            return clazz.getConstructor(paramTypes);
        }
        catch (NoSuchMethodException nsme) {
            ResourceBundle msg = AbstractReflectionBasedInternalService.getReflectionErrorBundle();
            String key = "Error.MethodNotFound.fmt.txt";
            String methodName = "<init>";
            String desc = DProUtil.formatString(msg, key, this.getName(), clazz.getName(), methodName);
            throw new ServiceFailedException(desc, nsme);
        }
    }

    private static synchronized ResourceBundle getReflectionErrorBundle() {
        if (errorMsg == null) {
            errorMsg = ResourceBundle.getBundle(MSG);
        }
        return errorMsg;
    }

    protected Method getMethod(Class clazz, String methodName, Class[] parmTypes) throws ServiceFailedException {
        try {
            return clazz.getMethod(methodName, parmTypes);
        }
        catch (NoSuchMethodException nsme) {
            ResourceBundle msg = AbstractReflectionBasedInternalService.getReflectionErrorBundle();
            String key = "Error.MethodNotFound.fmt.txt";
            String desc = DProUtil.formatString(msg, key, this.getName(), clazz.getName(), methodName);
            throw new ServiceFailedException(desc, nsme);
        }
    }

    protected Object invoke(Method m, Object obj, Object[] parms) throws ServiceFailedException {
        try {
            return m.invoke(obj, parms);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (cause == null) {
                cause = ite;
            }
            this.throwInvokeException(obj, m, cause);
        }
        catch (Exception e) {
            this.throwInvokeException(obj, m, e);
        }
        return null;
    }

    protected Object newInstance(Class clazz) throws ServiceFailedException {
        try {
            return clazz.newInstance();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            ResourceBundle msg = AbstractReflectionBasedInternalService.getReflectionErrorBundle();
            String key = "Error.InvokingConstructor.fmt.txt";
            String desc = DProUtil.formatString(msg, key, this.getName(), clazz.getName());
            throw new ServiceFailedException(desc, e);
        }
    }

    protected Object newInstance(Constructor c, Object[] params) throws ServiceFailedException {
        try {
            return c.newInstance(params);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            ResourceBundle msg = AbstractReflectionBasedInternalService.getReflectionErrorBundle();
            String key = "Error.InvokingConstructor.fmt.txt";
            String desc = DProUtil.formatString(msg, key, this.getName(), c.getDeclaringClass().getName());
            throw new ServiceFailedException(desc, e);
        }
    }

    private void throwInvokeException(Object obj, Method m, Throwable t) throws ServiceFailedException {
        String text = t.getMessage();
        if (text == null) {
            text = t.toString();
        }
        ResourceBundle msg = AbstractReflectionBasedInternalService.getReflectionErrorBundle();
        String key = "Error.InvokingMethod.fmt.txt";
        String desc = DProUtil.formatString(msg, key, new Object[]{this.getName(), obj.getClass().getName(), m.getName(), text});
        throw new ServiceFailedException(desc, t);
    }
}

