/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.service.standard;

import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.ExternalProcessUtil;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.service.AbstractService;
import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

abstract class AbstractExternalProcessService
extends AbstractService {
    private String command;
    private String[] defaultArgs;
    private Map defaultEnvVars;
    private boolean appendDefaultEnvVars;
    private static final String ERROR_MSG = "com.sas.dpro.service.standard.AbstractExternalProcessService";

    public AbstractExternalProcessService(String name, String command) {
        this(name, command, null);
    }

    public AbstractExternalProcessService(String name, String command, String[] defaultArgs) {
        super(name);
        if (command == null) {
            ResourceBundle msg = ResourceBundle.getBundle(ERROR_MSG);
            String desc = msg.getString("Error.NullCommandValue.fmt.txt");
            desc = MessageFormat.format(desc, this.getName());
            throw new NullPointerException(desc);
        }
        this.command = command;
        this.defaultArgs = defaultArgs;
        this.setDefaultEnvVars(null, true);
    }

    protected String[] createCommandLineArray(String[] extraArgs) {
        int argc = 1 + (this.defaultArgs == null ? 0 : this.defaultArgs.length) + (extraArgs == null ? 0 : extraArgs.length);
        String[] cmdLine = new String[argc];
        int pos = 0;
        cmdLine[pos++] = this.getCommand();
        if (this.defaultArgs != null) {
            System.arraycopy(this.defaultArgs, 0, cmdLine, pos, this.defaultArgs.length);
            pos += this.defaultArgs.length;
        }
        if (extraArgs != null) {
            System.arraycopy(extraArgs, 0, cmdLine, pos, extraArgs.length);
        }
        return cmdLine;
    }

    public boolean getAppendDefaultEnvVars() {
        return this.appendDefaultEnvVars;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    public String[] getDefaultArgs() {
        return this.defaultArgs == null ? null : (String[])this.defaultArgs.clone();
    }

    public Map getDefaultEnvVars() {
        HashMap copy = null;
        if (this.defaultEnvVars != null) {
            copy = new HashMap(this.defaultEnvVars.size());
            copy.putAll(this.defaultEnvVars);
        }
        return copy;
    }

    public void setDefaultEnvVars(Map defaultEnvVars, boolean append) {
        this.defaultEnvVars = defaultEnvVars;
        this.appendDefaultEnvVars = append;
    }

    protected Process startProcess(String[] cmdLine, Map envVars, boolean appendEnvVars, File dir, boolean redirectStderr) throws ServiceFailedException {
        try {
            ProcessBuilder pb = new ProcessBuilder(cmdLine);
            pb.directory(dir);
            pb.redirectErrorStream(redirectStderr);
            if (appendEnvVars) {
                if (!this.getAppendDefaultEnvVars()) {
                    pb.environment().clear();
                }
                if (this.defaultEnvVars != null) {
                    pb.environment().putAll(this.defaultEnvVars);
                }
            }
            if (!appendEnvVars) {
                pb.environment().clear();
            }
            if (envVars != null) {
                pb.environment().putAll(envVars);
            }
            return pb.start();
        }
        catch (Exception e) {
            String errorMsg;
            ResourceBundle msg = ResourceBundle.getBundle(ERROR_MSG);
            if (DProUtil.osIsWindows() && (errorMsg = e.getMessage()) != null && errorMsg.startsWith("CreateProcess:")) {
                if (errorMsg.endsWith("error=193")) {
                    String desc = msg.getString("Error.Win32.InvalidExeFormat.fmt.txt");
                    desc = MessageFormat.format(desc, this.getName(), cmdLine[0]);
                    ServiceFailedException sfe = new ServiceFailedException(desc, e);
                    sfe.setCommandExecuted(ExternalProcessUtil.createCommandString(cmdLine));
                    throw sfe;
                }
                if (errorMsg.endsWith("error=2")) {
                    String desc = msg.getString("Error.Win32.FileNotFound.fmt.txt");
                    desc = MessageFormat.format(desc, this.getName(), cmdLine[0]);
                    ServiceFailedException sfe = new ServiceFailedException(desc, e);
                    sfe.setCommandExecuted(ExternalProcessUtil.createCommandString(cmdLine));
                    throw sfe;
                }
                if (errorMsg.endsWith("error=5")) {
                    String desc = msg.getString("Error.Win32.AccessIsDenied.fmt.txt");
                    desc = MessageFormat.format(desc, this.getName(), cmdLine[0]);
                    ServiceFailedException sfe = new ServiceFailedException(desc, e);
                    sfe.setCommandExecuted(ExternalProcessUtil.createCommandString(cmdLine));
                    throw sfe;
                }
            }
            String desc = msg.getString("Error.RuntimeExecFailed.fmt.txt");
            desc = MessageFormat.format(desc, this.getName(), cmdLine[0]);
            ServiceFailedException sfe = new ServiceFailedException(desc, e);
            sfe.setCommandExecuted(ExternalProcessUtil.createCommandString(cmdLine));
            throw sfe;
        }
    }
}

