/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.service;

import com.sas.dpro.common.DirList;
import com.sas.dpro.common.DirListImpl;
import com.sas.dpro.common.FileCollection;
import com.sas.dpro.common.FileList;
import com.sas.dpro.common.FileListImpl;
import com.sas.dpro.common.XmlUtil;
import com.sas.dpro.service.ServiceInfo;
import com.sas.dpro.service.ServiceInfoImpl;
import com.sas.dpro.service.ServiceResults;
import com.sas.dpro.service.ServiceResultsImpl;
import com.sas.dpro.service.ServiceResultsLogger;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

class ServiceResultsLoggerImpl
implements ServiceResultsLogger {
    private static final String LOG_XML_CHARSET = "UTF-8";
    private static final String COMMAND = "command";
    private static final String COMMAND_EXECUTED = "commandExecuted";
    private static final String CONTAINER_ID = "containerID";
    private static final String DEFAULT_TIMEOUT = "defaultTimeout";
    private static final String DESCRIPTION = "desc";
    private static final String FILE = "file";
    private static final String ID = "id";
    private static final String INTERNAL_SERVICE = "internalService";
    private static final String KEYWORDS = "keywords";
    private static final String NAME = "name";
    private static final String OUTPUT_DIRS = "outputDirs";
    private static final String OUTPUT_FILES = "outputFiles";
    private static final String OUTPUT_STREAMS_CAPTURED = "outputStreamsCaptured";
    private static final String RESULTS_ID = "resultsID";
    private static final String RETURN_CODE = "returnCode";
    private static final String ROOT = "root";
    private static final String ROOT_ELEMENT = "ServiceResults";
    private static final String SERVER = "server";
    private static final String SERVICE_INFO = "serviceInfo";
    private static final String STATUS = "status";
    private static final String STDERR = "stderr";
    private static final String STDERR_REDIRECTED = "stderrRedirected";
    private static final String STDOUT = "stdout";
    private static final String TIME = "time";

    private void addFileCollection(Document doc, Element root, String name, FileCollection fc) {
        Element elem = doc.createElement(name);
        if (fc != null) {
            if (fc.getID() != null) {
                elem.setAttribute(ID, fc.getID());
            }
            if (fc.getRoot() != null) {
                elem.setAttribute(ROOT, fc.getRoot());
            }
            String server = fc.getProvider();
            elem.setAttribute(SERVER, server);
            for (int i = 0; i < fc.getSize(); ++i) {
                Element elem2 = doc.createElement(FILE);
                elem2.appendChild(doc.createCDATASection(fc.get(i)));
                elem.appendChild(elem2);
            }
        }
        root.appendChild(elem);
    }

    private String getElementAttribute(Element elem, String attrName) {
        Attr attr = elem.getAttributeNode(attrName);
        return attr == null ? null : attr.getNodeValue();
    }

    private String getElementText(Element elem) {
        String text = null;
        NodeList children = elem.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Text)) continue;
            text = text == null ? child.getNodeValue() : text + child.getNodeValue();
        }
        return text;
    }

    @Override
    public ServiceResults read(String file) throws Exception {
        String commandExecuted = null;
        String containerID = null;
        ServiceInfoImpl info = null;
        int outputStreamsCaptured = 0;
        String resultsID = null;
        int returnCode = 0;
        int status = 0;
        String stderr = null;
        String stdout = null;
        boolean stderrRedirected = false;
        long time = -1L;
        DirListImpl dirList = null;
        FileListImpl fileList = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource(new BufferedInputStream(new FileInputStream(file)));
        is.setEncoding(LOG_XML_CHARSET);
        Document doc = db.parse(is);
        Element root = doc.getDocumentElement();
        NodeList childNodes = root.getChildNodes();
        block8: for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            switch (child.getNodeType()) {
                case 1: {
                    Element temp;
                    int j;
                    String id;
                    Element elem = (Element)child;
                    String elemName = elem.getNodeName();
                    if (COMMAND_EXECUTED.equals(elemName)) {
                        commandExecuted = this.getElementText(elem);
                        continue block8;
                    }
                    if (CONTAINER_ID.equals(elemName)) {
                        containerID = this.getElementText(elem);
                        continue block8;
                    }
                    if (OUTPUT_DIRS.equals(elemName)) {
                        String dlRoot = this.getElementAttribute(elem, ROOT);
                        if (dlRoot == null) continue block8;
                        id = this.getElementAttribute(elem, ID);
                        String server = this.getElementAttribute(elem, SERVER);
                        dirList = new DirListImpl(dlRoot, server, id);
                        NodeList dirNodes = elem.getElementsByTagName(FILE);
                        for (j = 0; j < dirNodes.getLength(); ++j) {
                            temp = (Element)dirNodes.item(j);
                            dirList.add(this.getElementText(temp));
                        }
                        continue block8;
                    }
                    if (OUTPUT_FILES.equals(elemName)) {
                        String flRoot = this.getElementAttribute(elem, ROOT);
                        if (flRoot == null) continue block8;
                        id = this.getElementAttribute(elem, ID);
                        String server = this.getElementAttribute(elem, SERVER);
                        fileList = new FileListImpl(flRoot, server, id);
                        NodeList fileNodes = elem.getElementsByTagName(FILE);
                        for (j = 0; j < fileNodes.getLength(); ++j) {
                            temp = (Element)fileNodes.item(j);
                            fileList.add(this.getElementText(temp));
                        }
                        continue block8;
                    }
                    if (OUTPUT_STREAMS_CAPTURED.equals(elemName)) {
                        outputStreamsCaptured = Integer.parseInt(this.getElementText(elem));
                        continue block8;
                    }
                    if (RESULTS_ID.equals(elemName)) {
                        resultsID = this.getElementText(elem);
                        continue block8;
                    }
                    if (RETURN_CODE.equals(elemName)) {
                        returnCode = Integer.parseInt(this.getElementText(elem));
                        continue block8;
                    }
                    if (SERVICE_INFO.equals(elemName)) {
                        String command = null;
                        String desc = null;
                        long defaultTimeout = -1L;
                        boolean internalService = false;
                        String keywords = null;
                        String server = null;
                        String name = null;
                        NodeList temp2 = elem.getChildNodes();
                        block11: for (int j2 = 0; j2 < temp2.getLength(); ++j2) {
                            child = temp2.item(j2);
                            switch (child.getNodeType()) {
                                case 1: {
                                    elem = (Element)child;
                                    elemName = elem.getNodeName();
                                    if (elemName.equals(COMMAND)) {
                                        command = this.getElementText(elem);
                                        continue block11;
                                    }
                                    if (elemName.equals(DEFAULT_TIMEOUT)) {
                                        String s = this.getElementText(elem);
                                        try {
                                            defaultTimeout = Long.parseLong(s);
                                        }
                                        catch (NumberFormatException numberFormatException) {}
                                        continue block11;
                                    }
                                    if (elemName.equals(DESCRIPTION)) {
                                        desc = this.getElementText(elem);
                                        continue block11;
                                    }
                                    if (elemName.equals(INTERNAL_SERVICE)) {
                                        internalService = Boolean.parseBoolean(this.getElementText(elem));
                                        continue block11;
                                    }
                                    if (elemName.equals(SERVER)) {
                                        server = this.getElementText(elem);
                                        continue block11;
                                    }
                                    if (elemName.equals(KEYWORDS)) {
                                        keywords = this.getElementText(elem);
                                        continue block11;
                                    }
                                    if (!elemName.equals(NAME)) continue block11;
                                    name = this.getElementText(elem);
                                    continue block11;
                                }
                            }
                        }
                        info = new ServiceInfoImpl(name, desc, defaultTimeout, server, keywords);
                        info.setCommand(command);
                        info.setIsInternalService(internalService);
                        continue block8;
                    }
                    if (STATUS.equals(elemName)) {
                        status = Integer.parseInt(this.getElementText(elem));
                        continue block8;
                    }
                    if (STDERR.equals(elemName)) {
                        stderr = XmlUtil.getAllChildText(elem);
                        continue block8;
                    }
                    if (STDERR_REDIRECTED.equals(elemName)) {
                        stderrRedirected = Boolean.parseBoolean(this.getElementText(elem));
                        continue block8;
                    }
                    if (STDOUT.equals(elemName)) {
                        stdout = XmlUtil.getAllChildText(elem);
                        continue block8;
                    }
                    if (!TIME.equals(elemName)) continue block8;
                    time = Long.parseLong(this.getElementText(elem));
                    continue block8;
                }
            }
        }
        ServiceResultsImpl results = new ServiceResultsImpl(info, containerID, fileList, 0);
        results.setCommandExecuted(commandExecuted);
        results.setOutputDirs(dirList);
        results.setOutputStreamsCaptured(outputStreamsCaptured);
        results.setResultsID(resultsID);
        results.setReturnCode(returnCode);
        results.setStatus(status);
        results.setStderr(stderr);
        results.setStderrRedirected(stderrRedirected);
        results.setStdout(stdout);
        results.setTime(time);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String file, ServiceResults results) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.getDOMImplementation().createDocument(null, ROOT_ELEMENT, null);
        Element root = doc.getDocumentElement();
        Element elem = doc.createElement(COMMAND_EXECUTED);
        String command = results.getCommandExecuted();
        if (command != null) {
            elem.appendChild(doc.createCDATASection(command));
        }
        root.appendChild(elem);
        elem = doc.createElement(CONTAINER_ID);
        String contID = results.getContainerContextID();
        if (contID != null) {
            elem.appendChild(doc.createCDATASection(contID));
        }
        root.appendChild(elem);
        DirList outputDirs = results.getOutputDirs();
        this.addFileCollection(doc, root, OUTPUT_DIRS, outputDirs);
        FileList outputFiles = results.getOutputFiles();
        this.addFileCollection(doc, root, OUTPUT_FILES, outputFiles);
        elem = doc.createElement(OUTPUT_STREAMS_CAPTURED);
        int captured = results.getOutputStreamsCaptured();
        elem.appendChild(doc.createCDATASection("" + captured));
        root.appendChild(elem);
        elem = doc.createElement(RESULTS_ID);
        String resultsID = results.getResultsID();
        if (resultsID != null) {
            elem.appendChild(doc.createCDATASection(resultsID));
        }
        root.appendChild(elem);
        elem = doc.createElement(RETURN_CODE);
        int rc = results.getReturnCode();
        elem.appendChild(doc.createCDATASection("" + rc));
        root.appendChild(elem);
        ServiceInfo info = results.getServiceInfo();
        elem = doc.createElement(SERVICE_INFO);
        command = info.getCommand();
        Element elem2 = doc.createElement(COMMAND);
        if (command != null) {
            elem2.appendChild(doc.createCDATASection(command));
        }
        elem.appendChild(elem2);
        long defaultTimeout = info.getDefaultTimeout();
        elem2 = doc.createElement(DEFAULT_TIMEOUT);
        elem2.appendChild(doc.createCDATASection("" + defaultTimeout));
        elem.appendChild(elem2);
        String description = info.getDescription();
        elem2 = doc.createElement(DESCRIPTION);
        if (description != null) {
            elem2.appendChild(doc.createCDATASection(description));
        }
        elem.appendChild(elem2);
        boolean internalService = info.isInternalService();
        elem2 = doc.createElement(INTERNAL_SERVICE);
        elem2.appendChild(doc.createCDATASection("" + internalService));
        elem.appendChild(elem2);
        String host = info.getHost();
        elem2 = doc.createElement(SERVER);
        if (host != null) {
            elem2.appendChild(doc.createCDATASection(host));
        }
        elem.appendChild(elem2);
        String keywords = info.getKeywords();
        elem2 = doc.createElement(KEYWORDS);
        if (keywords != null) {
            elem2.appendChild(doc.createCDATASection(keywords));
        }
        elem.appendChild(elem2);
        String name = info.getName();
        elem2 = doc.createElement(NAME);
        if (name != null) {
            elem2.appendChild(doc.createCDATASection(name));
        }
        elem.appendChild(elem2);
        root.appendChild(elem);
        name = results.getServiceName();
        elem = doc.createElement(NAME);
        if (name != null) {
            elem.appendChild(doc.createCDATASection(name));
        }
        root.appendChild(elem);
        elem = doc.createElement(STATUS);
        int status = results.getStatus();
        elem.appendChild(doc.createCDATASection("" + status));
        root.appendChild(elem);
        XmlUtil.addTagWithTextContent(doc, root, STDERR, results.getStderr());
        elem = doc.createElement(STDERR_REDIRECTED);
        boolean redirected = results.getStderrRedirected();
        elem.appendChild(doc.createCDATASection("" + redirected));
        root.appendChild(elem);
        XmlUtil.addTagWithTextContent(doc, root, STDOUT, results.getStdout());
        elem = doc.createElement(TIME);
        elem.appendChild(doc.createCDATASection("" + results.getTime()));
        root.appendChild(elem);
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), LOG_XML_CHARSET));
        try {
            StreamResult result = new StreamResult(w);
            DOMSource source = new DOMSource(doc);
            TransformerFactory transFac = TransformerFactory.newInstance();
            Transformer transformer = transFac.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", LOG_XML_CHARSET);
            transformer.transform(source, result);
        }
        finally {
            w.close();
            w = null;
        }
    }
}

