/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.service;

import com.sas.dpro.common.SerializableHashMap;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.common.ServiceNotAvailableException;
import com.sas.dpro.provider.ProviderFactory;
import com.sas.dpro.service.DProService;
import com.sas.dpro.service.ServiceFileParser;
import com.sas.dpro.service.ServiceInfo;
import com.sas.dpro.service.ServiceInfoImpl;
import com.sas.dpro.service.ServiceParmsImpl;
import com.sas.dpro.service.standard.ExternalProcessService;
import com.sas.dpro.service.standard.StandardServiceNames;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class ServiceFactory
implements StandardServiceNames {
    private HashMap serviceMap;
    private static final String BUNDLE = "com.sas.dpro.service.ServiceFactory";
    private static final ResourceBundle msg = ResourceBundle.getBundle("com.sas.dpro.service.ServiceFactory");
    private static final ServiceFactory INSTANCE = new ServiceFactory();
    private static final String EXTERNAL_PROCESS_SERVICE_CLASS_NAME = "com.sas.dpro.service.standard.ExternalProcessService";

    private ServiceFactory() {
        Object[] chmodCtorParms = null;
        if (System.getProperty("com.sas.dpro.service.standard.Chmod.command") != null) {
            chmodCtorParms = new String[]{System.getProperty("com.sas.dpro.service.standard.Chmod.command")};
        }
        this.serviceMap = new HashMap();
        String root = "com.sas.dpro.service.standard.";
        this.addServiceMapping("ChangeEncoding", null, true, 0L, root + "ChangeEncoding");
        this.addServiceMapping("Checksum", null, true, 0L, root + "Checksum");
        this.addServiceMapping("Chmod", null, true, 0L, root + "Chmod", chmodCtorParms, null, true, null, null);
        this.addServiceMapping("Copy", null, true, 0L, root + "Copy");
        this.addServiceMapping("Delete", null, true, 0L, root + "Delete");
        this.addServiceMapping("Echo", null, true, 0L, root + "Echo");
        this.addServiceMapping("Format", null, true, 0L, root + "Format");
        this.addServiceMapping("Ftp", null, true, 0L, root + "Ftp");
        this.addServiceMapping("Groovy", null, true, 0L, root + "Groovy");
        this.addServiceMapping("Mail", null, true, 0L, root + "Mail");
        this.addServiceMapping("MakeDir", null, true, 0L, root + "MakeDir");
        this.addServiceMapping("PingDProServer", null, true, 0L, root + "PingDProServer");
        this.addServiceMapping("Sleep", null, true, 0L, root + "Sleep");
        this.addServiceMapping("TempFile", null, true, 0L, root + "TempFile");
        this.addServiceMapping("Unzip", null, true, 0L, root + "Unzip");
        this.addServiceMapping("Update", null, true, 0L, root + "Update");
        this.addServiceMapping("WorkspaceJob", null, true, 0L, root + "WorkspaceJob");
        this.addServiceMapping("Xslt", null, true, 0L, root + "Xslt");
        this.addServiceMapping("Zip", null, true, 0L, root + "Zip");
    }

    public void addServiceMapping(String serviceName, String serviceDesc, boolean internal, long defaultTimeout, String serviceClassName) {
        this.addServiceMapping(serviceName, serviceDesc, internal, defaultTimeout, serviceClassName, null, null, true, null, null);
    }

    public void addServiceMapping(String serviceName, String serviceDesc, boolean internal, long defaultTimeout, String serviceClassName, Object[] ctorParams, Map envVars, boolean appendEnvVars, Map serviceParams, String keywords) {
        if (this.serviceMap.containsKey(serviceName)) {
            String desc = msg.getString("Error.ServiceAlreadyDefined.fmt.txt");
            desc = MessageFormat.format(desc, serviceName);
            new Exception(desc).printStackTrace();
        }
        if (serviceClassName == null) {
            serviceClassName = EXTERNAL_PROCESS_SERVICE_CLASS_NAME;
        }
        String command = null;
        if (EXTERNAL_PROCESS_SERVICE_CLASS_NAME.equals(serviceClassName) && ctorParams != null && ctorParams.length >= 2 && ctorParams[1] instanceof String) {
            command = (String)ctorParams[1];
        }
        ExtendedServiceInfoImpl info = new ExtendedServiceInfoImpl(serviceName, serviceDesc, defaultTimeout, serviceClassName, ctorParams, envVars, appendEnvVars, serviceParams, keywords);
        info.setCommand(command);
        info.setIsInternalService(internal);
        this.serviceMap.put(serviceName, info);
    }

    public void addServiceMappings(String serviceFileName) throws IOException {
        ServiceFileParser.parse(this, serviceFileName);
    }

    public DProService createService(String serviceName) throws ServiceFailedException {
        DProService service = null;
        ExtendedServiceInfoImpl info = (ExtendedServiceInfoImpl)this.serviceMap.get(serviceName);
        if (info != null) {
            try {
                int paramCount;
                Class clazz = info.getServiceClass();
                Object[] ctorParams = info.getCtorParameters();
                int n = paramCount = ctorParams == null ? 0 : ctorParams.length;
                if (paramCount == 0) {
                    service = (DProService)clazz.newInstance();
                }
                Class[] paramTypes = info.getCtorParameterTypes();
                Constructor ctor = ServiceFactory.getClosestConstructor(clazz, paramTypes);
                service = (DProService)ctor.newInstance(ctorParams);
            }
            catch (ExceptionInInitializerError eiie) {
                String desc = msg.getString("Error.ClassInstantiation.fmt.txt");
                String param = eiie.getMessage();
                if (param == null) {
                    param = eiie.toString();
                }
                desc = MessageFormat.format(desc, serviceName, param);
                throw new ServiceFailedException(desc, eiie);
            }
            catch (Exception e) {
                String desc = msg.getString("Error.ClassInstantiation.fmt.txt");
                String param = e.getMessage();
                if (param == null) {
                    param = e.toString();
                }
                desc = MessageFormat.format(desc, serviceName, param);
                throw new ServiceFailedException(desc, e);
            }
        } else {
            String desc = msg.getString("Error.NoSuchServiceDefined.fmt.txt");
            desc = MessageFormat.format(desc, serviceName);
            throw new ServiceNotAvailableException(desc);
        }
        Map serviceParmsMap = info.getServiceParameters();
        ServiceParmsImpl spi = new ServiceParmsImpl();
        if (serviceParmsMap != null) {
            SerializableHashMap mapCopy = new SerializableHashMap();
            mapCopy.putAll(serviceParmsMap);
            spi.params = mapCopy;
        }
        service.setDefaultTimeout(info.getDefaultTimeout());
        service.setDescription(info.getDescription());
        service.setFileIOBufferSize(-1);
        service.setHost(info.getHost());
        service.setKeywords(info.getKeywords());
        service.setParameters(spi);
        if (service instanceof ExternalProcessService) {
            ExternalProcessService eps = (ExternalProcessService)service;
            eps.setDefaultEnvVars(info.getEnvVars(), info.getAppendEnvVars());
        }
        return service;
    }

    public static Constructor getClosestConstructor(Class motherClass, Class[] pars) {
        Constructor<?>[] ctors = motherClass.getConstructors();
        for (int i = 0; i < ctors.length; ++i) {
            Class<?>[] cpars = ctors[i].getParameterTypes();
            if (cpars.length != pars.length) continue;
            boolean found = true;
            for (int j = 0; j < cpars.length; ++j) {
                if (cpars[j].isAssignableFrom(pars[j])) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return ctors[i];
        }
        return null;
    }

    public static ServiceFactory getInstance() {
        return INSTANCE;
    }

    public ServiceInfo getServiceInfo(String service) {
        ExtendedServiceInfoImpl orig;
        ServiceInfo info = null;
        if (service != null && (orig = (ExtendedServiceInfoImpl)this.serviceMap.get(service)) != null) {
            info = orig.createStandardServiceInfo();
        }
        return info;
    }

    public List getServiceInfosMatchingKeywords(String[] keywords) {
        ArrayList<ServiceInfo> infoList = new ArrayList<ServiceInfo>();
        Set keySet = this.serviceMap.keySet();
        for (String key : keySet) {
            ExtendedServiceInfoImpl info = (ExtendedServiceInfoImpl)this.serviceMap.get(key);
            if (keywords != null && !info.matchesKeywords(keywords)) continue;
            ServiceInfo temp = info.createStandardServiceInfo();
            infoList.add(temp);
        }
        return infoList;
    }

    public boolean isServiceAvailable(String serviceName) {
        return serviceName == null ? true : this.serviceMap.containsKey(serviceName);
    }

    static class ExtendedServiceInfoImpl
    extends ServiceInfoImpl {
        private String clazzName;
        private Class clazz;
        private Object[] ctorParameters;
        private Class[] paramTypes;
        private Map envVars;
        private boolean appendEnvVars;
        private Map serviceParams;
        private static final long serialVersionUID = 1L;

        public ExtendedServiceInfoImpl(String name, String desc, long defaultTimeout, String className, Object[] ctorParameters, Map envVars, boolean appendEnvVars, Map serviceParams, String keywords) {
            super(name, desc, defaultTimeout, null, keywords);
            this.clazzName = className;
            this.ctorParameters = ctorParameters;
            this.envVars = envVars;
            this.appendEnvVars = appendEnvVars;
            this.serviceParams = serviceParams;
        }

        public ServiceInfo createStandardServiceInfo() {
            ServiceInfoImpl temp = new ServiceInfoImpl(this.getName(), this.getDescription(), this.getDefaultTimeout(), this.getHost(), this.getKeywords());
            temp.setCommand(this.getCommand());
            temp.setIsInternalService(this.isInternalService());
            return temp;
        }

        public boolean getAppendEnvVars() {
            return this.appendEnvVars;
        }

        public int getCtorParameterCount() {
            return this.ctorParameters == null ? 0 : this.ctorParameters.length;
        }

        public Object[] getCtorParameters() {
            return this.ctorParameters;
        }

        public synchronized Class[] getCtorParameterTypes() {
            if (this.paramTypes == null && this.getCtorParameterCount() > 0) {
                int paramCount = this.getCtorParameterCount();
                this.paramTypes = new Class[paramCount];
                for (int i = 0; i < paramCount; ++i) {
                    this.paramTypes[i] = this.ctorParameters[i].getClass();
                }
            }
            return this.paramTypes;
        }

        public Map getEnvVars() {
            return this.envVars;
        }

        @Override
        public String getHost() {
            return ProviderFactory.getLocalProviderName();
        }

        public synchronized Class getServiceClass() throws ClassNotFoundException, ExceptionInInitializerError {
            if (this.clazz == null) {
                this.clazz = Class.forName(this.clazzName);
            }
            return this.clazz;
        }

        public Map getServiceParameters() {
            return this.serviceParams;
        }
    }
}

