/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.results.testing;

import com.sas.dpro.common.XmlUtil;
import com.sas.dpro.formatter.FormatterWritable;
import com.sas.dpro.results.InvalidResultFileException;
import com.sas.dpro.results.testing.ResultBase;
import com.sas.dpro.results.testing.TestResult;
import com.sas.dpro.results.testing.TestResultsReportInfo;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestSuiteResult
extends ResultBase
implements FormatterWritable {
    private String type;
    private String command;
    private String provider;
    private List testResults;
    private TestResultsReportInfo reportInfo;
    private long startTime;
    private long endTime;
    private static final String MSG = "com.sas.dpro.results.testing.TestSuiteResult";
    private static final String ROOT_ELEMENT = "TestSuiteResults";

    public TestSuiteResult() {
        this(null, null, null);
    }

    public TestSuiteResult(String name, String desc, String server) {
        this.setName(name);
        this.setDescription(desc);
        this.setProvider(server);
        this.testResults = new ArrayList();
    }

    private void addFieldElem(Document doc, Element parent, String data, boolean value) {
        Element temp = doc.createElement("field");
        temp.setAttribute("data", "numberTests");
        temp.appendChild(doc.createCDATASection("" + value));
        parent.appendChild(temp);
    }

    private void addParamElem(Document doc, Element parent, String name, String value) {
        Element paramElem = doc.createElement("param");
        paramElem.setAttribute("name", name);
        paramElem.setTextContent(value);
        parent.appendChild(paramElem);
    }

    public void addTestResult(TestResult testResult) {
        this.testResults.add(testResult);
    }

    public String getCommand() {
        return this.command;
    }

    private int getCountImpl(int testStatus) {
        int count = 0;
        for (TestResult tr : this.testResults) {
            if (tr.getResult() != testStatus) continue;
            ++count;
        }
        return count;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public int getErrorCount() {
        return this.getCountImpl(2);
    }

    public int getFailureCount() {
        return this.getCountImpl(1);
    }

    public int getPassCount() {
        return this.getCountImpl(0);
    }

    public String getProvider() {
        return this.provider;
    }

    public TestResultsReportInfo getReportInfo() {
        return this.reportInfo;
    }

    @Override
    public String getRootElementName() {
        return ROOT_ELEMENT;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public int getTestResultCount() {
        return this.testResults.size();
    }

    public TestResult getTestResult(int index) {
        return (TestResult)this.testResults.get(index);
    }

    public int getTimeoutCount() {
        return this.getCountImpl(3);
    }

    public String getType() {
        return this.type;
    }

    public int getWarningCount() {
        return this.getCountImpl(4);
    }

    @Override
    public void read(Document doc, Element root) throws InvalidResultFileException {
        NodeList childNodes = root.getChildNodes();
        block7: for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            switch (child.getNodeType()) {
                case 1: {
                    Element elem = (Element)child;
                    String name = elem.getNodeName();
                    if ("params".equals(name)) {
                        NodeList paramNodes = elem.getElementsByTagName("param");
                        for (int j = 0; j < paramNodes.getLength(); ++j) {
                            long time;
                            Element elem2 = (Element)paramNodes.item(j);
                            String paramName = elem2.getAttribute("name");
                            String paramValue = XmlUtil.getAllChildText(elem2);
                            if ("command".equals(paramName)) {
                                this.setCommand(paramValue);
                                continue;
                            }
                            if ("desc".equals(paramName)) {
                                this.setDescription(paramValue);
                                continue;
                            }
                            if ("endTime".equals(paramName)) {
                                time = -1L;
                                try {
                                    time = Long.parseLong(paramValue);
                                    this.setEndTime(time);
                                }
                                catch (NumberFormatException numberFormatException) {}
                                continue;
                            }
                            if ("name".equals(paramName)) {
                                this.setName(paramValue);
                                continue;
                            }
                            if ("server".equals(paramName)) {
                                this.setProvider(paramValue);
                                continue;
                            }
                            if ("startTime".equals(paramName)) {
                                time = -1L;
                                try {
                                    time = Long.parseLong(paramValue);
                                    this.setStartTime(time);
                                }
                                catch (NumberFormatException numberFormatException) {}
                                continue;
                            }
                            if (!"type".equals(paramName)) continue;
                            this.setType(paramValue);
                        }
                        continue block7;
                    }
                    if ("testResult".equals(name)) {
                        TestResult tr = new TestResult(null);
                        tr.read(doc, elem);
                        this.addTestResult(tr);
                        continue block7;
                    }
                    if ("reportInfo".equals(name)) {
                        TestResultsReportInfo info = new TestResultsReportInfo();
                        NodeList grandkids = elem.getElementsByTagName("field");
                        for (int j = 0; j < grandkids.getLength(); ++j) {
                            Element elem2 = (Element)grandkids.item(j);
                            String field = elem2.getAttribute("data");
                            String visibleStr = elem2.getTextContent();
                            boolean show = Boolean.valueOf(visibleStr);
                            if ("numberTests".equals(field)) {
                                info.setNumberTestsOnMainPage(show);
                                continue;
                            }
                            if ("detailedInfo".equals(field)) {
                                info.setShowDetailedTestInfo(show);
                                continue;
                            }
                            if ("showTestAssocFilesOnMainPage".equals(field)) {
                                info.setShowTestAssociatedFilesOnMainPage(show);
                                continue;
                            }
                            if ("showTestAssocFilesOnTestPages".equals(field)) {
                                info.setShowTestAssociatedFilesOnTestPages(show);
                                continue;
                            }
                            if ("showTestCommandsOnMainPage".equals(field)) {
                                info.setShowTestCommandsOnMainPage(show);
                                continue;
                            }
                            if ("showTestCommandsOnTestPages".equals(field)) {
                                info.setShowTestCommandsOnTestPages(show);
                                continue;
                            }
                            if ("showTestDescsOnMainPage".equals(field)) {
                                info.setShowTestDescriptionsOnMainPage(show);
                                continue;
                            }
                            if ("showTestDescsOnTestPages".equals(field)) {
                                info.setShowTestDescriptionsOnTestPages(show);
                                continue;
                            }
                            if ("showTestRCsOnMainPage".equals(field)) {
                                info.setShowTestRCsOnMainPage(show);
                                continue;
                            }
                            if ("showTestRCsOnTestPages".equals(field)) {
                                info.setShowTestRCsOnTestPages(show);
                                continue;
                            }
                            if ("showTestSuiteAssocFilesOnMainPage".equals(field)) {
                                info.setShowTestSuiteAssociatedFilesOnMainPage(show);
                                continue;
                            }
                            if ("showTestSuiteCommandOnMainPage".equals(field)) {
                                info.setShowTestSuiteCommandOnMainPage(show);
                                continue;
                            }
                            if ("showTestSuiteDescOnMainPage".equals(field)) {
                                info.setShowTestSuiteDescriptionOnMainPage(show);
                                continue;
                            }
                            if ("showTestSuiteStderrOnMainPage".equals(field)) {
                                info.setShowTestSuiteStderrOnMainPage(show);
                                continue;
                            }
                            if ("showTestSuiteStdoutOnMainPage".equals(field)) {
                                info.setShowTestSuiteStdoutOnMainPage(show);
                                continue;
                            }
                            if ("showTestSuiteTimeOnMainPage".equals(field)) {
                                info.setShowTestSuiteTimeOnMainPage(show);
                                continue;
                            }
                            if ("showTestTimesOnMainPage".equals(field)) {
                                info.setShowTestTimesOnMainPage(show);
                                continue;
                            }
                            if ("showTestTimesOnTestPages".equals(field)) {
                                info.setShowTestTimesOnTestPages(show);
                                continue;
                            }
                            ResourceBundle msg = ResourceBundle.getBundle(MSG);
                            String desc = msg.getString("Error.ReportInfo.InvalidValue.fmt.txt");
                            desc = MessageFormat.format(desc, field);
                            throw new InvalidResultFileException(desc);
                        }
                        this.setReportInfo(info);
                        continue block7;
                    }
                    if ("stdout".equals(name)) {
                        this.setStdout(XmlUtil.getAllChildText(elem));
                        continue block7;
                    }
                    if (!"stderr".equals(name)) continue block7;
                    this.setStderr(XmlUtil.getAllChildText(elem));
                    continue block7;
                }
            }
        }
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    protected void setProvider(String provider) {
        this.provider = provider;
    }

    public void setReportInfo(TestResultsReportInfo reportInfo) {
        this.reportInfo = reportInfo;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void write(Document doc, Element parent) {
        Element paramsElem = doc.createElement("params");
        parent.appendChild(paramsElem);
        if (this.getCommand() != null) {
            this.addParamElem(doc, paramsElem, "command", this.getCommand());
        }
        this.addParamElem(doc, paramsElem, "desc", this.getDescription());
        this.addParamElem(doc, paramsElem, "name", this.getName());
        this.addParamElem(doc, paramsElem, "server", this.getProvider());
        if (this.getStartTime() > -1L && this.getEndTime() > -1L) {
            long time = this.getEndTime() - this.getStartTime();
            this.addParamElem(doc, paramsElem, "time", "" + time);
        }
        if (this.getType() != null) {
            this.addParamElem(doc, paramsElem, "type", this.getType());
        }
        for (int i = 0; i < this.getTestResultCount(); ++i) {
            this.getTestResult(i).write(doc, parent);
        }
        TestResultsReportInfo info = this.getReportInfo();
        if (info == null) {
            info = new TestResultsReportInfo();
        }
        Element elem = doc.createElement("reportInfo");
        this.addFieldElem(doc, elem, "numberTests", info.getNumberTestsOnMainPage());
        this.addFieldElem(doc, elem, "detailedInfo", info.getShowDetailedTestInfo());
        this.addFieldElem(doc, elem, "showTestAssocFilesOnMainPage", info.getShowTestAssociatedFilesOnMainPage());
        this.addFieldElem(doc, elem, "showTestAssocFilesOnTestPages", info.getShowTestAssociatedFilesOnTestPages());
        this.addFieldElem(doc, elem, "showTestCommandsOnMainPage", info.getShowTestCommandsOnMainPage());
        this.addFieldElem(doc, elem, "showTestCommandsOnTestPages", info.getShowTestCommandsOnTestPages());
        this.addFieldElem(doc, elem, "showTestDescsOnMainPage", info.getShowTestDescriptionsOnMainPage());
        this.addFieldElem(doc, elem, "showTestDescsOnTestPages", info.getShowTestDescriptionsOnTestPages());
        this.addFieldElem(doc, elem, "showTestRCsOnMainPage", info.getShowTestRCsOnMainPage());
        this.addFieldElem(doc, elem, "showTestRCsOnTestPages", info.getShowTestRCsOnTestPages());
        this.addFieldElem(doc, elem, "showTestSuiteAssocFilesOnMainPage", info.getShowTestSuiteAssociatedFilesOnMainPage());
        this.addFieldElem(doc, elem, "showTestSuiteCommandOnMainPage", info.getShowTestSuiteCommandOnMainPage());
        this.addFieldElem(doc, elem, "showTestSuiteDescOnMainPage", info.getShowTestSuiteDescriptionOnMainPage());
        this.addFieldElem(doc, elem, "showTestSuiteStderrOnMainPage", info.getShowTestSuiteStderrOnMainPage());
        this.addFieldElem(doc, elem, "showTestSuiteStdoutOnMainPage", info.getShowTestSuiteStdoutOnMainPage());
        this.addFieldElem(doc, elem, "showTestSuiteTimeOnMainPage", info.getShowTestSuiteTimeOnMainPage());
        this.addFieldElem(doc, elem, "showTestTimesOnMainPage", info.getShowTestTimesOnMainPage());
        this.addFieldElem(doc, elem, "showTestTimesOnTestPages", info.getShowTestTimesOnTestPages());
        XmlUtil.addTagWithTextContent(doc, parent, "stdout", this.getStdout());
        XmlUtil.addTagWithTextContent(doc, parent, "stderr", this.getStderr());
    }
}

