/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.results;

import com.sas.dpro.results.FormattedResults;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;

public class FormattedResultsImpl
implements FormattedResults {
    private String resultsID;
    private File file;
    private PrintWriter w;

    public FormattedResultsImpl(String id, File file) throws IOException {
        this.resultsID = id;
        this.file = file;
        FileOutputStream out = new FileOutputStream(file);
        try {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
            this.w = new PrintWriter((Writer)bw, true);
        }
        catch (IOException ioe) {
            out.close();
            throw ioe;
        }
    }

    @Override
    public void append(String xml) {
        this.w.println(xml);
    }

    @Override
    public void end() {
        this.w.close();
        this.w = null;
    }

    @Override
    public File getDirectory() {
        return this.file.getParentFile();
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public boolean getHasCompleted() {
        return this.w == null;
    }

    @Override
    public String getResultsID() {
        return this.resultsID;
    }

    public String toString() {
        return "[FormattedResultsImpl: file=" + this.getFile().getAbsolutePath() + "; resultsID=" + this.getResultsID() + "; hasCompleted=" + this.getHasCompleted() + "]";
    }
}

