/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.reporting.testing;

import com.sas.dpro.common.DProUtil;
import com.sas.dpro.reporting.ReportMakerResults;
import com.sas.dpro.reporting.ReportMakerResultsImpl;
import com.sas.dpro.reporting.testing.AbstractTestingReportMaker;
import com.sas.dpro.results.FormattedResults;
import com.sas.dpro.results.testing.AssociatedFile;
import com.sas.dpro.results.testing.TestResult;
import com.sas.dpro.results.testing.TestResultsReportInfo;
import com.sas.dpro.results.testing.TestSuiteResult;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestingTextReportMaker
extends AbstractTestingReportMaker {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReportMakerResults createReport(FormattedResults results, File reportDir, Charset cs) throws IOException {
        this.debugPrint("TestingTextReportMaker.createReport(): Entering");
        cs = this.ensureValidCharset(cs);
        this.debugPrint("... Report encoding: " + cs.displayName());
        this.debugPrint("... Creating metadata file");
        this.createReportMetadataFile(reportDir, results, cs);
        this.debugPrint("... Parsing TestSuiteResult from XML");
        Document doc = DProUtil.getDocumentFromResults(results);
        Element root = doc.getDocumentElement();
        TestSuiteResult tsr = new TestSuiteResult();
        tsr.read(doc, root);
        this.debugPrint("... Creating main report file, index.txt");
        File file = new File(reportDir, "index.txt");
        PrintWriter w = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), cs)));
        try {
            TestResultsReportInfo info = tsr.getReportInfo();
            if (info == null) {
                info = new TestResultsReportInfo();
            }
            String runTime = this.getRunTime(tsr);
            w.println(this.getString("TestSuiteResult.TitleColon.txt"));
            w.println();
            w.print(this.getString("TestSuite.Header.TestSuite.txt"));
            w.println("\t" + tsr.getName());
            w.print(this.getString("TestSuite.Header.Description.txt"));
            w.println("\t" + tsr.getDescription());
            w.print(this.getString("TestSuite.Header.Server.txt"));
            w.println("\t\t" + tsr.getProvider());
            if (info.getShowTestSuiteTimeOnMainPage()) {
                w.print(this.getString("TestSuite.Header.RunTime.txt"));
                w.println("\t" + runTime);
            }
            w.print(this.getString("TestSuite.Header.TestRunCount.txt"));
            w.println("\t" + tsr.getTestResultCount());
            w.print(this.getString("TestSuite.Header.TestPassCount.txt"));
            w.println("\t\t" + tsr.getPassCount());
            w.print(this.getString("TestSuite.Header.TestFailCount.txt"));
            w.println("\t" + tsr.getFailureCount());
            w.print(this.getString("TestSuite.Header.TestErrorCount.txt"));
            w.println("\t\t" + tsr.getErrorCount());
            w.print(this.getString("TestSuite.Header.TestTimeoutCount.txt"));
            w.println("\t" + tsr.getTimeoutCount());
            w.println();
            w.print(this.getString("TestSuite.Table.TestName.txt"));
            w.print("\t");
            w.print(this.getString("TestSuite.Table.Passed.txt"));
            if (info.getShowTestTimesOnMainPage()) {
                w.print("\t");
                w.print(this.getString("TestSuite.Table.Time.txt"));
            }
            if (info.getShowTestRCsOnMainPage()) {
                w.print("\t");
                w.print(this.getString("TestSuite.Table.ReturnCode.txt"));
                w.print("\t");
                w.print(this.getString("TestSuite.Table.ExpectedRC.txt"));
            }
            if (info.getShowTestAssociatedFilesOnMainPage()) {
                w.print("\t");
                w.print(this.getString("TestSuite.Table.Files.txt"));
            }
            w.println();
            int count = tsr.getTestResultCount();
            for (int i = 0; i < count; ++i) {
                TestResult tr = tsr.getTestResult(i);
                String testName = tr.getName();
                int status = tr.getResult();
                boolean passed = status == 0;
                w.print(testName + "      ");
                String passStr = this.getString(passed ? "Yes.txt" : "No.txt");
                w.print(passStr + "      ");
                if (info.getShowTestTimesOnMainPage()) {
                    w.print(DProUtil.nanosToSeconds(tr.getTime()) + "      ");
                }
                if (info.getShowTestRCsOnMainPage()) {
                    w.print(tr.getRC() + "      ");
                    String temp = tr.getExpectedRCs();
                    if (temp == null) {
                        temp = "-";
                    }
                    w.print(temp + "      ");
                }
                if (info.getShowTestAssociatedFilesOnMainPage()) {
                    int fileCount = tr.getAssociatedFileCount();
                    for (int j = 0; j < fileCount; ++j) {
                        AssociatedFile assocFile = tr.getAssociatedFile(j);
                        w.println(assocFile.getName() + "      ");
                    }
                }
                w.println();
            }
            w.println();
            String dateString = new SimpleDateFormat().format(new Date());
            String temp = this.getString("TestSuite.GeneratedDate.fmt.txt");
            temp = MessageFormat.format(temp, dateString);
            w.println(temp);
        }
        finally {
            w.flush();
            w.close();
        }
        this.debugPrint("TestingTextReportMaker.createReport(): Exiting");
        ReportMakerResultsImpl res = new ReportMakerResultsImpl(reportDir, this.getReportType());
        res.setDescribedResultsID(results.getResultsID());
        return res;
    }

    @Override
    public String getReportType() {
        return "_text";
    }

    public String toString() {
        return "[TestingTextReportMaker: reportType=" + this.getReportType() + "]";
    }
}

