/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.reporting.testing;

import com.sas.dpro.common.DProUtil;
import com.sas.dpro.contract.parser.GetTimeSpanStringNodeHandler;
import com.sas.dpro.provider.ProviderFactory;
import com.sas.dpro.reporting.ReportMakerResults;
import com.sas.dpro.reporting.ReportMakerResultsImpl;
import com.sas.dpro.reporting.testing.AbstractTestingReportMaker;
import com.sas.dpro.results.CommandResults;
import com.sas.dpro.results.FormattedResults;
import com.sas.dpro.results.testing.AssociatedFile;
import com.sas.dpro.results.testing.TestResult;
import com.sas.dpro.results.testing.TestResultsReportInfo;
import com.sas.dpro.results.testing.TestSuiteResult;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestingHtmlReportMaker
extends AbstractTestingReportMaker {
    private static final String PASS_GIF = "passed.gif";
    private static final String FAIL_GIF = "failed.gif";
    private static final String ERROR_GIF = "error.gif";
    private static final String TIMEOUT_GIF = "timeout.gif";
    private static final String WARNING_GIF = "warning.gif";
    private static final String SUITERES_GIF = "suiteres.gif";
    private static final String TESTRES_GIF = "testres.gif";
    private static final String EMPTY_STR = "";

    private void addRow(PrintWriter w, String key, String value) {
        w.println("   <tr>");
        w.println("      <td class=\"left\" valign=\"top\">" + this.getString(key) + "</td>");
        w.println("      <td>" + value + "</td>");
        w.println("   </tr>");
    }

    private void addTestCountRow(PrintWriter w, String key, int count) {
        key = "TestSuite.Header.Test" + key + "Count.txt";
        this.addRow(w, key, Integer.toString(count));
    }

    private void addTestSuiteTableHeaderElement(PrintWriter w, String key) {
        w.println("      <th>" + this.getString("TestSuite.Table." + key + ".txt") + "</th>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyImageToDisk(String resource, File dest, ClassLoader cl) throws IOException {
        InputStream in = cl.getResourceAsStream(resource);
        this.debugPrint("... ... ... copyImageToDisk: in!=null ? " + (in != null));
        if (in == null) {
            String desc = this.getString("Error.LoadingImage.fmt.txt");
            desc = MessageFormat.format(desc, resource);
            throw new IOException(desc);
        }
        try (FileOutputStream imgOut = new FileOutputStream(dest);){
            int count = 0;
            byte[] buffer = new byte[2048];
            while ((count = in.read(buffer)) > -1) {
                imgOut.write(buffer, 0, count);
            }
        }
        finally {
            in.close();
        }
    }

    private void copyReportImagesToDisk(TestSuiteResult res, File reportDir) throws IOException {
        this.debugPrint("... copyReportImagesToDisk: Entering");
        this.debugPrint("... ... reportDir: " + reportDir.getAbsolutePath());
        ClassLoader cl = this.getClass().getClassLoader();
        String imgRoot = "com/sas/dpro/reporting/testing/images/";
        String img = imgRoot + "TestSuiteResults.gif";
        this.debugPrint("... ... Copying image: " + img);
        this.copyImageToDisk(img, new File(reportDir, TESTRES_GIF), cl);
        img = imgRoot + "TestResults.gif";
        this.debugPrint("... ... Copying image: " + img);
        this.copyImageToDisk(img, new File(reportDir, SUITERES_GIF), cl);
        int passCount = res.getPassCount();
        if (passCount > 0) {
            img = imgRoot + "TestPassed.gif";
            this.debugPrint("... ... Copying image: " + img);
            this.copyImageToDisk(img, new File(reportDir, PASS_GIF), cl);
        } else {
            this.debugPrint("... ... Skipping \"test passed\" image; no tests passed");
        }
        int failCount = res.getFailureCount();
        if (failCount > 0) {
            img = imgRoot + "TestFailed.gif";
            this.debugPrint("... ... Copying image: " + img);
            this.copyImageToDisk(img, new File(reportDir, FAIL_GIF), cl);
        } else {
            this.debugPrint("... ... Skipping \"test failed\" image; no tests failed");
        }
        int errorCount = res.getErrorCount();
        if (errorCount > 0) {
            img = imgRoot + "TestErrored.gif";
            this.debugPrint("... ... Copying image: " + img);
            this.copyImageToDisk(img, new File(reportDir, ERROR_GIF), cl);
        } else {
            this.debugPrint("... ... Skipping \"test error\" image; no tests errored");
        }
        int timeoutCount = res.getTimeoutCount();
        if (timeoutCount > 0) {
            img = imgRoot + "TestFailed.gif";
            this.debugPrint("... ... Copying image: " + img);
            this.copyImageToDisk(img, new File(reportDir, TIMEOUT_GIF), cl);
        } else {
            this.debugPrint("... ... Skipping \"test timed out\" image; no tests timed out");
        }
        int warningCount = res.getWarningCount();
        if (warningCount > 0) {
            img = imgRoot + "TestErrored.gif";
            this.debugPrint("... ... Copying image: " + img);
            this.copyImageToDisk(img, new File(reportDir, WARNING_GIF), cl);
        } else {
            this.debugPrint("... ... Skipping \"test warning\" image; no warnings occurred");
        }
        this.debugPrint("... copyReportImagesToDisk: Exiting");
    }

    private void copyTableSortingResources(File reportDir) throws IOException {
        this.debugPrint("... copyTableSortingResources: Entering");
        ClassLoader cl = this.getClass().getClassLoader();
        String imgRoot = "com/sas/dpro/reporting/testing/images/";
        String img = imgRoot + "arrowup.png";
        this.debugPrint("... ... Copying image: " + img);
        this.copyImageToDisk(img, new File(reportDir, "arrowup.png"), cl);
        img = imgRoot + "arrowdown.png";
        this.debugPrint("... ... Copying image: " + img);
        this.copyImageToDisk(img, new File(reportDir, "arrowdown.png"), cl);
        img = imgRoot + "arrownone.png";
        this.debugPrint("... ... Copying image: " + img);
        this.copyImageToDisk(img, new File(reportDir, "arrownone.png"), cl);
        String fileRoot = "com/sas/dpro/reporting/testing/";
        String res = fileRoot + "sorttable.js";
        this.debugPrint("... ... Copying resource: " + res);
        this.copyImageToDisk(res, new File(reportDir, "sorttable.js"), cl);
        this.debugPrint("... copyTableSortingResources: Exiting");
    }

    @Override
    public ReportMakerResults createReport(FormattedResults results, File reportDir, Charset cs) throws IOException {
        File[] contents;
        int i;
        this.debugPrint("TestingHTMLReportMaker.createReport(): Entering");
        this.debugPrint("... Original report encoding: " + (cs == null ? "null" : cs.displayName()));
        cs = this.ensureValidCharset(cs);
        this.debugPrint("... Report encoding: " + cs.displayName());
        this.debugPrint("... Creating metadata file");
        this.createReportMetadataFile(reportDir, results, cs);
        this.debugPrint("... Parsing TestSuiteResult from XML");
        Document doc = DProUtil.getDocumentFromResults(results);
        Element root = doc.getDocumentElement();
        TestSuiteResult tsr = new TestSuiteResult();
        tsr.read(doc, root);
        this.copyReportImagesToDisk(tsr, reportDir);
        this.copyTableSortingResources(reportDir);
        TestResultsReportInfo info = tsr.getReportInfo();
        if (info == null) {
            info = new TestResultsReportInfo();
        }
        this.debugPrint("... Creating main report file, index.html");
        File mainFile = new File(reportDir, "index.html");
        PrintWriter w = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(mainFile), cs)));
        w.println("<html>");
        String title = this.getString("TestSuiteResult.Title.txt");
        this.printReportHeader(w, cs, results, title);
        w.println("<body>");
        w.print("<h1><img src=\"");
        w.print(TESTRES_GIF);
        w.print("\">");
        w.println("&nbsp;" + title + "</h1>\n<hr>");
        w.println("<table>");
        this.addRow(w, "TestSuite.Header.TestSuite.txt", tsr.getName());
        String server = tsr.getProvider();
        if (server != null && ProviderFactory.isLocalProvider(server) && server.indexOf(58) > -1) {
            server = server.substring(0, server.indexOf(58));
        }
        this.addRow(w, "TestSuite.Header.Server.txt", server);
        if (info.getShowTestSuiteCommandOnMainPage()) {
            String command = this.getPrettyCommand(tsr.getCommand());
            this.addRow(w, "TestSuite.Header.Command.txt", command);
        }
        if (info.getShowTestSuiteDescriptionOnMainPage()) {
            this.addRow(w, "TestSuite.Header.Description.txt", tsr.getDescription());
        }
        if (info.getShowTestSuiteTimeOnMainPage()) {
            this.addRow(w, "TestSuite.Header.RunTime.txt", this.getRunTime(tsr));
        }
        this.addTestCountRow(w, "Run", tsr.getTestResultCount());
        this.addTestCountRow(w, "Pass", tsr.getPassCount());
        this.addTestCountRow(w, "Fail", tsr.getFailureCount());
        this.addTestCountRow(w, "Error", tsr.getErrorCount());
        this.addTestCountRow(w, "Timeout", tsr.getTimeoutCount());
        w.println("</table>\n<br>");
        w.println("<table class=\"sortable\" id=\"testResultTable\" border=\"0\">");
        w.println("   <tr>");
        if (info.getNumberTestsOnMainPage()) {
            w.println("      <th>&nbsp;&nbsp;&nbsp;</th>");
        }
        this.addTestSuiteTableHeaderElement(w, "TestName");
        if (info.getShowTestTimesOnMainPage()) {
            this.addTestSuiteTableHeaderElement(w, "Time");
        }
        if (info.getShowTestRCsOnMainPage()) {
            this.addTestSuiteTableHeaderElement(w, "ReturnCode");
            this.addTestSuiteTableHeaderElement(w, "ExpectedRC");
        }
        if (info.getShowTestCommandsOnMainPage()) {
            this.addTestSuiteTableHeaderElement(w, "Commands");
        }
        if (info.getShowTestDescriptionsOnMainPage()) {
            this.addTestSuiteTableHeaderElement(w, "Description");
        }
        if (info.getShowTestAssociatedFilesOnMainPage()) {
            this.addTestSuiteTableHeaderElement(w, "Files");
        }
        this.addTestSuiteTableHeaderElement(w, "Passed");
        w.println("   </tr>");
        int count = tsr.getTestResultCount();
        for (i = 0; i < count; ++i) {
            boolean passed;
            TestResult tr = tsr.getTestResult(i);
            int status = tr.getResult();
            String imageName = null;
            String rowClass = (i & 1) == 0 ? "even" : "odd";
            switch (status) {
                default: {
                    w.print("   <tr class=\"");
                    w.print(rowClass);
                    w.println("\">");
                    imageName = PASS_GIF;
                    break;
                }
                case 1: {
                    w.print("   <tr class=\"");
                    w.print(rowClass);
                    w.println("\">");
                    imageName = FAIL_GIF;
                    break;
                }
                case 2: {
                    w.print("   <tr class=\"");
                    w.print(rowClass);
                    w.println("\">");
                    imageName = ERROR_GIF;
                    break;
                }
                case 3: {
                    w.print("   <tr class=\"");
                    w.print(rowClass);
                    w.println("\">");
                    imageName = TIMEOUT_GIF;
                    break;
                }
                case 4: {
                    w.print("   <tr class=\"");
                    w.print(rowClass);
                    w.println("\">");
                    imageName = WARNING_GIF;
                }
            }
            String testName = tr.getName();
            boolean bl = passed = status == 0;
            if (info.getNumberTestsOnMainPage()) {
                w.print("      <td>");
                w.print(i + 1);
                w.print(".</td>\n");
            }
            if (info.getShowDetailedTestInfo() || !passed) {
                String descFileName = DProUtil.createSafeFileName(testName) + ".html";
                testName = "<a href=\"" + descFileName + "\">" + testName + "</a>";
                File descFile = new File(reportDir, descFileName);
                this.createTestDescriptionPage(tr, descFile, mainFile.getName(), reportDir, info, cs);
            }
            w.print("      <td>");
            w.print(testName);
            w.print("</td>\n");
            if (info.getShowTestTimesOnMainPage()) {
                long millis = tsr.getTime() / 1000000L;
                String runTime = GetTimeSpanStringNodeHandler.formatElapsedTime(millis);
                w.print("      <td>");
                w.print(runTime);
                w.print("</td>\n");
            }
            if (info.getShowTestRCsOnMainPage()) {
                w.print("      <td>");
                w.print(tr.getRC());
                w.print("</td>\n");
                String temp = tr.getExpectedRCs();
                if (temp == null) {
                    temp = this.getString("UnspecifiedExpectedRC.txt");
                }
                w.print("      <td>");
                w.print(temp);
                w.print("</td>\n");
            }
            if (info.getShowTestCommandsOnMainPage()) {
                w.print("      <td>");
                int cmdCount = tr.getCommandCount();
                if (cmdCount == 0) {
                    w.print("<em>" + this.getString("None.txt") + "</em>");
                } else if (cmdCount == 1) {
                    CommandResults cr = tr.getCommand(0);
                    w.print(cr.getCommand());
                } else {
                    w.print("<ol>");
                    for (int j = 0; j < cmdCount; ++j) {
                        CommandResults cr = tr.getCommand(j);
                        w.print("<li>");
                        w.print(cr.getCommand());
                    }
                    w.print("</ol>");
                }
                w.print("</td>\n");
            }
            if (info.getShowTestDescriptionsOnMainPage()) {
                w.print("      <td>" + tr.getDescription() + "</td>\n");
            }
            if (info.getShowTestAssociatedFilesOnMainPage()) {
                w.println("      <td>");
                w.println("         <ul>");
                int fileCount = tr.getAssociatedFileCount();
                for (int j = 0; j < fileCount; ++j) {
                    AssociatedFile assocFile = tr.getAssociatedFile(j);
                    this.printAssociatedFile(w, reportDir, assocFile);
                }
                w.println("         </ul>");
                w.println("      </td>");
            }
            w.print("      <td align=\"center\"><img class=\"resultImage\" src=\"");
            w.print(imageName);
            w.print("\"></img></td>\n");
            w.println("   </tr>");
        }
        w.println("</table>\n<p>");
        if (info.getShowTestSuiteAssociatedFilesOnMainPage()) {
            w.println("<b>" + this.getString("TestSuite.AssociatedFiles.txt") + "</b>");
            w.println("<ul>");
            count = 0;
            if (count == 0) {
                w.print("   <li><em>" + this.getString("None.txt") + "</em></li>\n");
            } else {
                for (i = 0; i < count; ++i) {
                    String fileName = null;
                    w.print("   <li><a href=\"");
                    w.print(fileName);
                    w.print(".html\">");
                    w.print(fileName);
                    w.print("</a>\n");
                    StringBuilder sb = new StringBuilder();
                    File outFile = new File(reportDir, fileName + ".html");
                    DProUtil.createHTMLPage(outFile, fileName, sb.toString(), mainFile.getName(), cs);
                }
            }
            w.println("</ul>");
            w.println("<p>\n");
        }
        if (info.getShowTestSuiteStdoutOnMainPage()) {
            w.println("<a href=\"stdout.html\">" + this.getString("TestSuite.ViewStdout.txt") + "</a><br>");
            File outFile = new File(reportDir, "stdout.html");
            DProUtil.createHTMLPage(outFile, "Stdout", tsr.getStdout(), mainFile.getName(), cs);
        }
        if (info.getShowTestSuiteStderrOnMainPage()) {
            w.println("<a href=\"stderr.html\">" + this.getString("TestSuite.ViewStderr.txt") + "</a><br>\n");
            File outFile = new File(reportDir, "stderr.html");
            DProUtil.createHTMLPage(outFile, "Stderr", tsr.getStderr(), mainFile.getName(), cs);
        }
        w.println("<br></p>");
        this.debugPrint("... Linking to output files on main page");
        File tempDir = new File(reportDir, "_results");
        this.debugPrint("... ... checking dir: " + tempDir.getAbsolutePath());
        if (tempDir.isDirectory() && (contents = tempDir.listFiles()) != null && contents.length > 0) {
            w.println("<a href=\"_results\">" + this.getString("TestSuite.ViewOutputFiles.txt") + "</a><br>\n");
        }
        w.println("<br></p>");
        String dateString = new SimpleDateFormat().format(new Date());
        String temp = this.getString("TestSuite.GeneratedDate.fmt.txt");
        temp = MessageFormat.format(temp, dateString);
        w.println("<em>" + temp + "</em>");
        w.println("</body>\n</html>");
        w.flush();
        w.close();
        this.debugPrint("TestingHTMLReportMaker.createReport(): Exiting");
        ReportMakerResultsImpl res = new ReportMakerResultsImpl(reportDir, this.getReportType());
        res.setDescribedResultsID(results.getResultsID());
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTestDescriptionPage(TestResult result, File outFile, String parentFileName, File reportDir, TestResultsReportInfo info, Charset cs) throws IOException {
        PrintWriter out = null;
        try {
            String testName = result.getName();
            out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), cs)));
            String temp = this.getString("TestResult.TestName.fmt.txt");
            temp = MessageFormat.format(temp, testName);
            out.println("<html>");
            out.println("<head>");
            out.println(DProUtil.getHTMLContentTypeMetaTag(cs));
            out.println("<!-- Note that JEditorPane does not support vertical-align -->");
            out.println("<style type=\"text/css\">");
            out.println("td.left {");
            out.println("  background-color: #CCCCFF;");
            out.println("  font-weight: bold;");
            out.println("  text-align: right;");
            out.println("  vertical-align: top;");
            out.println("  white-space: nowrap;");
            out.println("}");
            out.println("</style>");
            out.print("<title>");
            out.print(temp);
            out.println("</title>");
            out.println("<!-- Generated by Deployment Tester -->");
            out.println("</head>");
            out.println("<body>");
            out.print("<h2><img src=\"");
            out.print(TESTRES_GIF);
            out.print("\">");
            out.print("&nbsp;");
            out.print(temp);
            out.println("</h2>");
            out.println("<hr>");
            String extraTitle = null;
            String extra = null;
            out.println("<table>");
            this.addRow(out, "TestResult.Header.Name.txt", testName);
            if (info.getShowTestCommandsOnTestPages()) {
                StringBuilder cmd = new StringBuilder();
                int count = result.getCommandCount();
                switch (count) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        cmd.append(result.getCommand(0).getCommand());
                        break;
                    }
                    default: {
                        cmd.append("<ol>");
                        for (int i = 0; i < count; ++i) {
                            CommandResults cr = result.getCommand(i);
                            cmd.append("<li>").append(cr.getCommand()).append("</li>");
                        }
                        cmd.append("</ol>");
                    }
                }
                this.addRow(out, "TestResult.Header.Command.txt", cmd.toString());
            }
            StringBuilder res = new StringBuilder();
            int status = result.getResult();
            switch (status) {
                case 0: {
                    res.append(this.getString("TestResult.Result.Passed.txt"));
                    break;
                }
                case 1: {
                    res.append("<em>").append(this.getString("TestResult.Result.Failed.txt")).append("</em>");
                    extraTitle = this.getString("TestResult.NoFailureDesc.Title.txt");
                    extra = DProUtil.getHTMLSafeVersion(result.getResultDescription(), false);
                    if (!EMPTY_STR.equals(extra)) break;
                    extra = this.getString("TestResult.NoFailureDesc.txt");
                    extra = "<em>" + extra + "</em>";
                    break;
                }
                case 2: {
                    res.append("<em>").append(this.getString("TestResult.Result.Error.txt")).append("</em>");
                    extraTitle = this.getString("TestResult.NoErrorDesc.Title.txt");
                    extra = DProUtil.getHTMLSafeVersion(result.getResultDescription(), false);
                    if (!EMPTY_STR.equals(extra)) break;
                    extra = this.getString("TestResult.NoErrorDesc.txt");
                    extra = "<em>" + extra + "</em>";
                    break;
                }
                case 3: {
                    res.append("<em>").append(this.getString("TestResult.Result.TimeOut.txt")).append("</em>");
                    extraTitle = this.getString("TestResult.NoTimeoutDescription.Title.txt");
                    extra = DProUtil.getHTMLSafeVersion(result.getResultDescription(), false);
                    if (!EMPTY_STR.equals(extra)) break;
                    extra = this.getString("TestResult.NoTimeoutDescription.txt");
                    extra = "<em>" + extra + "</em>";
                    break;
                }
                case 4: {
                    res.append("<em>").append(this.getString("TestResult.Result.Warning.txt")).append("</em>");
                    extraTitle = this.getString("TestResult.NoWarningDescription.Title.txt");
                    extra = DProUtil.getHTMLSafeVersion(result.getResultDescription(), false);
                    if (!EMPTY_STR.equals(extra)) break;
                    extra = this.getString("TestResult.NoWarningDescription.txt");
                    extra = "<em>" + extra + "</em>";
                }
            }
            this.addRow(out, "TestResult.Header.Result.txt", res.toString());
            if (info.getShowTestDescriptionsOnTestPages()) {
                String desc = result.getDescription();
                if (desc == null) {
                    desc = EMPTY_STR;
                }
                this.addRow(out, "TestResult.Header.Description.txt", desc);
            }
            if (info.getShowTestTimesOnTestPages()) {
                long millis = result.getTime() / 1000000L;
                String runTime = GetTimeSpanStringNodeHandler.formatElapsedTime(millis);
                this.addRow(out, "TestResult.Header.Time.txt", runTime);
            }
            if (info.getShowTestRCsOnTestPages()) {
                this.addRow(out, "TestResult.Header.ReturnCode.txt", result.getRC());
                this.addRow(out, "TestResult.Header.ExpectedRC.txt", result.getExpectedRCs());
            }
            out.println("</table><br>");
            if (extra != null) {
                out.println("<hr>\n");
                out.print("<b>");
                out.print(extraTitle);
                out.println("</b>");
                out.print("<pre>");
                out.print(extra);
                out.println("</pre><br>");
            }
            if (info.getShowTestAssociatedFilesOnTestPages()) {
                int assocFileCount = result.getAssociatedFileCount();
                out.println("<hr>");
                out.print("<b>");
                out.print(this.getString("TestResult.Header.AssociatedFiles.txt"));
                out.println("</b>");
                out.println("<ul>");
                if (assocFileCount == 0) {
                    out.print("   <li><em>");
                    out.print(this.getString("None.txt"));
                    out.println("</em>");
                } else {
                    for (int i = 0; i < assocFileCount; ++i) {
                        AssociatedFile assocFile = result.getAssociatedFile(i);
                        this.printAssociatedFile(out, reportDir, assocFile);
                    }
                }
                out.println("</ul><br>");
            }
            out.println("<hr>");
            out.print("<a href=\"");
            out.print(parentFileName);
            out.print("\">");
            out.print(this.getString("BackToResults.txt"));
            out.println("</a>");
            out.println("</body>");
            out.println("</html>");
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getReportType() {
        return "_html";
    }

    private void printAssociatedFile(PrintWriter w, File reportDir, AssociatedFile file) {
        String outputDir = "_results/outputFiles";
        boolean inResults = file.isLocationRelativeToResultsOutput();
        if (file.getOnlyIfInResults()) {
            if (!inResults) {
                return;
            }
            File dir = new File(reportDir, outputDir);
            File test = new File(dir, file.getName());
            if (!test.isFile()) {
                return;
            }
        }
        w.print("          <li>");
        if (inResults) {
            String path = outputDir + "/" + file.getName();
            w.print("<a href='" + path + "'>");
            w.print(file.getName());
            w.print("</a>");
        } else {
            w.print(file.getName());
        }
        w.println("</li>");
    }

    private void printReportHeader(PrintWriter w, Charset cs, FormattedResults results, String title) {
        w.println("<head>");
        w.println(DProUtil.getHTMLContentTypeMetaTag(cs));
        w.println("<!-- Note that JEditorPane does not support vertical-align -->");
        w.println("<style type=\"text/css\">");
        w.println("td.left {");
        w.println("  background-color: #CCCCFF;");
        w.println("  font-weight: bold;");
        w.println("  text-align: right;");
        w.println("  vertical-align: top;");
        w.println("  white-space: nowrap;");
        w.println("}");
        w.println("th {");
        w.println("  background-color: #FFF0E6;");
        w.println("  font-weight: bold;");
        w.println("  text-align: left;");
        w.println("  text-decoration: none;");
        w.println("  white-space: nowrap;");
        w.println("}");
        w.println("tr.failure {");
        w.println("  background-color: #FFBBAA;");
        w.println("}");
        w.println("tr.error {");
        w.println("  background-color: #FFFFAA;");
        w.println("}");
        w.println("tr.timeout {");
        w.println("  background-color: #FFBBAA;");
        w.println("}");
        w.println("tr.even {");
        w.println("  background-color: #FFFFFF;");
        w.println("}");
        w.println("tr.odd {");
        w.println("\t  background-color: #EEEEEE;");
        w.println("}");
        w.println("a.sortheader {");
        w.println("  font-weight: bold;");
        w.println("  text-decoration: none;");
        w.println("}");
        w.println("</style>");
        w.println("<script language=\"javascript\" type=\"text/javascript\" src=\"sorttable.js\"></script>");
        w.println("<!-- Generated by Deployment Tester -->");
        w.println("<!-- Server:       " + ProviderFactory.getLocalProviderName() + "-->");
        w.println("<!-- DPRO version: " + DProUtil.getLocalDPROVersion() + " -->");
        w.println("<!-- Results file: " + results.getFile().getAbsolutePath() + "-->");
        w.println("<title>" + title + "</title>");
        w.println("</head>");
    }

    public String toString() {
        return "[TestingHtmlReportMaker: reportType=" + this.getReportType() + "]";
    }
}

