/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.reporting.testing;

import com.sas.dpro.common.DProEnvironment;
import com.sas.dpro.common.FileParserBase;
import com.sas.dpro.reporting.ReportMakerFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ReportMakerFileParser
extends FileParserBase {
    private File rmFile;
    private static final String CHARSET = "characterSet";
    private static final String REPORT_TYPE = "reportType";
    private static final String RESULTS_TYPE = "resultsType";
    private static final String ROOT_ELEMENT = "ReportMakers";
    private static final String SCRIPT_FILE = "scriptFile";
    private static final String GROOVY_RM = "GroovyScriptReportMaker";
    private static final String VAR_INSTALL_DIR = "${_installDir}";
    private static final String MSG = "com.sas.dpro.service.ServiceFileParser";
    private static final String PROPERTY_DEBUG = "com.sas.dpro.reporting.testing.ReportMakerFileParser.debug";

    private ReportMakerFileParser(File reportMakerFile) {
        this.rmFile = reportMakerFile;
    }

    private SAXBuilder createSAXBuilder() throws IOException {
        boolean validate = true;
        SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser", validate);
        if (validate) {
            builder.setFeature("http://apache.org/xml/features/validation/schema", true);
            builder.setEntityResolver((EntityResolver)new ReportMakerFileEntityResolver());
        }
        return builder;
    }

    private static ResourceBundle getBundle() {
        return ResourceBundle.getBundle(MSG);
    }

    @Override
    protected String getDebugHeader() {
        return "[ReportMakerFileParser]";
    }

    @Override
    protected String getDebugProperty() {
        return PROPERTY_DEBUG;
    }

    @Override
    protected File getXMLFile() {
        return this.rmFile;
    }

    public static void parse(String rmFile) throws IOException {
        File file = new File(rmFile);
        ReportMakerFileParser parser = new ReportMakerFileParser(file);
        parser.handleParse();
    }

    private void handleGroovyReportMakerNode(Element elem) throws IOException {
        String name = elem.getAttributeValue("name");
        if (!this.shouldLoad(elem, name = this.replaceVariables(name))) {
            return;
        }
        String scriptFile = null;
        String resultsType = null;
        String reportType = null;
        Element child2 = elem.getChild(SCRIPT_FILE);
        scriptFile = child2.getText();
        if (scriptFile == null || scriptFile.length() == 0 || scriptFile.startsWith("!unconfigured_") || scriptFile.startsWith("@unconfigured_")) {
            this.debugPrint("Skipping load of unconfigured report maker '" + name + "'");
            return;
        }
        scriptFile = ReportMakerFileParser.varSubstitute(scriptFile);
        scriptFile = this.replaceVariables(scriptFile);
        scriptFile = this.ensureAbsolute(scriptFile);
        String csName = child2.getAttributeValue(CHARSET);
        Charset cs = null;
        if (csName == null || "default".equals(csName)) {
            cs = Charset.defaultCharset();
        } else {
            try {
                cs = Charset.forName(csName);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
        }
        for (Element child2 : elem.getChildren()) {
            String nodeName2 = child2.getName();
            if (SCRIPT_FILE.equals(nodeName2)) continue;
            if (RESULTS_TYPE.equals(nodeName2)) {
                resultsType = this.replaceVariables(child2.getText());
                continue;
            }
            if (!REPORT_TYPE.equals(nodeName2)) continue;
            reportType = this.replaceVariables(child2.getText());
        }
        this.debugPrint("Mapping Report Maker '" + resultsType + "/" + reportType + "' to '" + scriptFile + "' (" + cs.displayName() + ")");
        ReportMakerFactory.getInstance().addGroovyBasedReportMaker(resultsType, reportType, new File(scriptFile), cs);
    }

    private void handleParse() throws IOException {
        SAXBuilder builder = this.createSAXBuilder();
        Document doc = null;
        try {
            doc = builder.build(this.rmFile);
        }
        catch (JDOMException je) {
            je.printStackTrace();
            throw new IOException(je.getMessage());
        }
        Element root = doc.getRootElement();
        if (!ROOT_ELEMENT.equals(root.getName())) {
            String desc = ReportMakerFileParser.getBundle().getString("Error.UnknownElement.fmt.txt");
            desc = MessageFormat.format(desc, root.getName());
            throw new IOException(desc);
        }
        String version = root.getAttributeValue("version");
        if (version == null || !"1.0".equals(version)) {
            String desc = ReportMakerFileParser.getBundle().getString("Error.UnsupportedVersion.fmt.txt");
            desc = MessageFormat.format(desc, version);
            throw new IOException(desc);
        }
        for (Element child : root.getChildren()) {
            String nodeName = child.getName();
            if ("loadPropertiesFile".equals(nodeName)) {
                this.handlePropertiesFileNode(child);
                continue;
            }
            if (GROOVY_RM.equals(nodeName)) {
                this.handleGroovyReportMakerNode(child);
                continue;
            }
            String desc = ReportMakerFileParser.getBundle().getString("Error.UnknownElement.fmt.txt");
            desc = MessageFormat.format(desc, nodeName);
            throw new IOException(desc);
        }
    }

    private static final String varSubstitute(String text) {
        int i = 0;
        while ((i = text.indexOf(VAR_INSTALL_DIR)) > -1) {
            text = text.substring(0, i) + DProEnvironment.getInstallDirectory() + File.separator + text.substring(i + VAR_INSTALL_DIR.length());
            i += DProEnvironment.getInstallDirectory().length();
        }
        return text;
    }

    private static final class ReportMakerFileEntityResolver
    implements EntityResolver {
        private static final String SCHEMA_NAME_1_6 = "com/sas/schema/report-makers-1.6.xsd";
        private static final String SYSTEM_ID_1_6 = "http://www.sas.com/xml/schema/dpro/report-makers-1.6.xsd";

        private ReportMakerFileEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            InputSource retval = null;
            if (SYSTEM_ID_1_6.equals(systemId)) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                InputStream stream = cl.getResourceAsStream(SCHEMA_NAME_1_6);
                retval = new InputSource(stream);
            }
            return retval;
        }
    }
}

