/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.reporting.testing;

import com.sas.dpro.contract.parser.GetTimeSpanStringNodeHandler;
import com.sas.dpro.reporting.AbstractReportMaker;
import com.sas.dpro.results.testing.TestSuiteResult;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

abstract class AbstractTestingReportMaker
extends AbstractReportMaker {
    private static final String MSG = "com.sas.dpro.reporting.testing.AbstractTestingReportMaker";
    private static final ResourceBundle msg = ResourceBundle.getBundle("com.sas.dpro.reporting.testing.AbstractTestingReportMaker");

    AbstractTestingReportMaker() {
    }

    protected String getPrettyCommand(String command) {
        return command != null ? command : msg.getString("NotAvailable.txt");
    }

    protected String getRunTime(TestSuiteResult tsr) {
        String runTime = msg.getString("Unknown.txt");
        if (tsr.getTime() != -1L) {
            long millis = tsr.getTime() / 1000000L;
            millis = Math.max(1000L, millis);
            runTime = GetTimeSpanStringNodeHandler.formatElapsedTime(millis);
        } else if (tsr.getStartTime() > -1L && tsr.getEndTime() > -1L) {
            long millis = tsr.getEndTime() - tsr.getStartTime();
            millis = Math.max(1000L, millis);
            runTime = GetTimeSpanStringNodeHandler.formatElapsedTime(millis);
        }
        return runTime;
    }

    protected String getString(String key) {
        String value = null;
        try {
            value = msg.getString(key);
        }
        catch (MissingResourceException mre) {
            value = "!" + key + "!";
        }
        return value;
    }
}

