/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.provider;

import com.sas.dpro.common.HostInfo;
import com.sas.dpro.contract.ContractInfo;
import com.sas.dpro.provider.Provider;
import com.sas.dpro.provider.ProviderFactory;
import com.sas.dpro.provider.ProviderInfo;
import com.sas.dpro.service.ServiceInfo;
import java.io.Serializable;

class ProviderInfoImpl
implements ProviderInfo,
Serializable {
    private String providerName;
    private HostInfo hostInfo;
    private int port;
    private boolean available;
    private ContractInfo[] storedContractInfos;
    private ServiceInfo[] serviceInfos;
    private String dproVersionString;
    private String buildVersionString;
    private long upTime;
    private static final String UNKNOWN = "Unknown";
    private static final int UNKNOWN_PORT = -1;
    private static final long UNKNOWN_UPTIME = -1L;
    private static final long serialVersionUID = 1L;

    public ProviderInfoImpl(String hostName, int port, boolean serviceInfos, boolean contractInfos) {
        this.setPort(-1);
        this.setUpTime(-1L);
        this.refreshImpl(ProviderFactory.createProviderName(hostName, port), serviceInfos, contractInfos);
    }

    public ProviderInfoImpl(String providerName, boolean serviceInfos, boolean contractInfos) {
        this.setPort(-1);
        this.refreshImpl(providerName, serviceInfos, contractInfos);
    }

    public int compareTo(Object obj) {
        int val = -1;
        if (obj instanceof ProviderInfo) {
            ProviderInfo info = (ProviderInfo)obj;
            val = this.providerName.compareTo(info.getProviderName());
        }
        return val;
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    @Override
    public HostInfo getHostInfo() {
        return this.hostInfo;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getProviderBuildVersion() {
        return this.buildVersionString;
    }

    @Override
    public String getProviderDPROVersion() {
        return this.dproVersionString;
    }

    @Override
    public String getProviderName() {
        return this.providerName;
    }

    @Override
    public ServiceInfo[] getServiceInfos() {
        return this.serviceInfos;
    }

    @Override
    public ContractInfo[] getStoredContractInfos() {
        int count = this.storedContractInfos == null ? 0 : this.storedContractInfos.length;
        ContractInfo[] infos = new ContractInfo[count];
        for (int i = 0; i < count; ++i) {
            infos[i] = this.storedContractInfos[i];
        }
        return infos;
    }

    @Override
    public long getUpTime() {
        return this.upTime;
    }

    public int hashCode() {
        int code = this.providerName == null ? 0 : this.providerName.hashCode();
        return code;
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public boolean refresh(boolean serviceInfos, boolean contractInfos) {
        return this.refreshImpl(this.getProviderName(), serviceInfos, contractInfos);
    }

    protected boolean refreshImpl(String providerName, boolean serviceInfos, boolean contractInfos) {
        this.providerName = providerName;
        this.setProviderBuildVersion(UNKNOWN);
        this.setUpTime(-1L);
        this.setServiceInfos(null);
        this.setStoredContractInfos(null);
        try {
            Provider p = ProviderFactory.getProvider(providerName);
            if (this.hostInfo == null) {
                this.setHostInfo(p.createHostInfo());
            }
            if (this.port == -1) {
                this.setPort(p.getPort());
            }
            this.setProviderDPROVersionString(p.getProviderDPROVersion());
            if (serviceInfos) {
                this.setServiceInfos(p.getServiceInfosMatchingKeywords(null));
            }
            if (contractInfos) {
                this.setStoredContractInfos(p.getStoredContractInfosMatchingKeywords(null));
            }
            this.setAvailable(true);
            this.setProviderBuildVersion(p.getProviderBuildVersion());
            this.setUpTime(p.getUpTime());
        }
        catch (Exception e) {
            int colon;
            if (this.port == -1 && (colon = providerName.indexOf(58)) > -1) {
                try {
                    int port = Integer.parseInt(providerName.substring(colon + 1));
                    this.setPort(port);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.setProviderDPROVersionString(UNKNOWN);
            this.setAvailable(false);
        }
        return this.isAvailable();
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public void setHostInfo(HostInfo info) {
        this.hostInfo = info;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setProviderBuildVersion(String version) {
        this.buildVersionString = version;
    }

    public void setProviderDPROVersionString(String dproVersionString) {
        this.dproVersionString = dproVersionString;
    }

    public void setServiceInfos(ServiceInfo[] infos) {
        this.serviceInfos = infos;
    }

    public void setStoredContractInfos(ContractInfo[] infos) {
        this.storedContractInfos = infos;
    }

    public void setUpTime(long upTime) {
        this.upTime = upTime;
    }

    public String toString() {
        return "[ProviderInfoImpl: available=" + this.isAvailable() + "; providerName=" + this.getProviderName() + "; providerDPROVersion=" + this.getProviderDPROVersion() + "; providerBuildVersion=" + this.getProviderBuildVersion() + "; hostName=" + this.getHostInfo().getHostIPAddress() + "; hostIP=" + this.getHostInfo().getHostIPAddress() + "; hostOSName=" + this.getHostInfo().getOSName() + "; hostOSVersion=" + this.getHostInfo().getOSVersion() + "; hostOSArchitecture=" + this.getHostInfo().getOSArchitecture() + "; upTime=" + this.getUpTime() + "]";
    }
}

