/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.provider;

import com.sas.dpro.client.AbstractClient;
import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.ContainerContextImpl;
import com.sas.dpro.common.DProEnvironment;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.DirList;
import com.sas.dpro.common.DirSet;
import com.sas.dpro.common.ErrorInfo;
import com.sas.dpro.common.ExternalProcessUtil;
import com.sas.dpro.common.FileContents;
import com.sas.dpro.common.FileContentsFactory;
import com.sas.dpro.common.FileList;
import com.sas.dpro.common.FileSet;
import com.sas.dpro.common.HostInfo;
import com.sas.dpro.common.InputPromptInfo;
import com.sas.dpro.common.InvalidProviderNameException;
import com.sas.dpro.common.SerializableHashMap;
import com.sas.dpro.common.SerializableMap;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.common.ServiceTimedOutException;
import com.sas.dpro.contract.ContractInfo;
import com.sas.dpro.contract.ContractInfoImpl;
import com.sas.dpro.contract.StoredContractLoader;
import com.sas.dpro.contract.messages.ContractCompletedMessage;
import com.sas.dpro.contract.messages.Message;
import com.sas.dpro.contract.messages.ShowReportMessage;
import com.sas.dpro.controller.HonorContractContext;
import com.sas.dpro.controller.HonorContractParms;
import com.sas.dpro.formatter.ResultsFormatterFactory;
import com.sas.dpro.provider.CreateContainerContextParms;
import com.sas.dpro.provider.Provider;
import com.sas.dpro.provider.ProviderFactory;
import com.sas.dpro.provider.ServiceInfosMatchingKeywordsParms;
import com.sas.dpro.provider.ServiceRequestParms;
import com.sas.dpro.provider.ServiceRequestParmsImpl;
import com.sas.dpro.provider.StoredContractInfosMatchingKeywordsParms;
import com.sas.dpro.provider.UpdatesRequestError;
import com.sas.dpro.provider.UpdatesRequestErrorImpl;
import com.sas.dpro.provider.UpdatesRequestParms;
import com.sas.dpro.reporting.ReportInfo;
import com.sas.dpro.service.DProService;
import com.sas.dpro.service.Service;
import com.sas.dpro.service.ServiceFactory;
import com.sas.dpro.service.ServiceInfo;
import com.sas.dpro.service.ServiceParmsImpl;
import com.sas.dpro.service.ServiceResults;
import com.sas.dpro.service.ServiceResultsImpl;
import com.sas.dpro.service.ServiceResultsLoggerFactory;
import com.sas.dpro.service.standard.Checksum;
import com.sas.dpro.service.standard.Delete;
import com.sas.dpro.service.standard.Unzip;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UnicastRemoteObject;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import org.tanukisoftware.wrapper.WrapperManager;

public class ProviderImpl
extends AbstractClient
implements Provider {
    public static final int ERROR_COMMAND_LINE = 1;
    static final int LOCAL_PROVIDER_DUMMY_PORT = -99999;
    public static final String PROPERTY_DEBUG_MANAGING_CONTAINERS = "com.sas.dpro.provider.ProviderImpl.debugManagingContainers";
    public static final String PROPERTY_DEBUG_SERVICE_TIMEOUT = "com.sas.dpro.provider.ProviderImpl.debugServiceTimeout";
    public static final String PROP_SMTP_SERVER = "mail.smtp.host";
    private static final String LOG_FILE_NAME = "Provider.log";
    private int port;
    private Vector storedContractList;
    private boolean remoteShutdownEnabled;
    private String productName;
    private Map props;
    private boolean getFileInfoMethodsEnabled;
    private boolean allowRemoteServiceRequests;
    private boolean putFileEnabled;
    private boolean runAnyContract;
    private boolean restrictContainerLocations;
    private String buildVersion;
    private Vector containerContexts;
    private Map containerToClientIP;
    private static final Object CC_LOCK = new Object();
    private int contextCount;
    private List shutdownDeleteList;
    private final DateFormat format = new SimpleDateFormat("yyyyMMdd_HHmmss");
    private boolean initialized;
    private long serverStartMillis;
    private int shutdownStatus;
    private File updaterTempDir;
    private int updaterRestartSleepSeconds;
    private static final String BUNDLE = "com.sas.dpro.provider.ProviderImpl";
    private static final ResourceBundle msg = ResourceBundle.getBundle("com.sas.dpro.provider.ProviderImpl");
    private static final String CONFIG_FILE = "provider.config";
    private static final String CONFIG_PARAM_ALLOW_REMOTE_SERVICE_REQUESTS = "AllowRemoteServiceRequests";
    private static final String CONFIG_PARAM_GET_FILE_ENABLED = "GetFileEnabled";
    private static final String CONFIG_PARAM_GROOVY_ENABLED = "GroovyEnabled";
    private static final String CONFIG_PARAM_LOGGING_LEVEL = "LoggingLevel";
    private static final String CONFIG_PARAM_MAIL_SMTP_SERVER = "SMTPServer";
    private static final String CONFIG_PARAM_PARALLEL_COUNT = "MaxRunningParallelContracts";
    private static final String CONFIG_PARAM_PRODUCT_NAME = "ProductName";
    private static final String CONFIG_PARAM_PUT_FILE_ENABLED = "PutFileEnabled";
    private static final String CONFIG_PARAM_REMOTE_SHUTDOWN_ENABLED = "RemoteShutdownEnabled";
    private static final String CONFIG_PARAM_RESTRICT_CONTAINER_LOCS = "RestrictContainers";
    private static final String CONFIG_PARAM_RUN_ANY_CONTRACT = "RunAnyContract";
    private static final String CONFIG_PARAM_SHUTDOWN_CONTRACT_WAIT = "ShutdownContractWaitTimeMillis";
    private static final String CONFIG_PARAM_UPDATER_RESTART_SLEEP = "UpdaterRestartSleepTimeSeconds";
    private static final String CONFIG_PARAM_UPDATER_TEMP_DIR = "UpdaterTempDir";
    private static final boolean DEFAULT_REMOTE_SHUTDOWN_ENABLED = false;
    private static final String DEFAULT_PRODUCT_NAME = "Distributed Process Flow Server";
    private static final String PARAM_FORMATTERS_FILE = "-formatters";
    private static final String PARAM_PORT = "-p";
    private static final String PARAM_REMOTE_SHUTDOWN_ENABLED = "-remoteShutdownEnabled";
    private static final String PARAM_SERVICES_FILE = "-services";
    private static final String PARAM_UPDATER_TEMP_DIR = "-updaterTempDir";
    private static final String CLIENT_TYPE_STRING = "provider";
    private static final String SERVICE_PARAM_RESULTS_ID = "resultsID";
    private static final String SERVICE_PARAM_SERVICE_LOG = "serviceLog";
    private static final String CLASS_NAME = "com.sas.dpro.provider.ProviderImpl";
    private static final String LOGGER_NAME = "com.sas.dpro.provider.ProviderImpl";
    private static final String CONTRACT_COPY_INSTALL = "Contract/updater/CopyDPROInstall_contract.xml";
    private static final int SHUTDOWN_STATUS_ACTIVE = 0;
    private static final int SHUTDOWN_STATUS_PENDING = 1;
    private static final int SHUTDOWN_STATUS_IN_PROGRESS = 2;
    private static final int SHUTDOWN_STATUS_COMPLETED = 3;
    private static final String APP_DATA_SUBDIR = null;

    ProviderImpl() {
        this(-99999);
    }

    ProviderImpl(int port) {
        this(port, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ProviderImpl(int port, String servicesFile, String formattersFile) {
        super(Logger.getLogger("com.sas.dpro.provider.ProviderImpl"), APP_DATA_SUBDIR, port != -99999);
        this.configureLogger();
        this.initialize();
        if (port != -99999) {
            ProviderFactory.setLocalProvider(this);
        }
        this.storedContractList = new Vector();
        this.setRemoteShutdownEnabled(false);
        this.configureProps();
        this.restrictContainerLocations = true;
        this.getFileInfoMethodsEnabled = false;
        try {
            this.loadConfigFile();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.port = port;
        Object ioe = CC_LOCK;
        synchronized (ioe) {
            this.containerContexts = new Vector();
            this.containerToClientIP = Collections.synchronizedMap(new HashMap());
            this.contextCount = 0;
        }
        this.shutdownDeleteList = new ArrayList();
        this.initialized = true;
        ioe = this;
        synchronized (ioe) {
            this.shutdownStatus = 0;
        }
        String[] servicesFiles = DProEnvironment.getServicesFiles();
        for (int i = 0; i < servicesFiles.length; ++i) {
            this.addServiceMaps(servicesFiles[i]);
        }
        String[] formattersFiles = DProEnvironment.getFormattersFiles();
        for (int i = 0; i < formattersFiles.length; ++i) {
            this.addServiceToFormatterMaps(formattersFiles[i]);
        }
        String[] contractFiles = DProEnvironment.getStoredContractDefinitionFiles();
        for (int i = 0; i < contractFiles.length; ++i) {
            try {
                this.addStoredContractDefinitions(contractFiles[i]);
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (servicesFile != null) {
            this.addServiceMaps(servicesFile);
        }
        if (formattersFile != null) {
            this.addServiceToFormatterMaps(formattersFile);
        }
        this.serverStartMillis = System.currentTimeMillis();
    }

    public void addServiceMaps(String servicesFile) {
        try {
            ServiceFactory.getInstance().addServiceMappings(servicesFile);
        }
        catch (IOException ioe) {
            String message = msg.getString("Logger.Error.LoadingServices.fmt.txt");
            message = MessageFormat.format(message, servicesFile, ioe.getMessage());
            this.logger.severe(message);
            System.err.println(message);
            ioe.printStackTrace();
        }
    }

    public void addServiceToFormatterMaps(String formattersFile) {
        try {
            ResultsFormatterFactory.getInstance().addFormatTypeToFormatterMaps(formattersFile);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            String desc = msg.getString("Logger.Error.LoadingFormatters.fmt.txt");
            desc = MessageFormat.format(desc, formattersFile, ioe.getMessage());
            this.logger.severe(desc);
        }
    }

    public void addStoredContractDefinitions(String definitionFile) throws RemoteException {
        try {
            this.storedContractList.addAll(StoredContractLoader.parse(definitionFile));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            String desc = msg.getString("Logger.Error.LoadingStoredContracts.fmt.txt");
            desc = MessageFormat.format(desc, definitionFile, ioe.getMessage());
            this.logger.severe(desc);
        }
    }

    private ContractCompletedMessage cloneDPROInstall(String destDir) {
        String installDir = DProEnvironment.getInstallDirectory();
        File contractFile = new File(installDir, CONTRACT_COPY_INSTALL);
        String contract = contractFile.getAbsolutePath();
        String[] vars = new String[]{"destDir", destDir};
        HonorContractParms parms = this.createHonorContractParms(contract, vars);
        ContractCompletedMessage ccm = this._honorContractInternalBlocking(parms);
        return ccm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeContainer(ContainerContext container) throws RemoteException {
        this.debugContainerManagement("closeContainer: Closing: " + container);
        Object object = CC_LOCK;
        synchronized (object) {
            if (!this.containerContexts.remove(container)) {
                String desc = msg.getString("Error.InvalidContainer.fmt.txt");
                desc = MessageFormat.format(desc, container.getContractID());
                throw new RemoteException(desc);
            }
            this.containerToClientIP.remove(container);
        }
        int lifespan = container.getLifespan();
        if (lifespan == 1) {
            String dirName = container.getDirectory();
            File dir = new File(dirName);
            if (!dir.isDirectory()) {
                String desc = msg.getString("Error.ContainerDirNotFound.fmt.txt");
                desc = MessageFormat.format(desc, dirName);
                throw new RemoteException(desc);
            }
            Delete.deleteLocal(dir);
        } else if (lifespan == 2) {
            this.shutdownDeleteList.add(container);
        }
    }

    private void configureProps() {
        this.props = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainerContext createContainerContext(CreateContainerContextParms parms) throws RemoteException {
        this.debugContainerManagement("createContainerContext: creating: " + parms);
        String clientIP = this.getRemoteClientIP();
        this.debugContainerManagement("createContainerContext: client IP: " + clientIP);
        String clientVersion = parms.getClientDPROVersion();
        if (!this.isSupportedClient(clientVersion)) {
            String desc = msg.getString("Error.ClientNotSupported.fmt.txt");
            desc = MessageFormat.format(desc, parms.getContractID(), this.getProductName(), this.getProviderName(), clientVersion);
            throw new RemoteException(desc);
        }
        String contractID = parms.getContractID();
        long contractSessionID = parms.getContractSessionID();
        String dir = parms.getDirectory();
        int lifespan = parms.getLifespan();
        boolean isRootDir = parms.getIsRootDir();
        ContainerContextImpl container = new ContainerContextImpl(contractID, contractSessionID, this.getProviderName(), clientVersion);
        container.setProviderDPROVersion(this.getProviderDPROVersion());
        if (dir == null) {
            dir = this.createContainerDirName(contractID);
        } else {
            if (isRootDir) {
                if (!dir.endsWith("/") && !dir.endsWith("\\")) {
                    dir = dir + File.separatorChar;
                }
                dir = dir + this.createContainerDirName(contractID);
            }
            if (clientIP != null && !this.isAllowableContainerDir(dir)) {
                String desc = msg.getString("Error.ContainerLocNotAllowed.fmt.txt");
                desc = MessageFormat.format(desc, parms.getContractID(), this.getProviderName(), dir);
                throw new RemoteException(desc);
            }
        }
        try {
            container.setLifespan(lifespan);
        }
        catch (IllegalArgumentException iae) {
            String desc = msg.getString("Error.InvalidLifespan.fmt.txt");
            desc = MessageFormat.format(desc, parms.getContractID(), this.getProviderName(), Integer.toString(lifespan));
            throw new RemoteException(desc);
        }
        dir = this.getAbsoluteFilePath(dir);
        File directory = new File(dir);
        if (directory.isDirectory()) {
            container.setWasNewlyCreated(false);
        } else {
            if (directory.exists()) {
                String desc = msg.getString("Error.DirIsNotDir.fmt.txt");
                desc = MessageFormat.format(desc, parms.getContractID(), this.getProviderName(), dir);
                throw new RemoteException(desc);
            }
            if (!directory.mkdir()) {
                String desc = msg.getString("Error.CreatingDirectory.fmt.txt");
                desc = MessageFormat.format(desc, parms.getContractID(), this.getProviderName(), dir);
                throw new RemoteException(desc);
            }
        }
        container.setDirectory(dir);
        Object object = CC_LOCK;
        synchronized (object) {
            this.containerContexts.add(container);
            this.containerToClientIP.put(container, clientIP);
        }
        return container;
    }

    private synchronized String createContainerDirName(String id) {
        if (++this.contextCount < 0) {
            this.contextCount = 1;
        }
        return this.format.format(new Date()) + '_' + this.contextCount + '_' + new Random().nextInt(1000000) + '_' + id;
    }

    protected ServiceResultsImpl createFakeServiceResults(Service s, ContainerContext cc, int status) {
        ServiceInfo si = s.createServiceInfo();
        ServiceResultsImpl sr = new ServiceResultsImpl(si, cc);
        sr.setStatus(status);
        return sr;
    }

    @Override
    public HostInfo createHostInfo() throws RemoteException {
        return this.getHostInfo();
    }

    private void createServiceLog(String logName, ServiceResults results) throws ServiceFailedException {
        try {
            ServiceResultsLoggerFactory.getInstance().createServiceResultsLogger().write(logName, results);
        }
        catch (Exception e) {
            e.printStackTrace();
            String desc = msg.getString("Error.WritingServiceLog.fmt.txt");
            desc = MessageFormat.format(desc, logName, results.getServiceName(), e.getMessage());
            throw new ServiceFailedException(desc, e);
        }
    }

    private void debugContainerManagement(String text) {
        if (Boolean.getBoolean(PROPERTY_DEBUG_MANAGING_CONTAINERS)) {
            System.err.println("[Containers DEBUG]: " + text);
        }
    }

    private void debugTimeoutMessage(String msg) {
        boolean debugTimeout = Boolean.getBoolean(PROPERTY_DEBUG_SERVICE_TIMEOUT);
        if (debugTimeout) {
            msg = "[DEBUG TIMEOUT]: " + msg;
            System.err.println(msg);
            this.logger.info(msg);
        }
    }

    private void ensureFileIsAccessible(File file) throws RemoteException {
        if (!this.getFileInfoMethodsEnabled) {
            if (Boolean.getBoolean("debug.file.accessibility.check")) {
                String callerIP = this.getRemoteClientIP();
                System.out.println("[DEBUG]: File accessibility: IP " + callerIP + "'s request for file: " + file.getPath() + " is being denied; this method is disabled");
            }
            String msg = "This method has been disabled on {0}";
            String desc = MessageFormat.format(msg, this.getProviderName());
            throw new RemoteException(desc);
        }
    }

    private String fixSlashes(String path) {
        int count;
        if (path == null || path.length() == 0) {
            return path;
        }
        boolean windows = DProUtil.osIsWindows();
        StringBuilder sb = new StringBuilder();
        char[] ch = path.toCharArray();
        for (count = ch.length; count > 0 && (ch[count - 1] == '/' || ch[count - 1] == '\\'); --count) {
        }
        boolean lastWasSlash = false;
        for (int i = 0; i < count; ++i) {
            if (ch[i] != '\\' && ch[i] != '/') {
                sb.append(ch[i]);
                lastWasSlash = false;
                continue;
            }
            if (lastWasSlash) continue;
            sb.append(File.separatorChar);
            lastWasSlash = i > 0 || !windows;
        }
        return sb.toString();
    }

    private String getAbsoluteFilePath(String fileName) {
        fileName = this.fixSlashes(fileName);
        if (DProUtil.osIsWindows() && fileName.matches("\\w:")) {
            this.debugContainerManagement("Drive letter file path found: " + fileName);
            fileName = fileName + "\\";
        } else if (".".equals(fileName)) {
            return DProEnvironment.getWorkspaceDirectory();
        }
        File file = new File(fileName);
        if (file.isAbsolute()) {
            return fileName;
        }
        String workspace = DProEnvironment.getWorkspaceDirectory();
        return new File(workspace, fileName).getAbsolutePath();
    }

    @Override
    public String getAbsoluteFilePath(ContainerContext container, String fileName) throws RemoteException {
        File file;
        String path = null;
        path = fileName == null || fileName.length() == 0 || ".".equals(fileName) ? container.getDirectory() : ((file = new File(fileName)).isAbsolute() ? fileName : new File(container.getDirectory(), fileName).getAbsolutePath());
        return this.fixSlashes(path);
    }

    @Override
    public boolean getAreServicesAvailable(String[] serviceNames) throws RemoteException {
        boolean available = true;
        if (serviceNames != null) {
            ServiceFactory sf = ServiceFactory.getInstance();
            for (int i = 0; i < serviceNames.length; ++i) {
                if (sf.isServiceAvailable(serviceNames[i])) continue;
                available = false;
                break;
            }
        }
        return available;
    }

    @Override
    public String getDefaultReportType() {
        return "_text";
    }

    @Override
    public String getDPROClientTypeString() {
        return CLIENT_TYPE_STRING;
    }

    @Override
    public FileContents getFile(String fileName) throws RemoteException, IOException {
        return this.getFile(fileName, false, true);
    }

    @Override
    public FileContents getFile(String fileName, boolean delete, boolean failIfFileDoesntExist) throws RemoteException, IOException {
        FileContents fc = null;
        File f = new File(fileName);
        this.ensureFileIsAccessible(f);
        if (f.isFile()) {
            long length = f.length();
            boolean compress = DProUtil.getShouldCompressFileOnTransfer(fileName, length);
            fc = FileContentsFactory.createFileContents(f, compress);
            if (delete) {
                f.delete();
            }
        } else if (failIfFileDoesntExist) {
            String desc = msg.getString("Error.FileDoesNotExist.fmt.txt");
            desc = MessageFormat.format(desc, f.getAbsolutePath());
            throw new IOException(desc);
        }
        return fc;
    }

    @Override
    public boolean getFileExists(ContainerContext cont, String file) throws RemoteException {
        if (cont == null || file == null) {
            return false;
        }
        File f = new File(cont.getDirectory(), file);
        this.ensureFileIsAccessible(f);
        return f.exists();
    }

    @Override
    public String[] getFileInfo(ContainerContext cont, String file, String[] properties) throws IOException, RemoteException {
        if (properties == null) {
            return new String[0];
        }
        File f = new File(cont.getDirectory(), file);
        this.ensureFileIsAccessible(f);
        String[] info = new String[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            String prop = properties[i];
            String value = "UnknownProperty";
            if (prop == null) {
                value = "UnknownProperty";
            } else if ("ADLER-32".equals(prop)) {
                if (!f.exists()) {
                    value = "FileDoesNotExist";
                } else if (f.isDirectory()) {
                    value = "-1";
                } else {
                    Adler32 adler32 = new Adler32();
                    Checksum.computeChecksum(f, adler32);
                    value = Long.toString(adler32.getValue());
                }
            } else if ("canRead".equals(prop)) {
                value = f.exists() ? Boolean.toString(f.canRead()) : "FileDoesNotExist";
            } else if ("canWrite".equals(prop)) {
                value = f.exists() ? Boolean.toString(f.canWrite()) : "FileDoesNotExist";
            } else if ("childCount".equals(prop)) {
                String[] children;
                value = !f.exists() ? "FileDoesNotExist" : (f.isFile() ? "-1" : Integer.toString((children = f.list()) == null ? 0 : children.length));
            } else if ("CRC-32".equals(prop)) {
                if (!f.exists()) {
                    value = "FileDoesNotExist";
                } else if (f.isDirectory()) {
                    value = "-1";
                } else {
                    CRC32 crc32 = new CRC32();
                    Checksum.computeChecksum(f, crc32);
                    value = Long.toString(crc32.getValue());
                }
            } else if ("exists".equals(prop)) {
                value = Boolean.toString(this.getFileExists(cont, file));
            } else if ("fullPath".equals(prop)) {
                value = f.getAbsolutePath();
            } else if ("isDirectory".equals(prop)) {
                value = Boolean.toString(f.isDirectory());
            } else if ("isFile".equals(prop)) {
                value = Boolean.toString(f.isFile());
            } else if ("isHidden".equals(prop)) {
                value = f.exists() ? Boolean.toString(f.isHidden()) : "FileDoesNotExist";
            } else if ("lastModified".equals(prop)) {
                value = f.exists() ? Long.toString(f.lastModified()) : "FileDoesNotExist";
            } else if ("MD5".equals(prop)) {
                if (!f.exists()) {
                    value = "FileDoesNotExist";
                } else if (f.isDirectory()) {
                    value = "-1";
                } else {
                    MessageDigest md5 = null;
                    try {
                        md5 = MessageDigest.getInstance("MD5");
                        value = Checksum.computeChecksum(f, md5);
                    }
                    catch (NoSuchAlgorithmException nsae) {
                        value = "FileDoesNotExist";
                        nsae.printStackTrace();
                    }
                }
            } else if ("SHA-1".equals(prop)) {
                if (!f.exists()) {
                    value = "FileDoesNotExist";
                } else if (f.isDirectory()) {
                    value = "-1";
                } else {
                    MessageDigest sha1 = null;
                    try {
                        sha1 = MessageDigest.getInstance("SHA-1");
                        value = Checksum.computeChecksum(f, sha1);
                    }
                    catch (NoSuchAlgorithmException nsae) {
                        value = "FileDoesNotExist";
                        nsae.printStackTrace();
                    }
                }
            } else if ("size".equals(prop)) {
                value = Long.toString(this.getFileSize(cont, file));
            }
            info[i] = value;
        }
        return info;
    }

    @Override
    public boolean getFileListExists(FileList fileList) throws RemoteException {
        if (fileList == null) {
            return false;
        }
        boolean exists = true;
        int count = fileList.getSize();
        for (int i = 0; i < count; ++i) {
            File file = new File(fileList.getAbsolute(i));
            this.ensureFileIsAccessible(file);
            if (file.exists()) continue;
            exists = false;
            break;
        }
        return exists;
    }

    @Override
    public long getFileSize(ContainerContext cont, String file) throws RemoteException {
        if (cont == null || file == null) {
            return -1L;
        }
        File f = new File(cont.getDirectory(), file);
        this.ensureFileIsAccessible(f);
        return f.isFile() ? f.length() : -1L;
    }

    @Override
    public String getHostIPAddress() throws RemoteException {
        return this.hostIPAddress;
    }

    @Override
    public String getHostName() throws RemoteException {
        return this.hostName;
    }

    @Override
    protected String getLoggerFileName() {
        return LOG_FILE_NAME;
    }

    @Override
    public DirList getMatchingDirs(DirSet dirSet) throws RemoteException {
        if (!this.getFileInfoMethodsEnabled) {
            String msg = "This method has been disabled on {0}";
            String desc = MessageFormat.format(msg, this.getProviderName());
            throw new RemoteException(desc);
        }
        try {
            return dirSet.getMatchingDirs();
        }
        catch (Exception e) {
            throw new RemoteException(null, e);
        }
    }

    @Override
    public FileList getMatchingFiles(FileSet fileSet) throws RemoteException {
        return this.getMatchingFiles(fileSet, null);
    }

    @Override
    public FileList getMatchingFiles(FileSet fileSet, String id) throws RemoteException {
        if (!this.getFileInfoMethodsEnabled) {
            String msg = "This method has been disabled on {0}";
            String desc = MessageFormat.format(msg, this.getProviderName());
            throw new RemoteException(desc);
        }
        try {
            return fileSet.getMatchingFiles(id);
        }
        catch (Exception e) {
            throw new RemoteException(null, e);
        }
    }

    @Override
    public int getMaxParallelContractCount() throws RemoteException {
        return this.controller.getMaxParallelContractCount();
    }

    @Override
    public int getPort() throws RemoteException {
        return this.port;
    }

    public String getProductName() {
        return this.productName;
    }

    @Override
    public String getProperty(String name) throws RemoteException {
        if (name == null) {
            return null;
        }
        return (String)this.props.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String getProviderBuildVersion() throws RemoteException {
        block6: {
            if (this.buildVersion == null) {
                try {
                    URL codeBase = this.getClass().getProtectionDomain().getCodeSource().getLocation();
                    if (!codeBase.getPath().endsWith(".jar")) break block6;
                    try (JarInputStream jin = new JarInputStream(codeBase.openStream());){
                        Manifest mf = jin.getManifest();
                        Attributes attrs = mf.getMainAttributes();
                        this.buildVersion = attrs.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                    }
                }
                catch (IOException ioe) {
                    this.buildVersion = "Unknown";
                }
            }
        }
        return this.buildVersion;
    }

    @Override
    public String getProviderDPROVersion() throws RemoteException {
        return this.getClientDPROVersion();
    }

    @Override
    public String getProviderName() throws RemoteException {
        String host = this.getHostName();
        if (host == null) {
            host = this.getHostIPAddress();
        }
        return ProviderFactory.createProviderName(host, this.getPort());
    }

    private String getRemoteClientIP() {
        String callerIP = null;
        try {
            callerIP = UnicastRemoteObject.getClientHost();
        }
        catch (ServerNotActiveException e) {
            callerIP = null;
        }
        return callerIP;
    }

    @Override
    public ServiceInfo getServiceInfo(String service) throws RemoteException {
        ServiceInfo info = null;
        if (service != null) {
            ServiceFactory sf = ServiceFactory.getInstance();
            info = sf.getServiceInfo(service);
        }
        return info;
    }

    @Override
    public ServiceInfo[] getServiceInfosMatchingKeywords(ServiceInfosMatchingKeywordsParms parms) throws RemoteException {
        ServiceFactory sf = ServiceFactory.getInstance();
        List list = sf.getServiceInfosMatchingKeywords(parms == null ? null : parms.getKeywords());
        Collections.sort(list, new SameHostServiceInfoComparator(false));
        int count = list == null ? 0 : list.size();
        ServiceInfo[] infos = new ServiceInfo[count];
        infos = list.toArray(infos);
        return infos;
    }

    @Override
    public long getStartTime() throws RemoteException {
        return this.serverStartMillis;
    }

    @Override
    public ContractInfo[] getStoredContractInfosMatchingKeywords(StoredContractInfosMatchingKeywordsParms parms) throws RemoteException {
        ArrayList<ContractInfoImpl> list = new ArrayList<ContractInfoImpl>();
        String[] keywords = parms == null ? null : parms.getKeywords();
        for (ContractInfo info : this.storedContractList) {
            if (keywords != null && !info.matchesKeywords(keywords)) continue;
            ContractInfoImpl temp = new ContractInfoImpl(info.getDirectory(), info.getFileName());
            temp.setDisplayName(info.getDisplayName());
            temp.setDescription(info.getDescription());
            temp.setKeywords(info.getKeywords());
            temp.setProvider(this.getProviderName());
            list.add(temp);
        }
        int count = list.size();
        ContractInfo[] infos = new ContractInfo[count];
        infos = list.toArray(infos);
        return infos;
    }

    @Override
    public boolean getSupportsChecksumType(String type) throws RemoteException {
        return Checksum.isSupportedAlgorithm(type);
    }

    @Override
    public boolean getSupportsEncoding(String charset) throws RemoteException {
        boolean supported = false;
        if (charset != null) {
            try {
                supported = Charset.isSupported(charset);
            }
            catch (IllegalCharsetNameException icne) {
                supported = false;
            }
        }
        return supported;
    }

    public File getUpdaterTempDir() {
        return this.updaterTempDir;
    }

    @Override
    public long getUpTime() throws RemoteException {
        long ms = System.currentTimeMillis() - this.serverStartMillis;
        return ms / 1000L;
    }

    @Override
    protected void handleHandleMessageError(String desc, Exception e) {
        System.err.println(desc);
        e.printStackTrace();
        this.logger.severe(desc);
        this.logger.log(Level.SEVERE, desc, e);
    }

    private UpdatesRequestError handleInstallUpdates(UpdatesRequestParms urp) throws Exception {
        this.debugShutdownMessage("Entering ProviderImpl.handleInstallUpdates()");
        ContainerContext updateCC = urp.getUpdateContainerContext();
        if (updateCC == null) {
            String text = "INTERNAL ERROR: updateCC==null; no updates to install";
            this.debugShutdownMessage(text);
            UpdatesRequestErrorImpl urr = new UpdatesRequestErrorImpl(text);
            return urr;
        }
        File dproCloneDir = this.getUpdaterTempDir();
        if (dproCloneDir == null) {
            String text = "INTENRAL ERROR: null updatesTempDir";
            this.debugShutdownMessage(text);
            UpdatesRequestErrorImpl urr = new UpdatesRequestErrorImpl(text);
            return urr;
        }
        File updatesZipDir = new File(updateCC.getDirectory());
        File updatesZip = new File(updatesZipDir, "DPRO_Updates.zip");
        if (!updatesZip.isFile()) {
            String text = "ERROR: Update zip file " + updatesZip.getAbsolutePath() + " not found";
            this.debugShutdownMessage(text);
            UpdatesRequestErrorImpl urr = new UpdatesRequestErrorImpl(text);
            return urr;
        }
        File updatesDir = null;
        try {
            updatesDir = File.createTempFile("dpro_Updates_", ".tmp");
            if (!updatesDir.delete() || !updatesDir.mkdir()) {
                String text = "ERROR: Cannot create temporary directory: " + updatesDir.getAbsolutePath();
                this.debugShutdownMessage(text);
                UpdatesRequestErrorImpl urr = new UpdatesRequestErrorImpl(text);
                return urr;
            }
            Unzip.unzip(updatesZip, updatesDir, null, true);
        }
        catch (IOException ioe) {
            String text = "ERROR: Cannot unzip updates zip: " + ioe.toString();
            this.debugShutdownMessage(text);
            UpdatesRequestErrorImpl urr = new UpdatesRequestErrorImpl(text);
            return urr;
        }
        this.debugShutdownMessage("... Running contract to copy DPRO install");
        ContractCompletedMessage ccm = this.cloneDPROInstall(dproCloneDir.getAbsolutePath());
        if (ccm.isError() || ccm.isTimeout()) {
            this.debugShutdownMessage("... Error running DPRO install copy contract");
            ErrorInfo ei = ccm.getErrorInfo();
            this.debugShutdownMessage("... ... error message: " + ei == null ? "null" : ei.getErrorMessage());
            this.debugShutdownMessage("... ... error stack trace: " + ei == null ? "null" : ei.getErrorStackTrace());
            String text = "ERROR: Error or timeout running DPRO install copy contract: " + ei == null ? "null" : ei.getErrorMessage();
            UpdatesRequestErrorImpl urr = new UpdatesRequestErrorImpl(text);
            return urr;
        }
        String program = dproCloneDir.getAbsolutePath() + File.separatorChar + "Admin" + File.separatorChar + "bin" + File.separatorChar + "updater." + (DProUtil.osIsWindows() ? "bat" : "sh");
        ArrayList<String> command = new ArrayList<String>();
        command.add(program);
        command.add(dproCloneDir.getAbsolutePath());
        command.add("-port");
        command.add("" + this.port);
        if (urp.getRestartServer()) {
            command.add("-restart");
            if (this.updaterRestartSleepSeconds > 0) {
                command.add("-sleepBeforeRestart");
                command.add(Integer.toString(this.updaterRestartSleepSeconds));
            }
        }
        command.add("-pingAttempts");
        command.add(Integer.toString(urp.getMaxPingAttempts()));
        command.add("-installToUpdateDir");
        command.add(DProEnvironment.getInstallDirectory());
        command.add("-update");
        command.add("-updatesDir");
        command.add(updatesDir.getAbsolutePath());
        if (urp.getRemoveOldInstallWhenUpdating()) {
            command.add("-deleteOldInstall");
        }
        command.add("-loggingLevel");
        command.add("FINEST");
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.redirectErrorStream(true);
        builder.directory(dproCloneDir);
        this.debugShutdownMessage("... Updater client process will run in directory: " + builder.directory().getAbsolutePath());
        Process proc = null;
        String commandStr = ExternalProcessUtil.createCommandString(command);
        this.debugShutdownMessage("... Launching updater client command: " + commandStr);
        try {
            proc = builder.start();
            StringBuilder outputBuf = new StringBuilder();
            int rc = ExternalProcessUtil.waitFor(proc, null, null, outputBuf, null);
            String text = "ERROR: Updater client process ended, but parent still alive!  rc=" + rc;
            if (outputBuf.length() > 0) {
                text = text + "; output:\n" + outputBuf.toString();
            }
            this.debugShutdownMessage(text);
            UpdatesRequestErrorImpl urr = new UpdatesRequestErrorImpl(text);
            return urr;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (proc != null) {
                proc.destroy();
                proc = null;
            }
            throw e;
        }
    }

    private ContractCompletedMessage _honorContractInternalBlocking(HonorContractParms parms) {
        HonorContractContext hcc = this.controller.honorContract(parms, true);
        Message message = null;
        while (!((message = this.controller.getNextMessage(hcc)) instanceof ContractCompletedMessage)) {
        }
        ContractCompletedMessage ccm = (ContractCompletedMessage)message;
        return ccm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HonorContractContext honorContract(HonorContractParms parms) throws RemoteException {
        ProviderImpl providerImpl = this;
        synchronized (providerImpl) {
            if (this.shutdownStatus > 1) {
                String desc = msg.getString("Error.HonorContract.ShuttingDown.fmt.txt");
                desc = MessageFormat.format(desc, parms.getContract(), this.getProviderName());
                throw new RemoteException(desc);
            }
        }
        if (!this.runAnyContract) {
            boolean okToRun = false;
            String contract = parms.getContract();
            for (int i = 0; i < this.storedContractList.size(); ++i) {
                ContractInfo info = (ContractInfo)this.storedContractList.get(i);
                String stored = info.getFileFullPath();
                if (File.separatorChar == '/' && stored.equals(contract)) {
                    okToRun = true;
                    break;
                }
                if (File.separatorChar != '\\' || !stored.equalsIgnoreCase(contract)) continue;
                okToRun = true;
                break;
            }
            if (!okToRun) {
                String desc = "You are not allowed to run contract {0} on server {1}";
                desc = MessageFormat.format(desc, parms.getContract(), this.getProviderName());
                throw new RemoteException(desc);
            }
        }
        try {
            return this.controller.honorContract(parms, true);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdatesRequestError installUpdates(UpdatesRequestParms urp) throws RemoteException {
        this.debugShutdownMessage("Entering ProviderImpl.installUpdates()");
        if (!this.isRemoteShutdownEnabled()) {
            String desc = msg.getString("Error.CannotShutDownProvider.fmt.txt");
            desc = MessageFormat.format(desc, this.getProviderName());
            this.debugShutdownMessage(desc);
            this.debugShutdownMessage("Exiting ProviderImpl.installUpdates()");
            UpdatesRequestErrorImpl srr = new UpdatesRequestErrorImpl();
            srr.setUpdatesNotInstalledReason(1);
            return srr;
        }
        ProviderImpl desc = this;
        synchronized (desc) {
            if (this.shutdownStatus > 0) {
                this.debugShutdownMessage("... shutdown already in progress!");
                this.debugShutdownMessage("Exiting ProviderImpl.installUpdates()");
                UpdatesRequestErrorImpl srr = new UpdatesRequestErrorImpl();
                srr.setUpdatesNotInstalledReason(0);
                return srr;
            }
            this.shutdownStatus = 1;
        }
        this.debugShutdownMessage("... Update request accepted.  Update installation pending.");
        this.debugShutdownMessage("... Update parms: " + urp);
        boolean shutdownTried = false;
        UpdatesRequestError urr = null;
        if (urp != null && urp.getUpdateContainerContext() != null) {
            shutdownTried = true;
            this.debugShutdownMessage("... Calling handleInstallUpdates()");
            try {
                urr = this.handleInstallUpdates(urp);
            }
            catch (RemoteException re) {
                throw re;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RemoteException(e.getMessage(), e);
            }
        }
        if (!shutdownTried) {
            this.debugShutdownMessage("... No updates to install; just shutting down.");
            this.shutdownServer();
        } else {
            ProviderImpl providerImpl = this;
            synchronized (providerImpl) {
                this.shutdownStatus = 0;
            }
        }
        return urr;
    }

    protected boolean isAllowableContainerDir(String dir) {
        if (dir == null) {
            return false;
        }
        File testDir = new File(dir);
        if (!testDir.isAbsolute()) {
            return false;
        }
        if (this.restrictContainerLocations) {
            String[] scs = DProEnvironment.getStoredContractDefinitionFiles();
            int count = scs == null ? 0 : scs.length;
            for (int i = 0; i < count; ++i) {
                File scDir = new File(scs[i]).getParentFile().getAbsoluteFile();
                try {
                    if (!DProUtil.isParentDir(scDir, testDir)) continue;
                    return testDir.exists();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }
        return true;
    }

    public boolean isRemoteShutdownEnabled() {
        return this.remoteShutdownEnabled;
    }

    public boolean isSupportedClient(String clientVersion) {
        return true;
    }

    protected void loadConfigFile() throws IOException {
        File configFile = new File(DProEnvironment.getConfigDirectory(), CONFIG_FILE);
        try {
            this.logger.info(msg.getString("Logger.ParsingConfig.txt"));
            Properties props = new Properties();
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(configFile));
            props.load(in);
            in.close();
            String groovyEnabled = "false";
            for (String string : props.keySet()) {
                String temp;
                String desc;
                String value = props.getProperty(string);
                if (CONFIG_PARAM_PRODUCT_NAME.equals(string)) {
                    this.productName = value;
                    continue;
                }
                if (CONFIG_PARAM_GROOVY_ENABLED.equals(string)) {
                    if (value == null || "".equals(value)) continue;
                    groovyEnabled = "" + Boolean.parseBoolean(value);
                    continue;
                }
                if (CONFIG_PARAM_PUT_FILE_ENABLED.equals(string)) {
                    if (value == null || "".equals(value)) continue;
                    this.putFileEnabled = Boolean.parseBoolean(value);
                    continue;
                }
                if (CONFIG_PARAM_GET_FILE_ENABLED.equals(string)) {
                    if (value == null || "".equals(value)) continue;
                    this.getFileInfoMethodsEnabled = Boolean.parseBoolean(value);
                    continue;
                }
                if (CONFIG_PARAM_ALLOW_REMOTE_SERVICE_REQUESTS.equals(string)) {
                    if (value == null || "".equals(value)) continue;
                    this.allowRemoteServiceRequests = Boolean.parseBoolean(value);
                    continue;
                }
                if (CONFIG_PARAM_RUN_ANY_CONTRACT.equals(string)) {
                    if (value == null || "".equals(value)) continue;
                    this.runAnyContract = Boolean.parseBoolean(value);
                    continue;
                }
                if (CONFIG_PARAM_RESTRICT_CONTAINER_LOCS.equals(string)) {
                    if (value == null || "".equals(value)) continue;
                    this.restrictContainerLocations = Boolean.parseBoolean(value);
                    continue;
                }
                if (CONFIG_PARAM_LOGGING_LEVEL.equals(string)) {
                    String level = value;
                    if (level == null || "".equals(level)) continue;
                    try {
                        Level logLevel = Level.parse(level);
                        this.setLoggingLevel(logLevel);
                    }
                    catch (Exception e) {
                        desc = msg.getString("Logger.LoggingLevelError.fmt.txt");
                        desc = MessageFormat.format(desc, level);
                        this.logger.severe(desc);
                    }
                    continue;
                }
                if (CONFIG_PARAM_MAIL_SMTP_SERVER.equals(string)) {
                    String server = value;
                    if (server == null || "".equals(server = server.trim())) continue;
                    this.props.put(PROP_SMTP_SERVER, server);
                    continue;
                }
                if (CONFIG_PARAM_PARALLEL_COUNT.equals(string)) {
                    String parallelStr = value;
                    if (parallelStr == null || "".equals(parallelStr)) continue;
                    try {
                        int parallel = Integer.parseInt(parallelStr);
                        if (parallel < 0) {
                            throw new NumberFormatException();
                        }
                        this.setMaxParallelContractCount(parallel);
                    }
                    catch (NumberFormatException nfe) {
                        desc = msg.getString("Logger.ParallelCountError.fmt.txt");
                        desc = MessageFormat.format(desc, parallelStr);
                        this.logger.severe(desc);
                    }
                    continue;
                }
                if (CONFIG_PARAM_REMOTE_SHUTDOWN_ENABLED.equals(string)) {
                    String remoteShutdownStr = value;
                    if (remoteShutdownStr == null || "".equals(remoteShutdownStr)) continue;
                    boolean enabled = Boolean.parseBoolean(remoteShutdownStr);
                    this.setRemoteShutdownEnabled(enabled);
                    continue;
                }
                if (CONFIG_PARAM_SHUTDOWN_CONTRACT_WAIT.equals(string)) {
                    temp = value;
                    if (temp == null || "".equals(temp)) continue;
                    try {
                        int wait = Integer.parseInt(temp);
                        if (wait < 0) {
                            throw new NumberFormatException(CONFIG_PARAM_SHUTDOWN_CONTRACT_WAIT);
                        }
                        this.controller.setShutdownWaitTime(wait);
                    }
                    catch (NumberFormatException nfe) {
                        desc = msg.getString("Logger.ShutdownContractWaitError.fmt.txt");
                        desc = MessageFormat.format(desc, temp);
                        this.logger.severe(desc);
                    }
                    continue;
                }
                if (CONFIG_PARAM_UPDATER_RESTART_SLEEP.equals(string)) {
                    temp = value;
                    if (temp == null || "".equals(temp)) continue;
                    try {
                        int wait = Integer.parseInt(temp);
                        if (wait < 0) {
                            throw new NumberFormatException(CONFIG_PARAM_UPDATER_RESTART_SLEEP);
                        }
                        this.updaterRestartSleepSeconds = wait;
                    }
                    catch (NumberFormatException nfe) {
                        desc = "Invalid updater restart sleep time: {0}";
                        desc = MessageFormat.format(desc, temp);
                        this.logger.severe(desc);
                    }
                    continue;
                }
                if (CONFIG_PARAM_UPDATER_TEMP_DIR.equals(string)) {
                    String updaterTempDir = value;
                    if (updaterTempDir == null || "".equals(updaterTempDir)) continue;
                    this.setUpdaterTempDir(new File(updaterTempDir));
                    continue;
                }
                if (string.startsWith("ReadOnlyVar._")) {
                    if ("".equals(value)) continue;
                    String varName = string.substring(string.indexOf(95));
                    try {
                        this.controller.addGlobalVariable(varName, value, true);
                    }
                    catch (UnsupportedOperationException uoe) {
                        desc = DProUtil.formatString(msg, "Logger.ReadOnlyVarAlreadyHasValue.fmt.txt", varName);
                        this.logger.severe(desc);
                    }
                    continue;
                }
                String desc2 = msg.getString("Logger.UnknownProperty.fmt.txt");
                desc2 = MessageFormat.format(desc2, configFile.getAbsolutePath(), string, value);
                this.logger.severe(desc2);
            }
            if (this.productName == null || "".equals(this.productName)) {
                this.productName = DEFAULT_PRODUCT_NAME;
            }
            this.props.put("groovyEnabled", groovyEnabled);
            this.logger.info(msg.getString("Logger.DoneParsingConfig.txt"));
        }
        catch (IOException ioe) {
            String desc = msg.getString("Error.ConfigFile.fmt.txt");
            desc = MessageFormat.format(desc, configFile.getAbsolutePath(), ioe.getMessage());
            this.logger.severe(desc);
            throw ioe;
        }
    }

    @Override
    public Message poll(HonorContractContext context) throws RemoteException {
        return this.controller.getNextMessage(context);
    }

    private static void printErrorAndExit(String message, int rc) {
        if (message != null) {
            System.err.println(message);
        }
        System.exit(rc);
    }

    @Override
    public String promptForInput(InputPromptInfo info) throws IOException {
        String desc = msg.getString("Error.PromptForInputUnsupported.fmt.txt");
        throw new IOException(desc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String putFile(String path, boolean isDir, String oldFileName, FileContents contents) throws RemoteException, IOException {
        if (this.getPort() > 0 && !this.putFileEnabled) {
            String desc = "Copying files to Deployment Tester Server {0} is not allowed";
            desc = MessageFormat.format(desc, this.getProviderName());
            throw new IOException(desc);
        }
        String fileNameToReturn = null;
        File toFile = new File(path);
        if (!toFile.isAbsolute()) {
            String desc = msg.getString("Error.AbsolutePathRequired.txt");
            throw new RemoteException(desc);
        }
        if (isDir) {
            toFile = new File(toFile, oldFileName);
            fileNameToReturn = oldFileName;
        } else {
            fileNameToReturn = toFile.getName();
        }
        File parentDir = toFile.getParentFile();
        if (parentDir != null) {
            parentDir.mkdirs();
        }
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(toFile));){
            if (contents.isCompressed()) {
                CRC32 crc32 = new CRC32();
                FileContentsFactory.uncompressContents(contents.getContents(), out, crc32);
                if (crc32.getValue() != contents.getUncompressedCRC32()) {
                    String key = "Error.IncorrectCRC32.fmt.txt";
                    String desc = DProUtil.formatString(msg, key, new Object[]{toFile.getAbsolutePath(), "" + crc32.getValue(), "" + contents.getUncompressedCRC32()});
                    throw new IOException(desc);
                }
            } else {
                out.write(contents.getContents());
            }
        }
        return fileNameToReturn;
    }

    @Override
    public ServiceResults serviceRequest(ServiceRequestParms parms) throws RemoteException, ServiceFailedException {
        return this.serviceRequestImpl(parms, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceResults serviceRequestImpl(ServiceRequestParms parms, boolean internal) throws RemoteException, ServiceFailedException {
        if (!internal) {
            ProviderImpl providerImpl = this;
            synchronized (providerImpl) {
                if (this.shutdownStatus > 1) {
                    String desc = msg.getString("Error.Service.ShuttingDown.fmt.txt");
                    desc = MessageFormat.format(desc, parms.getServiceName(), this.getProviderName());
                    throw new ServiceFailedException(desc);
                }
            }
        }
        ContainerContext container = parms.getContainerContext();
        Object desc = CC_LOCK;
        synchronized (desc) {
            if (!this.containerContexts.contains(container) && !"_default".equals(container.getContractID())) {
                String desc2 = "{0}: There is no open container on {1} with ID {2}";
                desc2 = MessageFormat.format(desc2, parms.getServiceName(), this.getProviderName(), container.getContractID());
                throw new ServiceFailedException(desc2);
            }
            if (!internal && !this.allowRemoteServiceRequests) {
                String ip = (String)this.containerToClientIP.get(container);
                boolean fromRemoteClient = ip != null;
                if (fromRemoteClient |= this.getRemoteClientIP() != null) {
                    System.out.println("DEBUG: From remote client (" + ip + ", " + this.getRemoteClientIP() + ", " + this.getHostIPAddress() + ")");
                    String msg = "{0}: Deployment Tester Server {1} does not allow remote Service calls";
                    msg = MessageFormat.format(msg, parms.getServiceName(), this.getProviderName());
                    throw new ServiceFailedException(msg);
                }
            }
        }
        String serviceName = parms.getServiceName();
        long timeout = parms.getTimeout();
        boolean failIfFailure = parms.getFailIfFailure();
        boolean failIfTimeout = parms.getFailIfTimeout();
        SerializableMap serviceParams = parms.getServiceParameters().getParams();
        if (this.logger.isLoggable(Level.FINER)) {
            String desc3 = msg.getString("Logger.ServiceRequest.fmt.txt");
            desc3 = MessageFormat.format(desc3, serviceName, parms.getClientDPROVersion());
            this.logger.finer(desc3);
        }
        ServiceFactory serviceFactory = ServiceFactory.getInstance();
        DProService service = serviceFactory.createService(serviceName);
        String resultsID = null;
        FileSet outputFileSet = null;
        String serviceLog = null;
        if (serviceParams != null && !serviceParams.isEmpty()) {
            Object temp = serviceParams.get(SERVICE_PARAM_RESULTS_ID);
            if (temp instanceof String) {
                resultsID = (String)temp;
                serviceParams.remove(SERVICE_PARAM_RESULTS_ID);
            }
            if ((temp = serviceParams.get("_outputFileSet")) instanceof FileSet) {
                outputFileSet = (FileSet)temp;
                serviceParams.remove("_outputFileSet");
            }
            if ((temp = serviceParams.get(SERVICE_PARAM_SERVICE_LOG)) instanceof String) {
                serviceLog = (String)temp;
                serviceParams.remove(SERVICE_PARAM_SERVICE_LOG);
            }
            service.setParameters(parms.getServiceParameters());
        }
        if (timeout == -1L || timeout < 0L) {
            timeout = service.getDefaultTimeout();
        }
        this.debugTimeoutMessage("About to run service: " + serviceName);
        try {
            ServiceResultsImpl results = null;
            long start = System.nanoTime();
            if (timeout <= 0L) {
                this.debugTimeoutMessage("No timeout; running service in current thread");
                try {
                    results = (ServiceResultsImpl)service.runService(container, this.logger);
                }
                catch (ServiceFailedException sfe) {
                    if (failIfFailure) {
                        throw sfe;
                    }
                    results = this.createFakeServiceResults(service, container, 1);
                }
                catch (Exception e) {
                    ServiceFailedException sfe = ProviderImpl.wrapUnhandledServiceException(service, e);
                    throw sfe;
                }
            } else {
                this.debugTimeoutMessage("Timeout: " + timeout + " seconds; running service in separate thread");
                long millis = timeout * 1000L;
                TimedServiceThread t = new TimedServiceThread(service, container, this.logger);
                t.start();
                try {
                    t.join(millis);
                }
                catch (InterruptedException ie) {
                    t.interrupt();
                    String desc4 = msg.getString("JoinInterrupted.fmt.txt");
                    desc4 = MessageFormat.format(desc4, serviceName, "" + timeout);
                    this.debugTimeoutMessage(desc4);
                    throw new ServiceFailedException(desc4, ie);
                }
                if (t.isAlive()) {
                    t.interrupt();
                    if (failIfTimeout) {
                        String desc5 = msg.getString("Service.TimedOut.fmt.txt");
                        desc5 = MessageFormat.format(desc5, serviceName, "" + timeout);
                        this.debugTimeoutMessage(desc5);
                        throw new ServiceTimedOutException(desc5, timeout);
                    }
                    results = this.createFakeServiceResults(service, container, 2);
                } else {
                    Object resultObj = t.getResults();
                    if (resultObj instanceof ServiceFailedException) {
                        ServiceFailedException sfe = (ServiceFailedException)resultObj;
                        this.debugTimeoutMessage("Service-running thread completed; result: SFE");
                        if (failIfFailure) {
                            throw sfe;
                        }
                        results = this.createFakeServiceResults(service, container, 1);
                    } else {
                        results = (ServiceResultsImpl)resultObj;
                        this.debugTimeoutMessage("Service-running thread completed; result: ServiceResults");
                    }
                }
            }
            long time = System.nanoTime() - start;
            results.setTime(time);
            if (resultsID != null) {
                results.setResultsID(resultsID);
            }
            if (outputFileSet != null) {
                try {
                    FileList outputFiles = outputFileSet.getMatchingFiles();
                    results.setOutputFiles(outputFiles);
                }
                catch (InvalidProviderNameException invalidProviderNameException) {
                    // empty catch block
                }
            }
            if (serviceLog != null) {
                serviceLog = this.getAbsoluteFilePath(container, serviceLog);
                this.createServiceLog(serviceLog, results);
            }
            return parms.getReturnServiceResults() ? results : null;
        }
        catch (ServiceFailedException sfe) {
            ServiceResults sr;
            if (resultsID != null && (sr = sfe.getServiceResults()) != null && sr instanceof ServiceResultsImpl) {
                ((ServiceResultsImpl)sr).setResultsID(resultsID);
            }
            throw sfe;
        }
        catch (NoClassDefFoundError ncdfe) {
            String key = "Error.NoClassDefFoundError.fmt.txt";
            String desc6 = ncdfe.getMessage();
            if (desc6 == null) {
                desc6 = "";
            }
            desc6 = DProUtil.formatString(msg, key, serviceName, desc6);
            this.logger.severe(desc6);
            throw new ServiceFailedException(desc6, ncdfe);
        }
    }

    public void setMaxParallelContractCount(int parallel) {
        this.controller.setMaxParallelContractCount(parallel);
    }

    public void setRemoteShutdownEnabled(boolean enabled) {
        String desc = msg.getString("Logger.SettingRemoteShutdownEnabled.fmt.txt");
        desc = MessageFormat.format(desc, "" + enabled);
        this.logger.fine(desc);
        this.remoteShutdownEnabled = enabled;
    }

    public void setUpdaterTempDir(File updaterTempDir) {
        String desc = msg.getString("Logger.SettingUpdaterTempDir.fmt.txt");
        String dir = updaterTempDir != null ? updaterTempDir.getAbsolutePath() : null;
        desc = MessageFormat.format(desc, dir);
        this.logger.fine(desc);
        this.updaterTempDir = updaterTempDir;
    }

    @Override
    public void showReport(ShowReportMessage srm, ReportInfo ri) throws IOException, UnsupportedOperationException {
        String key = "Error.ShowingReportsUnsupported.fmt.txt";
        String desc = DProUtil.formatString(msg, key, this.hostName, ri.getReportID());
        throw new UnsupportedOperationException(desc);
    }

    @Override
    public synchronized void shutdown() {
        this.logger.entering("com.sas.dpro.provider.ProviderImpl", "shutdown");
        this.debugShutdownMessage("Entering ProviderImpl.shutdown()");
        if (!this.isRemoteShutdownEnabled() && !"dpro-shutdown-thread".equals(Thread.currentThread().getName())) {
            this.debugShutdownMessage("WARN: Attempt to call shutDown() not from DPRO shutdown thread!");
            return;
        }
        if (this.shutdownStatus > 1) {
            this.logger.exiting("com.sas.dpro.provider.ProviderImpl", "shutdown");
            this.debugShutdownMessage("Exiting (already shut down) ProviderImpl.shutdown()");
            return;
        }
        this.shutdownStatus = 2;
        if (this.initialized) {
            String desc = msg.getString("Logger.Shutdown.ClosingContainers.fmt.txt");
            desc = MessageFormat.format(desc, new Integer(this.shutdownDeleteList.size()));
            this.logger.info(desc);
            for (ContainerContext cc : this.shutdownDeleteList) {
                String dirName = cc.getDirectory();
                File dir = new File(dirName);
                if (!dir.isDirectory()) {
                    desc = msg.getString("Logger.Shutdown.Error.ContainerDirNotExist.fmt.txt");
                    desc = MessageFormat.format(desc, dir.getAbsolutePath());
                    this.logger.severe(desc);
                    continue;
                }
                try {
                    SerializableHashMap params = new SerializableHashMap();
                    params.put("dir", ".");
                    params.put("failOnError", "true");
                    ServiceRequestParmsImpl srp = new ServiceRequestParmsImpl();
                    srp.setClientDPROVersion(this.getProviderDPROVersion());
                    srp.setContainerContext(cc);
                    srp.setFailIfFailure(true);
                    srp.setFailIfTimeout(true);
                    srp.setReturnServiceResults(false);
                    srp.setServiceName("Delete");
                    ServiceParmsImpl sp = new ServiceParmsImpl();
                    sp.params = params;
                    srp.setServiceParameters(sp);
                    srp.setTimeout(0L);
                    this.serviceRequestImpl(srp, true);
                }
                catch (Exception e) {
                    desc = msg.getString("Logger.Shutdown.Error.DeletingDir.fmt.txt");
                    desc = MessageFormat.format(desc, dir.getAbsolutePath(), e.getMessage());
                    this.logger.severe(desc);
                }
            }
        }
        super.shutdown();
        this.shutdownStatus = 3;
        this.logger.exiting("com.sas.dpro.provider.ProviderImpl", "shutdown");
        this.debugShutdownMessage("Exiting ProviderImpl.shutdown()");
    }

    @Override
    public void shutdownServer() throws RemoteException {
        if (!this.isRemoteShutdownEnabled()) {
            String desc = msg.getString("Error.CannotShutDownProvider.fmt.txt");
            desc = MessageFormat.format(desc, this.getProviderName());
            throw new RemoteException(desc);
        }
        int rc = 0;
        this.debugShutdownMessage("ProviderImpl.shutdownServer: Exiting with rc=" + rc);
        if (DProUtil.osIsWindows() && WrapperManager.isControlledByNativeWrapper()) {
            String temp = "DEBUG: On Windows, and Tanuki wrapper running, so calling WrapperManager.stop() instead of System.exit()...";
            this.debugShutdownMessage(temp);
            WrapperManager.stop((int)rc);
        } else {
            System.exit(rc);
        }
    }

    @Override
    public void stopContract(HonorContractContext context) throws RemoteException {
        this.controller.stopContract(context);
    }

    private static ServiceFailedException wrapUnhandledServiceException(Service s, Exception e) {
        String temp = e.getMessage();
        if (temp == null) {
            temp = e.toString();
        }
        String desc = msg.getString("Error.UnhandledErrorInService.fmt.txt");
        desc = MessageFormat.format(desc, s.getName(), temp);
        return new ServiceFailedException(desc, e);
    }

    public static void main(String[] args) {
        try {
            int port = 1099;
            String servicesFile = null;
            String formattersFile = null;
            int parallel = -1;
            Level loggingLevel = null;
            int remoteShutdownEnabled = -1;
            File updatesTempDir = null;
            String groovyEnabled = null;
            int argCount = args.length;
            for (int i = 0; i < argCount; ++i) {
                String message;
                if (PARAM_SERVICES_FILE.equals(args[i])) {
                    if (i == argCount - 1) {
                        message = msg.getString("Error.CommandLine.ServicesFile.txt");
                        ProviderImpl.printErrorAndExit(message, 1);
                    }
                    servicesFile = args[++i];
                    continue;
                }
                if (PARAM_FORMATTERS_FILE.equals(args[i])) {
                    if (i == argCount - 1) {
                        message = msg.getString("Error.CommandLine.FormattersFile.txt");
                        ProviderImpl.printErrorAndExit(message, 1);
                    }
                    formattersFile = args[++i];
                    continue;
                }
                if (PARAM_REMOTE_SHUTDOWN_ENABLED.equals(args[i])) {
                    String temp;
                    if (i == argCount - 1) {
                        message = msg.getString("Error.CommandLine.RemoteShutdownEnabled.txt");
                        ProviderImpl.printErrorAndExit(message, 1);
                    }
                    if (!"true".equals(temp = args[++i]) && !"false".equals(temp)) {
                        String desc = msg.getString("Error.CommandLine.InvalidBoolean.fmt.txt");
                        desc = MessageFormat.format(desc, PARAM_REMOTE_SHUTDOWN_ENABLED, temp);
                        ProviderImpl.printErrorAndExit(desc, 1);
                    }
                    remoteShutdownEnabled = Boolean.parseBoolean(temp) ? 1 : 0;
                    continue;
                }
                if (PARAM_UPDATER_TEMP_DIR.equals(args[i])) {
                    if (i == argCount - 1) {
                        message = msg.getString("Error.CommandLine.UpdaterTempDir.txt");
                        ProviderImpl.printErrorAndExit(message, 1);
                    }
                    updatesTempDir = new File(args[++i]);
                    continue;
                }
                if ("-groovyEnabled".equals(args[i])) {
                    try {
                        groovyEnabled = AbstractClient.getCommandLineOptionGroovyEnabled(args, ++i);
                    }
                    catch (IllegalArgumentException iae) {
                        ProviderImpl.printErrorAndExit(iae.getMessage(), 1);
                    }
                    continue;
                }
                if ("-loggingLevel".equals(args[i])) {
                    try {
                        loggingLevel = AbstractClient.getCommandLineOptionLoggingLevel(args, ++i);
                    }
                    catch (IllegalArgumentException iae) {
                        ProviderImpl.printErrorAndExit(iae.getMessage(), 1);
                    }
                    continue;
                }
                if ("-parallel".equals(args[i])) {
                    try {
                        parallel = AbstractClient.getCommandLineOptionParallel(args, ++i);
                    }
                    catch (IllegalArgumentException iae) {
                        ProviderImpl.printErrorAndExit(iae.getMessage(), 1);
                    }
                    continue;
                }
                if (args[i].startsWith(PARAM_PORT)) {
                    port = Integer.parseInt(args[i].substring(2));
                    continue;
                }
                try {
                    AbstractClient.handleUnknownCommandLineOption(args[i]);
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    ProviderImpl.printErrorAndExit(iae.getMessage(), 1);
                }
            }
            ProviderImpl provider = new ProviderImpl(port, servicesFile, formattersFile);
            if (remoteShutdownEnabled > -1) {
                provider.setRemoteShutdownEnabled(remoteShutdownEnabled == 1);
            }
            if (parallel != -1) {
                provider.setMaxParallelContractCount(parallel);
            }
            if (loggingLevel != null) {
                provider.setLoggingLevel(loggingLevel);
            }
            if (updatesTempDir != null) {
                provider.setUpdaterTempDir(updatesTempDir);
            }
            if (groovyEnabled != null) {
                provider.props.put("groovyEnabled", groovyEnabled);
            }
            provider.logger.info(msg.getString("Logger.CreatingInternalReg.txt"));
            LocateRegistry.createRegistry(port);
            Provider stub = (Provider)UnicastRemoteObject.exportObject((Remote)provider, 0);
            provider.logger.info(msg.getString("Logger.LocateInternalReg.txt"));
            Registry registry = LocateRegistry.getRegistry(port);
            provider.logger.info(msg.getString("Logger.BindProviderStub.txt"));
            registry.bind("Provider", stub);
            String message = msg.getString("Misc.ProductVersion.fmt.txt");
            message = MessageFormat.format(message, provider.getProviderDPROVersion());
            System.out.println(message);
            provider.logger.info(message);
            message = msg.getString("Misc.BuildVersion.fmt.txt");
            message = MessageFormat.format(message, provider.getProviderBuildVersion());
            System.out.println(message);
            provider.logger.info(message);
            message = msg.getString("Misc.ProviderReady.fmt.txt");
            message = MessageFormat.format(message, provider.getProductName(), new Integer(port));
            System.out.println(message);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class TimedServiceThread
    extends Thread {
        private DProService service;
        private ContainerContext cc;
        private Logger logger;
        private Object resultObj;

        public TimedServiceThread(DProService service, ContainerContext cc, Logger logger) {
            this.service = service;
            this.cc = cc;
            this.logger = logger;
        }

        public Object getResults() {
            return this.resultObj;
        }

        @Override
        public void run() {
            try {
                this.resultObj = (ServiceResultsImpl)this.service.runService(this.cc, this.logger);
            }
            catch (ServiceFailedException sfe) {
                this.resultObj = sfe;
            }
            catch (Exception e) {
                this.resultObj = ProviderImpl.wrapUnhandledServiceException(this.service, e);
            }
        }
    }

    private static class SameHostServiceInfoComparator
    implements Comparator,
    Serializable {
        private boolean caseSensitive;
        private static final long serialVersionUID = 1L;

        public SameHostServiceInfoComparator(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        public int compare(Object obj1, Object obj2) {
            ServiceInfo si1 = (ServiceInfo)obj1;
            ServiceInfo si2 = (ServiceInfo)obj2;
            return this.caseSensitive ? si1.getName().compareTo(si2.getName()) : si1.getName().compareToIgnoreCase(si2.getName());
        }
    }
}

