/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.provider;

import com.sas.dpro.common.InvalidProviderNameException;
import com.sas.dpro.common.ProviderNotAvailableException;
import com.sas.dpro.provider.Provider;
import com.sas.dpro.provider.ProviderImpl;
import com.sas.dpro.provider.ProviderInfo;
import com.sas.dpro.provider.ProviderInfoImpl;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class ProviderFactory {
    public static final String PROVIDER_LOCAL = "server-local";
    public static final String PROVIDER_REMOTE = "server-remote";
    private static Provider LOCAL_PROVIDER_INSTANCE;
    static final String _PROVIDER_BINDNAME = "Provider";
    private static final String REGEX_PROVIDER_NAME = "^[^:]+:[^:]+$";
    private static final String BUNDLE = "com.sas.dpro.provider.ProviderFactory";
    private static final ResourceBundle msg;

    private ProviderFactory() {
    }

    private static Provider createLocalProvider() {
        return new ProviderImpl();
    }

    public static ProviderInfo createProviderInfo(String host, int port, boolean serviceInfos, boolean contractInfos) {
        return ProviderFactory.createProviderInfo(ProviderFactory.createProviderName(host, port), serviceInfos, contractInfos);
    }

    public static ProviderInfo createProviderInfo(String providerName, boolean serviceInfos, boolean contractInfos) {
        return new ProviderInfoImpl(providerName, serviceInfos, contractInfos);
    }

    public static final String createProviderName(String host, int port) {
        return host + ':' + port;
    }

    private static synchronized Provider getLocalProvider() {
        if (LOCAL_PROVIDER_INSTANCE == null) {
            LOCAL_PROVIDER_INSTANCE = ProviderFactory.createLocalProvider();
        }
        return LOCAL_PROVIDER_INSTANCE;
    }

    public static String getLocalProviderName() {
        Provider p = ProviderFactory.getLocalProvider();
        try {
            return p.getProviderName();
        }
        catch (RemoteException re) {
            return PROVIDER_LOCAL;
        }
    }

    public static synchronized Provider getProvider(String providerName) throws InvalidProviderNameException {
        Provider provider = null;
        if (ProviderFactory.isLocalProvider(providerName)) {
            provider = ProviderFactory.getLocalProvider();
        } else if (providerName.matches(REGEX_PROVIDER_NAME)) {
            String[] hostInfo = providerName.split(":");
            if (hostInfo.length != 2) {
                String s = msg.getString("ProviderFactory.Error.HostPort.txt");
                throw new InvalidProviderNameException(providerName, s);
            }
            String host = null;
            if (!hostInfo[0].equals(PROVIDER_REMOTE)) {
                host = hostInfo[0];
            }
            int port = 0;
            try {
                port = Integer.parseInt(hostInfo[1]);
            }
            catch (NumberFormatException nfe) {
                String desc = msg.getString("Error.InvalidPort.fmt.txt");
                desc = MessageFormat.format(desc, hostInfo[1]);
                throw new InvalidProviderNameException(providerName, desc);
            }
            try {
                if (port == -99999) {
                    provider = ProviderFactory.getLocalProvider();
                }
                Registry registry = LocateRegistry.getRegistry(host, port);
                provider = (Provider)registry.lookup(_PROVIDER_BINDNAME);
            }
            catch (Exception e) {
                String s = msg.getString("ProviderFactory.Error.ProviderLookup.fmt.txt");
                s = MessageFormat.format(s, e.getMessage());
                throw new ProviderNotAvailableException(providerName, s);
            }
        } else {
            String s = msg.getString("ProviderFactory.Error.ExplicitNamesUnsupported.txt");
            throw new InvalidProviderNameException(providerName, s);
        }
        return provider;
    }

    public static boolean isLocalProvider(String hostPort) {
        try {
            return hostPort == null || hostPort.equals(PROVIDER_LOCAL) || hostPort.endsWith("-99999") || hostPort.equals(ProviderFactory.getLocalProvider().getProviderName());
        }
        catch (RemoteException re) {
            return false;
        }
    }

    static synchronized void setLocalProvider(Provider p) {
        LOCAL_PROVIDER_INSTANCE = p;
    }

    public static synchronized void shutdown() {
    }

    static {
        msg = ResourceBundle.getBundle(BUNDLE);
    }
}

