/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.formatter.standard;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.FileListImpl;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.formatter.FormatterWriter;
import com.sas.dpro.formatter.standard.DefaultResultsFormatter;
import com.sas.dpro.service.Service;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class GroovyScriptResultsFormatter
extends DefaultResultsFormatter {
    private File scriptFile;
    private Charset cs;
    private static final String MSG = "com.sas.dpro.formatter.standard.GroovyScriptResultsFormatter";
    private static ResourceBundle errorMsg;

    public GroovyScriptResultsFormatter(File scriptFile, Charset cs) {
        if (scriptFile == null) {
            throw new NullPointerException("scriptFile cannot be null");
        }
        if (cs == null) {
            throw new NullPointerException("cs cannot be null");
        }
        this.scriptFile = scriptFile;
        this.cs = cs;
    }

    @Override
    protected FileListImpl doFormatImpl(Service service, ContainerContext container, ContainerContext toFormat, String[] filesToFormat, List fcsToFormat, FormatterWriter writer, Map parameters) throws ServiceFailedException {
        if (!this.scriptFile.isFile()) {
            ResourceBundle msg = GroovyScriptResultsFormatter.getErrorBundle();
            String key = "Error.ScriptFileNotFound.fmt.txt";
            String text = DProUtil.formatString(msg, key, service.getName(), this.scriptFile.getAbsolutePath());
            throw new ServiceFailedException(text);
        }
        FileListImpl fileList = new FileListImpl(container.getDirectory(), container.getProviderName(), null);
        Binding binding = new Binding();
        try {
            binding.setVariable("service", (Object)service);
            binding.setVariable("container", (Object)container);
            binding.setVariable("toFormat", (Object)toFormat);
            binding.setVariable("filesToFormat", (Object)filesToFormat);
            binding.setVariable("fcsToFormat", (Object)fcsToFormat);
            binding.setVariable("writer", (Object)writer);
            binding.setVariable("parameters", (Object)parameters);
        }
        catch (Exception e) {
            ResourceBundle msg = GroovyScriptResultsFormatter.getErrorBundle();
            String key = "Error.SettingVars.fmt.txt";
            String text = e.getMessage();
            if (text == null) {
                text = e.toString();
            }
            text = DProUtil.formatString(msg, key, service.getName(), text);
            throw new ServiceFailedException(text, e);
        }
        GroovyShell shell = new GroovyShell(binding);
        try {
            String groovy = DProUtil.getLocalFileContents(this.scriptFile, this.cs);
            shell.evaluate(groovy, this.scriptFile.getName());
        }
        catch (Exception e) {
            ResourceBundle msg = GroovyScriptResultsFormatter.getErrorBundle();
            String key = "Error.EvaluatingGroovyCode.fmt.txt";
            String text = e.getMessage();
            if (text == null) {
                text = e.toString();
            }
            text = DProUtil.formatString(msg, key, service.getName(), text);
            throw new ServiceFailedException(text);
        }
        return fileList;
    }

    private static synchronized ResourceBundle getErrorBundle() {
        if (errorMsg == null) {
            errorMsg = ResourceBundle.getBundle(MSG);
        }
        return errorMsg;
    }
}

