/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.formatter;

import com.sas.dpro.common.ExternalProcessInfo;
import com.sas.dpro.formatter.FormatterFileParser;
import com.sas.dpro.formatter.FormatterWritable;
import com.sas.dpro.formatter.ResultsFormatter;
import com.sas.dpro.formatter.standard.ExternalProcessBasedResultsFormatter;
import com.sas.dpro.results.testing.TestSuiteResult;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;

public class ResultsFormatterFactory {
    private HashMap formatTypeToFormatterMap = new HashMap();
    private HashMap formatterMap = new HashMap();
    private static final ResultsFormatterFactory INSTANCE = new ResultsFormatterFactory();

    private ResultsFormatterFactory() {
    }

    void addFormatTypeToFormatterMap(String formatType, ClassJarPair pair) {
        this.formatTypeToFormatterMap.put(formatType, pair);
        String formatterClass = pair.getClassName();
        this.formatterMap.put(formatterClass, null);
    }

    void addFormatTypeToFormatterMap(String formatType, ExternalProcessInfo epi) {
        this.formatTypeToFormatterMap.put(formatType, epi);
    }

    void addFormatTypeToFormatterMap(String formatType, ResultsFormatter rf) {
        this.formatTypeToFormatterMap.put(formatType, rf);
    }

    public void addFormatTypeToFormatterMaps(String fileName) throws IOException {
        FormatterFileParser.parse(this, fileName);
    }

    public FormatterWritable getFormatterWritableForElement(String element) {
        return new TestSuiteResult();
    }

    public static ResultsFormatterFactory getInstance() {
        return INSTANCE;
    }

    public ResultsFormatter getResultsFormatter(String formatType) throws Exception {
        ResultsFormatter formatter = null;
        Object obj = this.formatTypeToFormatterMap.get(formatType);
        if (obj instanceof ClassJarPair) {
            ClassJarPair pair = (ClassJarPair)obj;
            Class formatterClass = pair.getClazz();
            formatter = (ResultsFormatter)this.formatterMap.get(formatterClass);
            if (formatter == null) {
                formatter = (ResultsFormatter)formatterClass.newInstance();
                this.formatterMap.put(formatterClass, formatter);
            }
        } else if (obj instanceof ExternalProcessInfo) {
            ExternalProcessInfo epi = (ExternalProcessInfo)obj;
            formatter = (ResultsFormatter)this.formatterMap.get(epi);
            if (formatter == null) {
                formatter = new ExternalProcessBasedResultsFormatter(epi);
                this.formatterMap.put(epi, formatter);
            }
        } else if (obj instanceof ResultsFormatter) {
            formatter = (ResultsFormatter)obj;
        } else if (obj != null) {
            throw new Exception("Internal error: Unknown formatter data for formatType: " + formatType + " in formatTypeToFormatterMap: " + obj.getClass());
        }
        return formatter;
    }

    static class ClassJarPair {
        private String className;
        private String jar;
        private Class clazz;
        private ClassLoader cl;

        public ClassJarPair(String clazz, String jar) throws Exception {
            this.className = clazz;
            this.jar = jar;
            this.cl = ClassLoader.getSystemClassLoader();
            if (jar != null) {
                URL[] urls = new URL[]{new File(jar).toURI().toURL()};
                this.cl = new URLClassLoader(urls, this.cl);
            }
        }

        public String getClassName() {
            return this.className;
        }

        public synchronized Class getClazz() throws ClassNotFoundException {
            if (this.clazz == null) {
                this.clazz = Class.forName(this.className, true, this.cl);
            }
            return this.clazz;
        }

        public String getJar() {
            return this.jar;
        }
    }
}

