/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.formatter;

import com.sas.dpro.formatter.FormatterReadWriteBase;
import com.sas.dpro.formatter.FormatterWritable;
import com.sas.dpro.formatter.FormatterWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FormatterWriterImpl
extends FormatterReadWriteBase
implements FormatterWriter {
    private Document doc;
    private Element root;
    private static final String WARNING_COMMENT = "NOTE: This XML format is a draft and may change without notice.";

    public FormatterWriterImpl() throws ParserConfigurationException {
        DocumentBuilder db = new DocumentBuilderFactoryImpl().newDocumentBuilder();
        DOMImplementation impl = db.getDOMImplementation();
        this.doc = impl.createDocument(null, "DProFormatterOutput", null);
        this.root = this.doc.getDocumentElement();
        this.root.appendChild(this.doc.createComment(WARNING_COMMENT));
    }

    @Override
    public synchronized void finish() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String getXML() {
        String xml = null;
        StringWriter sw = new StringWriter();
        BufferedWriter w = new BufferedWriter(sw);
        try {
            StreamResult result = new StreamResult(w);
            DOMSource source = new DOMSource(this.doc);
            TransformerFactory transFac = TransformerFactory.newInstance();
            Transformer transformer = transFac.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(source, result);
            xml = sw.toString();
        }
        catch (TransformerException te) {
            StringWriter sw2 = new StringWriter();
            PrintWriter pw = new PrintWriter(sw2);
            te.printStackTrace(pw);
            xml = "Error generating XML output:\n" + sw2.toString();
            pw.close();
        }
        finally {
            try {
                w.close();
            }
            catch (IOException ioe) {
                xml = "Error closing writer in FormatterWriter";
            }
        }
        return xml;
    }

    @Override
    public synchronized void write(FormatterWritable writable) {
        writable.write(this.doc, this.root);
    }
}

