/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.formatter;

import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.ExternalProcessInfoImpl;
import com.sas.dpro.common.FileParserBase;
import com.sas.dpro.formatter.ResultsFormatterFactory;
import com.sas.dpro.formatter.standard.GroovyScriptResultsFormatter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class FormatterFileParser
extends FileParserBase {
    private ResultsFormatterFactory factory;
    private File formatterFile;
    private static final String MSG = "com.sas.dpro.formatter.FormatterFileParser";
    private static final String ARGS = "args";
    private static final String CHARSET = "characterSet";
    private static final String COMMAND = "command";
    private static final String ENVIRONMENT_VARS = "environmentVars";
    private static final String EP_RESULTS_FORMATTER = "ExternalProcessBasedResultsFormatter";
    private static final String FORMAT_TYPE = "formatType";
    private static final String FORMATTER_CLASS = "formatterClass";
    private static final String GROOVY_RESULTS_FORMATTER = "GroovyScriptResultsFormatter";
    private static final String JAR = "jar";
    private static final String RESULTS_FORMATTER = "ResultsFormatter";
    private static final String ROOT_ELEMENT = "Formatters";
    private static final String SCRIPT_FILE = "scriptFile";
    private static final String USE_STDERR_IN_ERRORS = "useStderrInErrorMessages";
    private static final String PROPERTY_DEBUG = "com.sas.dpro.formatter.FormatterFileParser.debug";

    private FormatterFileParser(ResultsFormatterFactory factory, File formatterFile) {
        this.factory = factory;
        this.formatterFile = formatterFile;
    }

    private SAXBuilder createSAXBuilder() throws IOException {
        boolean validate = true;
        SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser", validate);
        if (validate) {
            builder.setFeature("http://apache.org/xml/features/validation/schema", true);
            builder.setEntityResolver((EntityResolver)new FormatterFileEntityResolver());
        }
        return builder;
    }

    private ResourceBundle getBundle() {
        return ResourceBundle.getBundle(MSG);
    }

    @Override
    protected String getDebugHeader() {
        return "[FormatterFileParser]";
    }

    @Override
    protected String getDebugProperty() {
        return PROPERTY_DEBUG;
    }

    @Override
    protected File getXMLFile() {
        return this.formatterFile;
    }

    private void handleParse() throws IOException {
        String version;
        SAXBuilder builder = this.createSAXBuilder();
        Document doc = null;
        try {
            doc = builder.build(this.formatterFile);
        }
        catch (JDOMException je) {
            je.printStackTrace();
            throw new IOException(je.getMessage());
        }
        Element root = doc.getRootElement();
        if (!ROOT_ELEMENT.equals(root.getName())) {
            this.handleUnknownElement(root.getName(), null);
        }
        if ((version = root.getAttributeValue("version")) == null || !"1.0".equals(version)) {
            String desc = this.getBundle().getString("Error.UnsupportedVersion.fmt.txt");
            desc = MessageFormat.format(desc, version);
            throw new IOException(desc);
        }
        for (Element child : root.getChildren()) {
            String nodeName = child.getName();
            if ("loadPropertiesFile".equals(nodeName)) {
                this.handlePropertiesFileNode(child);
                continue;
            }
            if (EP_RESULTS_FORMATTER.equals(nodeName)) {
                this.handleEPBasedResultsFormatterNode(child);
                continue;
            }
            if (GROOVY_RESULTS_FORMATTER.equals(nodeName)) {
                this.handleGroovyResultsFormatterNode(child);
                continue;
            }
            if (RESULTS_FORMATTER.equals(nodeName)) {
                this.handleResultsFormatterNode(child);
                continue;
            }
            this.handleUnknownElement(nodeName, root.getName());
        }
    }

    private void handleEPBasedResultsFormatterNode(Element elem) throws IOException {
        String text;
        String key;
        ResourceBundle msg;
        String formatType = null;
        String command = null;
        List argList = null;
        HashMap envVars = null;
        boolean appendEnvVars = true;
        boolean useStderrInErrors = false;
        Element child2 = elem.getChild(COMMAND);
        command = child2.getText();
        command = this.replaceVariables(command);
        command = this.ensureAbsolute(command);
        child2 = elem.getChild(FORMAT_TYPE);
        formatType = child2.getText();
        if (!this.shouldLoad(elem, formatType = this.replaceVariables(formatType))) {
            return;
        }
        for (Element child2 : elem.getChildren()) {
            String name = child2.getName();
            if (ARGS.equals(name)) {
                argList = this.handleArgsNode(child2, command);
                continue;
            }
            if (COMMAND.equals(name)) continue;
            if (ENVIRONMENT_VARS.equals(name)) {
                if (envVars == null) {
                    envVars = new HashMap(1);
                }
                appendEnvVars = this.handleEnvVarsNode(child2, envVars);
                continue;
            }
            if (FORMAT_TYPE.equals(name)) continue;
            if (USE_STDERR_IN_ERRORS.equals(name)) {
                String temp = child2.getText();
                temp = this.replaceVariables(temp);
                useStderrInErrors = Boolean.parseBoolean(temp);
                continue;
            }
            this.handleUnknownElement(name, elem.getName());
        }
        if (command == null) {
            msg = this.getBundle();
            key = "Error.UnspecifiedValue.fmt.txt";
            text = DProUtil.formatString(msg, key, COMMAND);
            throw new IOException(text);
        }
        if (formatType == null) {
            msg = this.getBundle();
            key = "Error.UnspecifiedValue.fmt.txt";
            text = DProUtil.formatString(msg, key, FORMAT_TYPE);
            throw new IOException(text);
        }
        this.debugPrint("Mapping Formatter '" + formatType + "' to '" + command + "'");
        ExternalProcessInfoImpl epi = new ExternalProcessInfoImpl(command);
        epi.addArgs(argList);
        epi.addEnvVars(envVars);
        epi.setAppendEnvVars(appendEnvVars);
        epi.setUseStderrInErrorMessages(useStderrInErrors);
        this.factory.addFormatTypeToFormatterMap(formatType, epi);
    }

    private void handleGroovyResultsFormatterNode(Element elem) throws IOException {
        String text;
        String key;
        ResourceBundle msg;
        String formatType = null;
        File scriptFile = null;
        Charset cs = null;
        for (Element child : elem.getChildren()) {
            String name = child.getName();
            if (FORMAT_TYPE.equals(name)) {
                formatType = child.getText();
                formatType = this.replaceVariables(formatType);
                continue;
            }
            if (SCRIPT_FILE.equals(name)) {
                String fileName = child.getText();
                fileName = this.replaceVariables(fileName);
                fileName = this.ensureAbsolute(fileName);
                scriptFile = new File(fileName);
                String csName = child.getAttributeValue(CHARSET);
                if (csName == null || "default".equals(csName)) {
                    cs = Charset.defaultCharset();
                    continue;
                }
                try {
                    cs = Charset.forName(csName);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IOException(e.getMessage());
                }
            }
            this.handleUnknownElement(name, elem.getName());
        }
        if (!this.shouldLoad(elem, formatType)) {
            return;
        }
        if (formatType == null) {
            msg = this.getBundle();
            key = "Error.UnspecifiedValue.fmt.txt";
            text = DProUtil.formatString(msg, key, FORMAT_TYPE);
            throw new IOException(text);
        }
        if (scriptFile == null) {
            msg = this.getBundle();
            key = "Error.UnspecifiedValue.fmt.txt";
            text = DProUtil.formatString(msg, key, SCRIPT_FILE);
            throw new IOException(text);
        }
        if (!scriptFile.isFile()) {
            msg = this.getBundle();
            key = "Error.GroovyFileDoesNotExist.fmt.txt";
            text = DProUtil.formatString(msg, key, scriptFile.getAbsolutePath());
            throw new IOException(text);
        }
        this.debugPrint("Mapping Formatter '" + formatType + "' to '" + scriptFile + "' (" + cs.displayName() + ")");
        GroovyScriptResultsFormatter gsrf = new GroovyScriptResultsFormatter(scriptFile, cs);
        this.factory.addFormatTypeToFormatterMap(formatType, gsrf);
    }

    private void handleResultsFormatterNode(Element elem) throws IOException {
        String text;
        String key;
        ResourceBundle msg;
        String formatType = null;
        String formatterClass = null;
        String jar = null;
        for (Element child : elem.getChildren()) {
            String name = child.getName();
            if (FORMAT_TYPE.equals(name)) {
                formatType = child.getText();
                formatType = this.replaceVariables(formatType);
                continue;
            }
            if (FORMATTER_CLASS.equals(name)) {
                formatterClass = child.getText();
                formatterClass = this.replaceVariables(formatterClass);
                continue;
            }
            if (JAR.equals(name)) {
                jar = child.getText();
                jar = this.replaceVariables(jar);
                jar = this.ensureAbsolute(jar);
                continue;
            }
            this.handleUnknownElement(name, elem.getName());
        }
        if (!this.shouldLoad(elem, formatType)) {
            return;
        }
        if (formatType == null) {
            msg = this.getBundle();
            key = "Error.UnspecifiedValue.fmt.txt";
            text = DProUtil.formatString(msg, key, FORMAT_TYPE);
            throw new IOException(text);
        }
        if (formatterClass == null) {
            msg = this.getBundle();
            key = "Error.UnspecifiedValue.fmt.txt";
            text = DProUtil.formatString(msg, key, FORMATTER_CLASS);
            throw new IOException(text);
        }
        this.debugPrint("Mapping Formatter '" + formatType + "' to '" + formatterClass + "' in jar " + jar);
        try {
            ResultsFormatterFactory.ClassJarPair pair = new ResultsFormatterFactory.ClassJarPair(formatterClass, jar);
            this.factory.addFormatTypeToFormatterMap(formatType, pair);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    private void handleUnknownElement(String elem, String parent) throws IOException {
        String key = "Error.UnknownElement.fmt.txt";
        String desc = DProUtil.formatString(this.getBundle(), key, elem, parent);
        throw new IOException(desc);
    }

    static void parse(ResultsFormatterFactory factory, String formatterFile) throws IOException {
        File file = new File(formatterFile);
        FormatterFileParser parser = new FormatterFileParser(factory, file);
        parser.handleParse();
    }

    private static final class FormatterFileEntityResolver
    implements EntityResolver {
        private static final String SCHEMA_NAME_1_5 = "com/sas/schema/formatters-1.5.xsd";
        private static final String SYSTEM_ID_1_5 = "http://www.sas.com/xml/schema/dpro/formatters-1.5.xsd";
        private static final String SCHEMA_NAME_1_6 = "com/sas/schema/formatters-1.6.xsd";
        private static final String SYSTEM_ID_1_6 = "http://www.sas.com/xml/schema/dpro/formatters-1.6.xsd";

        private FormatterFileEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            InputSource retval = null;
            if (SYSTEM_ID_1_6.equals(systemId)) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                InputStream stream = cl.getResourceAsStream(SCHEMA_NAME_1_6);
                retval = new InputSource(stream);
            } else if (SYSTEM_ID_1_5.equals(systemId)) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                InputStream stream = cl.getResourceAsStream(SCHEMA_NAME_1_5);
                retval = new InputSource(stream);
            }
            return retval;
        }
    }
}

