/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.controller;

import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.FileList;
import com.sas.dpro.common.FileSet;
import com.sas.dpro.common.Macro;
import com.sas.dpro.controller.HonorContractParms;
import java.io.Serializable;

public class HonorContractParmsImpl
implements HonorContractParms,
Serializable {
    private String contract;
    private String contractCode;
    private String locale;
    private String[] variables;
    private FileList[] fileLists;
    private FileSet[] fileSets;
    private Macro[] macros;
    private int messageGranularity;
    private String clientVersion;
    private long timeout;
    private long originalContractSessionID;
    private static final long serialVersionUID = 1L;

    public HonorContractParmsImpl() {
        this(null, null);
    }

    public HonorContractParmsImpl(String contract, String[] variables) {
        this.setContract(contract);
        this.setVariables(variables);
        this.setMessageGranularity(0);
        this.setOriginalContractSessionID(-1L);
        this.setTimeout(-1L);
    }

    @Override
    public String getClientDPROVersion() {
        return this.clientVersion;
    }

    @Override
    public String getContract() {
        return this.contract;
    }

    @Override
    public String getContractCode() {
        return this.contractCode;
    }

    @Override
    public FileList[] getFileLists() {
        FileList[] copy = null;
        if (this.fileLists != null) {
            copy = (FileList[])this.fileLists.clone();
        }
        return copy;
    }

    @Override
    public FileSet[] getFileSets() {
        FileSet[] copy = null;
        if (this.fileSets != null) {
            copy = (FileSet[])this.fileSets.clone();
        }
        return copy;
    }

    @Override
    public String getLocale() {
        return this.locale;
    }

    @Override
    public Macro[] getMacros() {
        Macro[] copy = null;
        if (this.macros != null) {
            copy = (Macro[])this.macros.clone();
        }
        return copy;
    }

    @Override
    public int getMessageGranularity() {
        return this.messageGranularity;
    }

    @Override
    public long getOriginalContractSessionID() {
        return this.originalContractSessionID;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public String[] getVariables() {
        return DProUtil.cloneStringArray(this.variables);
    }

    @Override
    public void setClientDPROVersion(String clientVersion) {
        this.clientVersion = clientVersion;
    }

    @Override
    public void setContract(String contract) {
        this.contract = contract;
    }

    @Override
    public void setContractCode(String code) {
        this.contractCode = code;
    }

    @Override
    public void setFileLists(FileList[] fileLists) {
        this.fileLists = null;
        if (fileLists != null) {
            this.fileLists = (FileList[])fileLists.clone();
        }
    }

    @Override
    public void setFileSets(FileSet[] fileSets) {
        this.fileSets = null;
        if (fileSets != null) {
            this.fileSets = (FileSet[])fileSets.clone();
        }
    }

    @Override
    public void setLocale(String locale) {
        this.locale = locale;
    }

    @Override
    public void setMacros(Macro[] macros) {
        this.macros = null;
        if (macros != null) {
            this.macros = (Macro[])macros.clone();
        }
    }

    @Override
    public void setMessageGranularity(int granularity) {
        this.messageGranularity = granularity;
    }

    @Override
    public void setOriginalContractSessionID(long id) {
        this.originalContractSessionID = id;
    }

    @Override
    public void setTimeout(long timeout) {
        if (timeout != -1L && timeout < 0L) {
            throw new IllegalArgumentException();
        }
        this.timeout = timeout;
    }

    @Override
    public void setVariables(String[] variables) {
        this.variables = DProUtil.cloneStringArray(variables);
    }

    public String toString() {
        int varCount = this.variables == null ? 0 : this.variables.length / 2;
        int fileListCount = this.fileLists == null ? 0 : this.fileLists.length;
        int fileSetCount = this.fileSets == null ? 0 : this.fileSets.length;
        int macroCount = this.macros == null ? 0 : this.macros.length;
        return "[HonorContractParmsImpl: contract=" + this.getContract() + "; variable count=" + varCount + "; fileList count=" + fileListCount + "; fileSet count=" + fileSetCount + "; macro count=" + macroCount + "; locale=" + this.getLocale() + "; messageGranularity=" + this.getMessageGranularity() + "; clientDPROVersion=" + this.getClientDPROVersion() + "; timeout=" + this.getTimeout() + "; originalContractSessionID=" + this.getOriginalContractSessionID() + "]";
    }
}

