/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.controller;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.DirList;
import com.sas.dpro.common.DirSet;
import com.sas.dpro.common.FileList;
import com.sas.dpro.common.FileSet;
import com.sas.dpro.common.FilterSet;
import com.sas.dpro.common.InputPromptInfo;
import com.sas.dpro.common.InvalidProviderNameException;
import com.sas.dpro.common.Macro;
import com.sas.dpro.common.PatternSet;
import com.sas.dpro.common.WorkUnit;
import com.sas.dpro.common.WorkUnitImpl;
import com.sas.dpro.contract.messages.ContractCompletedMessage;
import com.sas.dpro.contract.messages.MessageQueue;
import com.sas.dpro.contract.messages.ResultsMessageImpl;
import com.sas.dpro.contract.messages.ServiceCompletedMessage;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.ContractRunnerFactory;
import com.sas.dpro.controller.ContractSession;
import com.sas.dpro.controller.Controller;
import com.sas.dpro.controller.ControllerImpl;
import com.sas.dpro.controller.HonorContractContext;
import com.sas.dpro.controller.ServiceResultsManager;
import com.sas.dpro.controller.VariableManager;
import com.sas.dpro.provider.CreateContainerContextParmsImpl;
import com.sas.dpro.provider.Provider;
import com.sas.dpro.provider.ProviderFactory;
import com.sas.dpro.service.ServiceResults;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Pattern;

public class ContractSessionThread
extends Thread
implements ContractSession {
    private ControllerImpl controller;
    private MessageQueue queue;
    private long sessionID;
    private File contract;
    private String contractCode;
    private boolean contractTimedOut;
    private VariableManager variableManager;
    private ContainerContext defaultContainer;
    private ContainerContext defaultDefaultContainer;
    private Map containerContexts;
    private ServiceResultsManager contractResults;
    private Map dirLists;
    private Map dirSets;
    private Map fileLists;
    private Map fileSets;
    private Map filterSets;
    private Map macros;
    private Map patternSets;
    private Stack workUnitStack;
    private Stack workUnitStartStack;
    private int messageGranularity;
    private HonorContractContext hcc;
    private int lastRC;
    private CountDownLatch latch;
    private boolean started;
    private boolean paused;
    private static final int LAST_RC_UNKNOWN = -1;
    private Object LOCK_PAUSE = new Object();

    public ContractSessionThread(ControllerImpl controller, long sessionID, String[] variables, FileList[] fileLists, FileSet[] fileSets, Macro[] macros, File contractFile, MessageQueue queue) {
        if (contractFile == null) {
            throw new NullPointerException("contractFile cannot be null");
        }
        this.contract = contractFile;
        this.contractCode = null;
        this.init(controller, sessionID, variables, fileLists, fileSets, macros, queue);
    }

    public ContractSessionThread(ControllerImpl controller, long sessionID, String[] variables, FileList[] fileLists, FileSet[] fileSets, Macro[] macros, String contractCode, MessageQueue queue) {
        if (contractCode == null) {
            throw new NullPointerException("contractCode cannot be null");
        }
        this.contract = null;
        this.contractCode = contractCode;
        this.init(controller, sessionID, variables, fileLists, fileSets, macros, queue);
    }

    @Override
    public void addContainerContext(ContainerContext container) {
        this.containerContexts.put(container.getContractID(), container);
    }

    @Override
    public void addDirList(DirList dirList) {
        String id = dirList.getID();
        if (id != null) {
            this.dirLists.put(id, dirList);
        }
    }

    @Override
    public void addDirSet(DirSet dirSet) {
        String id = dirSet.getID();
        if (id != null) {
            this.dirSets.put(id, dirSet);
        }
    }

    @Override
    public void addFileList(FileList fileList) {
        String id = fileList.getID();
        if (id != null) {
            this.fileLists.put(id, fileList);
        }
    }

    @Override
    public void addFileSet(FileSet fileSet) {
        String id = fileSet.getID();
        if (id != null) {
            this.fileSets.put(id, fileSet);
        }
    }

    @Override
    public void addFilterSet(String id, FilterSet filterSet) {
        this.filterSets.put(id, filterSet);
    }

    @Override
    public void addMacro(Macro macro) {
        String name = macro.getID();
        this.macros.put(name, macro);
    }

    @Override
    public void addPatternSet(PatternSet patternSet) {
        String id = patternSet.getID();
        if (id != null) {
            this.patternSets.put(id, patternSet);
        }
    }

    @Override
    public void addServiceResults(ServiceResults sr) {
        if (sr != null) {
            this.contractResults.addServiceResults(sr);
            this.lastRC = sr.getReturnCode();
            if (sr.getStatus() != 0) {
                this.lastRC = -1;
            }
        }
    }

    @Override
    public void addServiceResults(ServiceCompletedMessage scm) {
        ServiceResults sr = scm.getServiceResults();
        if (sr != null) {
            String formattedResultsID;
            this.contractResults.addServiceResults(sr);
            this.lastRC = sr.getReturnCode();
            if (sr.getStatus() != 0) {
                this.lastRC = -1;
            }
            if ((formattedResultsID = sr.getFormattedResultsID()) != null) {
                HonorContractContext hcc = scm.getHonorContractContext();
                ResultsMessageImpl rm = new ResultsMessageImpl(hcc, 2);
                rm.setResultID(formattedResultsID);
                String formattedOutput = sr.getFormattedOutput();
                rm.setResultXML(formattedOutput);
                this.getMessageQueue().enqueue(rm);
            }
        } else {
            this.lastRC = -1;
        }
        if (this.messageGranularity == 2) {
            this.getMessageQueue().enqueue(scm);
        }
    }

    @Override
    public void addVariable(String name, String value, boolean readOnly) throws UnsupportedOperationException {
        this.variableManager.addVariable(name, value, readOnly);
    }

    @Override
    public void beginWait() throws InterruptedException {
        this.latch.await();
    }

    @Override
    public void closeContainer(String id) throws IllegalArgumentException, RemoteException {
        if ("_default".equals(id)) {
            String desc = this.controller.getBundle().getString("Error.CannotCloseDefaultContainer.txt");
            throw new IllegalArgumentException(desc);
        }
        ContainerContext context = (ContainerContext)this.containerContexts.remove(id);
        if (context == null) {
            String desc = this.controller.getBundle().getString("Error.NoSuchContainerContext.fmt.txt");
            desc = MessageFormat.format(desc, id);
            throw new IllegalArgumentException(desc);
        }
        String provider = context.getProviderName();
        try {
            Provider p = ProviderFactory.getProvider(provider);
            p.closeContainer(context);
        }
        catch (InvalidProviderNameException ipne) {
            String desc = this.controller.getBundle().getString("Error.BadContainerContext.fmt.txt");
            desc = MessageFormat.format(desc, provider);
            this.controller.getLogger().warning(desc);
        }
    }

    @Override
    public Map createVariableMap() {
        return this.variableManager.createVariableMap();
    }

    @Override
    public void endWait() {
        this.latch.countDown();
    }

    @Override
    public WorkUnit endWorkUnit() {
        long endNanos = System.nanoTime();
        WorkUnit wu = null;
        try {
            wu = (WorkUnit)this.workUnitStack.pop();
        }
        catch (EmptyStackException e) {
            throw new InternalError("ContractSessionThread.endWorkUnit: No active workUnits!");
        }
        long startNanos = (Long)this.workUnitStartStack.pop();
        wu.setExecutionTime(endNanos - startNanos);
        return wu;
    }

    @Override
    public ContainerContext getContainerContext(String id) {
        ContainerContext container = null;
        if (id != null) {
            container = id.equals("_default") ? this.getDefaultContainer() : (ContainerContext)this.containerContexts.get(id);
        }
        return container;
    }

    @Override
    public String getContractName() {
        return this.contract == null ? null : this.contract.getAbsolutePath();
    }

    @Override
    public boolean getContractTimedOut() {
        return this.contractTimedOut;
    }

    public Controller getController() {
        return this.controller;
    }

    @Override
    public synchronized ContainerContext getDefaultContainer() {
        return this.defaultContainer == null ? this.defaultDefaultContainer : this.defaultContainer;
    }

    @Override
    public DirList getDirList(String id) {
        return (DirList)this.dirLists.get(id);
    }

    @Override
    public Iterator getDirListIterator() {
        return this.dirLists.values().iterator();
    }

    @Override
    public DirSet getDirSet(String id) {
        return (DirSet)this.dirSets.get(id);
    }

    @Override
    public Iterator getDirSetIterator() {
        return this.dirSets.values().iterator();
    }

    @Override
    public FileList getFileList(String id) {
        return (FileList)this.fileLists.get(id);
    }

    @Override
    public Iterator getFileListIterator() {
        return this.fileLists.values().iterator();
    }

    @Override
    public FileSet getFileSet(String id) {
        return (FileSet)this.fileSets.get(id);
    }

    @Override
    public Iterator getFileSetIterator() {
        return this.fileSets.values().iterator();
    }

    @Override
    public FilterSet getFilterSet(String id) {
        return (FilterSet)this.filterSets.get(id);
    }

    @Override
    public HonorContractContext getHonorContractContext() {
        return this.hcc;
    }

    @Override
    public int getLastRC() {
        return this.lastRC;
    }

    @Override
    public Macro getMacro(String name) {
        return (Macro)this.macros.get(name);
    }

    @Override
    public Iterator getMacroIterator() {
        return this.macros.values().iterator();
    }

    @Override
    public int getMessageGranularity() {
        return this.messageGranularity;
    }

    @Override
    public MessageQueue getMessageQueue() {
        return this.queue;
    }

    @Override
    public PatternSet getPatternSet(String id) {
        return (PatternSet)this.patternSets.get(id);
    }

    @Override
    public ServiceResults getServiceResultsByID(String id) {
        return this.contractResults.getServiceResultsByID(id);
    }

    @Override
    public long getSessionID() {
        return this.sessionID;
    }

    @Override
    public boolean getStartedRemotely() {
        return this.hcc.isRunningRemotely();
    }

    public VariableManager getVariableManager() {
        return this.variableManager;
    }

    @Override
    public String[] getVariableNames(boolean includeReadOnly, Pattern p) {
        return this.variableManager.getVariableNames(includeReadOnly, p);
    }

    @Override
    public String getVariableValue(String name) {
        return this.variableManager.getVariableValue(name);
    }

    @Override
    public Iterator getWorkUnitIterator() {
        return this.workUnitStack.iterator();
    }

    private void init(ControllerImpl controller, long sessionID, String[] variables, FileList[] fileLists, FileSet[] fileSets, Macro[] macros, MessageQueue queue) {
        int i;
        this.controller = controller;
        this.queue = queue;
        this.sessionID = sessionID;
        this.variableManager = controller.createVariableManager(variables);
        this.variableManager.setContractSession(this);
        this.containerContexts = new HashMap();
        this.contractResults = new ServiceResultsManager();
        this.dirLists = new HashMap();
        this.dirSets = new HashMap();
        this.fileLists = new HashMap();
        this.fileSets = new HashMap();
        this.filterSets = new HashMap();
        this.macros = new HashMap();
        this.patternSets = new HashMap();
        this.workUnitStack = new Stack();
        this.workUnitStartStack = new Stack();
        this.messageGranularity = controller.getMessageGranularity();
        this.lastRC = Integer.MAX_VALUE;
        this.started = false;
        try {
            Provider p = ProviderFactory.getProvider("server-local");
            String clientVersion = controller.getClient().getClientDPROVersion();
            String contractID = "_default";
            int lifespan = 1;
            CreateContainerContextParmsImpl parms = new CreateContainerContextParmsImpl(clientVersion);
            parms.setContractID(contractID);
            parms.setContractSessionID(sessionID);
            parms.setDirectory(null);
            parms.setLifespan(lifespan);
            this.defaultDefaultContainer = p.createContainerContext(parms);
        }
        catch (InvalidProviderNameException p) {
        }
        catch (RemoteException p) {
            // empty catch block
        }
        int count = fileLists == null ? 0 : fileLists.length;
        for (i = 0; i < count; ++i) {
            try {
                this.addFileList((FileList)fileLists[i].clone());
                continue;
            }
            catch (CloneNotSupportedException cnse) {
                cnse.printStackTrace();
            }
        }
        count = fileSets == null ? 0 : fileSets.length;
        for (i = 0; i < count; ++i) {
            try {
                this.addFileSet((FileSet)fileSets[i].clone());
                continue;
            }
            catch (CloneNotSupportedException cnse) {
                cnse.printStackTrace();
            }
        }
        count = macros == null ? 0 : macros.length;
        for (i = 0; i < count; ++i) {
            try {
                this.addMacro((Macro)macros[i].clone());
                continue;
            }
            catch (CloneNotSupportedException cnse) {
                cnse.printStackTrace();
            }
        }
    }

    @Override
    public void initWait() {
        this.latch = new CountDownLatch(1);
    }

    @Override
    public void interrupt() {
        if (this.isStarted()) {
            super.interrupt();
        }
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        Object object = this.LOCK_PAUSE;
        synchronized (object) {
            if (!this.paused) {
                this.controller.pause(this);
                this.paused = true;
            }
        }
    }

    @Override
    public String promptForInput(InputPromptInfo info) throws IOException {
        return this.controller.promptForInput(info);
    }

    @Override
    public String replaceVariables(String text) {
        return this.variableManager.replaceVariables(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        ContractCompletedMessage ccm = null;
        try {
            ContractRunner runner = ContractRunnerFactory.getInstance().createContractRunner(this, this.controller.getClient().getClientDPROVersion());
            ccm = this.contract != null ? runner.runContract(this.contract) : runner.runContract(this.contractCode);
        }
        catch (Throwable throwable) {
            try {
                Provider p = ProviderFactory.getProvider("server-local");
                p.closeContainer(this.defaultDefaultContainer);
            }
            catch (Exception e) {
                this.controller.getLogger().warning(e.getMessage());
            }
            boolean doSave2 = ccm != null && this.getStartedRemotely();
            Set entrySet2 = this.containerContexts.entrySet();
            ArrayList<ContainerContext> contList2 = new ArrayList<ContainerContext>(1);
            Iterator i2 = entrySet2.iterator();
            while (i2.hasNext()) {
                Map.Entry entry = i2.next();
                i2.remove();
                ContainerContext cc = (ContainerContext)entry.getValue();
                if (doSave2) {
                    contList2.add(cc);
                    continue;
                }
                try {
                    String provider = cc.getProviderName();
                    Provider p = ProviderFactory.getProvider(provider);
                    p.closeContainer(cc);
                }
                catch (Exception e) {
                    this.controller.getLogger().warning(e.getMessage());
                }
            }
            if (doSave2 && ccm != null && !contList2.isEmpty()) {
                ContainerContext[] array = new ContainerContext[contList2.size()];
                array = contList2.toArray(array);
                ccm.setLeftOpenContainers(array);
            }
            this.controller.sessionCompleted(this, ccm);
            throw throwable;
        }
        try {
            Provider p = ProviderFactory.getProvider("server-local");
            p.closeContainer(this.defaultDefaultContainer);
        }
        catch (Exception e) {
            this.controller.getLogger().warning(e.getMessage());
        }
        boolean doSave = ccm != null && this.getStartedRemotely();
        Set entrySet = this.containerContexts.entrySet();
        ArrayList<ContainerContext> contList = new ArrayList<ContainerContext>(1);
        Iterator i = entrySet.iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            i.remove();
            ContainerContext cc = (ContainerContext)entry.getValue();
            if (doSave) {
                contList.add(cc);
                continue;
            }
            try {
                String provider = cc.getProviderName();
                Provider p = ProviderFactory.getProvider(provider);
                p.closeContainer(cc);
            }
            catch (Exception e) {
                this.controller.getLogger().warning(e.getMessage());
            }
        }
        if (doSave && ccm != null && !contList.isEmpty()) {
            ContainerContext[] array = new ContainerContext[contList.size()];
            array = contList.toArray(array);
            ccm.setLeftOpenContainers(array);
        }
        this.controller.sessionCompleted(this, ccm);
    }

    @Override
    public void setContractTimedOut() {
        this.contractTimedOut = true;
        this.interrupt();
    }

    @Override
    public synchronized void setDefaultContainer(String id) throws IllegalArgumentException {
        if (id == null) {
            this.defaultContainer = null;
        } else {
            ContainerContext cc = this.getContainerContext(id);
            if (cc == null) {
                ResourceBundle msg = this.controller.getBundle();
                String key = "Error.NoSuchContainerContext.fmt.txt";
                String desc = DProUtil.formatString(msg, key, id);
                throw new IllegalArgumentException(desc);
            }
            this.defaultContainer = cc;
        }
    }

    public void setHonorContractContext(HonorContractContext hcc) {
        this.hcc = hcc;
    }

    @Override
    public void setMessageGranularity(int granularity) {
        this.messageGranularity = granularity;
    }

    @Override
    public void setTimeout(int seconds) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ContractSessionThread.this.setContractTimedOut();
            }
        };
        this.controller.addTimeoutRunnable(r, seconds);
    }

    public void setVariableManager(VariableManager manager) {
        this.variableManager = manager;
    }

    @Override
    public void setVariableValue(String name, String value) throws UnsupportedOperationException {
        this.variableManager.setVariableValue(name, value);
    }

    @Override
    public void startSession() {
        if (!this.started) {
            this.started = true;
            this.start();
        }
    }

    @Override
    public WorkUnit startWorkUnit() {
        WorkUnitImpl wu = new WorkUnitImpl();
        this.workUnitStack.add(wu);
        this.workUnitStartStack.add(new Long(System.nanoTime()));
        return wu;
    }

    @Override
    public String toString() {
        return "[ContractSessionThread: sessionID=" + this.getSessionID() + "; contract=" + this.getContractName() + "; alive=" + this.isAlive() + "; started=" + this.isStarted() + "; paused=" + this.paused + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unpause() {
        Object object = this.LOCK_PAUSE;
        synchronized (object) {
            if (this.paused) {
                this.controller.unpause(this);
                this.paused = false;
            }
        }
    }
}

