/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.common.WorkUnit;
import com.sas.dpro.contract.messages.WorkUnitStartedMessageImpl;
import com.sas.dpro.contract.parser.AbstractActionNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import com.sas.dpro.controller.HonorContractContext;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import org.jdom2.Element;

public class WorkUnitNodeHandler
extends AbstractActionNodeHandler {
    public static final String HANDLED_NODE_TYPE = "workUnit";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TYPE = "type";

    public WorkUnitNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        if (!this.checkIfAttribute(node, session, contract)) {
            return new DefaultNodeHandlerResults();
        }
        WorkUnit wu = session.startWorkUnit();
        String orig = node.getAttributeValue(ATTR_NAME);
        if (orig != null) {
            String name = session.replaceVariables(orig);
            wu.setName(name);
        }
        if ((orig = node.getAttributeValue(ATTR_DESCRIPTION)) != null) {
            String desc = session.replaceVariables(orig);
            wu.setDescription(desc);
        }
        if ((orig = node.getAttributeValue(ATTR_TYPE)) != null) {
            String type = session.replaceVariables(orig);
            wu.setType(type);
        }
        HonorContractContext hcc = session.getHonorContractContext();
        WorkUnitStartedMessageImpl wusm = new WorkUnitStartedMessageImpl(hcc, wu);
        session.getMessageQueue().enqueue(wusm);
        WorkUnitNodeHandlerResults nhr = new WorkUnitNodeHandlerResults();
        return nhr;
    }

    private static class WorkUnitNodeHandlerResults
    extends DefaultNodeHandlerResults {
        private WorkUnitNodeHandlerResults() {
        }

        @Override
        public boolean getCouldParseChildren(ContractSession session) {
            return true;
        }

        @Override
        public boolean getShouldParseChildren(ContractSession session, int iter) {
            return iter == 1;
        }

        @Override
        public boolean isWorkUnit() {
            return true;
        }
    }
}

