/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.parser.AbstractActionNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.ExpressionParser;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import org.jdom2.Element;

public class WhileNodeHandler
extends AbstractActionNodeHandler {
    public static final String HANDLED_NODE_TYPE = "while";
    private static final String ATTR_TEST = "test";

    public WhileNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        String test = node.getAttributeValue(ATTR_TEST);
        WhileNodeHandlerResults res = new WhileNodeHandlerResults(test);
        return res;
    }

    protected class WhileNodeHandlerResults
    extends DefaultNodeHandlerResults {
        private String test;

        public WhileNodeHandlerResults(String test) {
            this.test = test;
        }

        @Override
        public boolean getCouldParseChildren(ContractSession session) {
            return true;
        }

        @Override
        public boolean getShouldParseChildren(ContractSession s, int iter) throws InvalidContractException {
            return ExpressionParser.getInstance().parseBooleanExpression(this.test, WhileNodeHandler.this.getHandledNodeType(), s);
        }
    }
}

