/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.contract.parser.VarMatchNodeHandler;
import com.sas.dpro.controller.ContractSession;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom2.Element;

public class VarSubstituteNodeHandler
extends VarMatchNodeHandler {
    public static final String HANDLED_NODE_TYPE = "varSubstitute";
    public static final String TYPE_REGEX = "regex";
    public static final String TYPE_TEXT = "text";
    private static final String ATTR_GLOBAL = "global";
    private static final String ATTR_GROUP_INDEX = "group";
    private static final String ATTR_GROUP_VARIABLE = "variable";
    private static final String ATTR_IGNORE_CASE = "ignoreCase";
    private static final String ATTR_REPLACE_WITH = "replaceWith";
    private static final String ATTR_RESULT = "result";
    private static final String ATTR_SEARCH_FOR = "searchFor";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_VARIABLE = "variable";
    private static final String PARAM_GROUP = "captureGroup";

    public VarSubstituteNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        String orig = node.getAttributeValue(ATTR_TYPE);
        String type = session.replaceVariables(orig);
        if (!TYPE_REGEX.equals(type) && !TYPE_TEXT.equals(type)) {
            ResourceBundle msg = runner.getErrorBundle();
            String desc = msg.getString("Error.InvalidAttribute.fmt.txt");
            desc = MessageFormat.format(desc, this.getHandledNodeType(), ATTR_TYPE, type, orig);
            throw new InvalidContractException(desc, contract);
        }
        String origVarName = node.getAttributeValue("variable");
        String varName = null;
        String origSearchFor = node.getAttributeValue(ATTR_SEARCH_FOR);
        String searchFor = session.replaceVariables(origSearchFor);
        String replaceWith = node.getAttributeValue(ATTR_REPLACE_WITH);
        replaceWith = session.replaceVariables(replaceWith);
        String strGlobal = node.getAttributeValue(ATTR_GLOBAL);
        strGlobal = session.replaceVariables(strGlobal);
        boolean global = runner.ensureBoolean(strGlobal, this.getHandledNodeType(), ATTR_GLOBAL, node.getAttributeValue(ATTR_GLOBAL));
        String strIgnoreCase = node.getAttributeValue(ATTR_IGNORE_CASE);
        strIgnoreCase = session.replaceVariables(strIgnoreCase);
        boolean ignoreCase = runner.ensureBoolean(strIgnoreCase, this.getHandledNodeType(), ATTR_IGNORE_CASE, node.getAttributeValue(ATTR_IGNORE_CASE));
        String resVar = node.getAttributeValue(ATTR_RESULT);
        if (resVar != null) {
            resVar = this.getVariableNameChecked(resVar, false, session, runner, contract);
        }
        List children = node.getChildren(PARAM_GROUP);
        HashMap<String, String> regexCapturedGroups = null;
        if (TYPE_REGEX.equals(type)) {
            regexCapturedGroups = new HashMap<String, String>();
            for (Element elem : children) {
                String strIndex = elem.getAttributeValue(ATTR_GROUP_INDEX);
                strIndex = session.replaceVariables(strIndex);
                String var = elem.getAttributeValue("variable");
                var = session.replaceVariables(var);
                regexCapturedGroups.put(strIndex, var);
            }
        } else if (!children.isEmpty()) {
            ResourceBundle msg = runner.getErrorBundle();
            String desc = msg.getString("Error.InvalidTagAttributePair.fmt.txt");
            desc = MessageFormat.format(desc, this.getHandledNodeType(), PARAM_GROUP, ATTR_TYPE, type);
            throw new InvalidContractException(desc, contract);
        }
        varName = this.getVariableNameChecked(origVarName, true, session, runner, contract);
        String varValue = session.getVariableValue(varName);
        boolean matchFound = false;
        if (TYPE_TEXT.equals(type)) {
            int pos;
            String _searchIn = varValue;
            String _searchFor = searchFor;
            if (ignoreCase) {
                _searchIn = _searchIn.toLowerCase();
                _searchFor = _searchFor.toLowerCase();
            }
            if ((pos = _searchIn.indexOf(_searchFor)) > -1) {
                matchFound = true;
                StringBuilder sb = new StringBuilder(varValue.substring(0, pos));
                sb.append(replaceWith);
                int lastPos = pos += searchFor.length();
                if (global) {
                    while ((pos = _searchIn.indexOf(_searchFor, pos)) > -1) {
                        sb.append(varValue.substring(lastPos, pos));
                        sb.append(replaceWith);
                        lastPos = pos += searchFor.length();
                    }
                }
                if (lastPos != _searchIn.length()) {
                    sb.append(varValue.substring(lastPos));
                }
                varValue = sb.toString();
            }
        } else {
            StringBuffer sb = new StringBuffer();
            try {
                Pattern p = runner.getPattern(this.getHandledNodeType(), searchFor, origSearchFor, ATTR_SEARCH_FOR, ignoreCase, contract);
                Matcher m = p.matcher(varValue);
                if (global) {
                    while (m.find()) {
                        this.handleMatchFound(runner, session, m, regexCapturedGroups, contract);
                        m.appendReplacement(sb, replaceWith);
                        matchFound = true;
                    }
                    m.appendTail(sb);
                } else if (m.find()) {
                    this.handleMatchFound(runner, session, m, regexCapturedGroups, contract);
                    m.appendReplacement(sb, replaceWith);
                    m.appendTail(sb);
                    matchFound = true;
                }
            }
            catch (InvalidContractException ice) {
                throw ice;
            }
            catch (Exception e) {
                ResourceBundle msg = this.getErrorBundle();
                String desc = msg.getString("Error.ApplyingRegEx.fmt.txt");
                String text = e.getMessage();
                if (text == null) {
                    text = e.toString();
                }
                desc = MessageFormat.format(desc, this.getHandledNodeType(), text);
                throw new InvalidContractException(desc, contract, e);
            }
            varValue = sb.toString();
        }
        if (matchFound) {
            session.setVariableValue(varName, varValue);
        }
        if (resVar != null) {
            session.setVariableValue(resVar, "" + matchFound);
        }
        DefaultNodeHandlerResults res = new DefaultNodeHandlerResults();
        return res;
    }
}

