/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.parser.AbstractActionNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom2.Element;

public class VarMatchNodeHandler
extends AbstractActionNodeHandler {
    public static final String HANDLED_NODE_TYPE = "varMatch";
    private static final String ATTR_GROUP_INDEX = "group";
    private static final String ATTR_GROUP_VARIABLE = "variable";
    private static final String ATTR_IGNORE_CASE = "ignoreCase";
    private static final String ATTR_PATTERN = "pattern";
    private static final String ATTR_RESULT = "result";
    private static final String ATTR_VARIABLE = "variable";
    private static final String PARAM_GROUP = "captureGroup";
    private static final String MSG = "com.sas.dpro.contract.parser.VarMatchNodeHandler";

    public VarMatchNodeHandler() {
        this(HANDLED_NODE_TYPE);
    }

    protected VarMatchNodeHandler(String handledNodeType) {
        super(handledNodeType);
    }

    protected ResourceBundle getErrorBundle() {
        return ResourceBundle.getBundle(MSG);
    }

    protected void handleMatchFound(ContractRunner runner, ContractSession session, Matcher m, Map groups, File contract) throws InvalidContractException {
        for (Map.Entry entry : groups.entrySet()) {
            String key = (String)entry.getKey();
            int index = 0;
            try {
                index = Integer.parseInt(key);
            }
            catch (NumberFormatException nfe) {
                ResourceBundle msg = runner.getErrorBundle();
                String desc = msg.getString("Error.InvalidInteger.fmt.txt");
                desc = MessageFormat.format(desc, this.getHandledNodeType(), key);
                throw new InvalidContractException(desc, contract);
            }
            String varName = (String)entry.getValue();
            if (index <= m.groupCount()) {
                session.setVariableValue(varName, m.group(index));
                continue;
            }
            session.setVariableValue(varName, null);
        }
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        String origPattern = node.getAttributeValue(ATTR_PATTERN);
        String pattern = session.replaceVariables(origPattern);
        String resVar = node.getAttributeValue(ATTR_RESULT);
        resVar = session.replaceVariables(resVar);
        String origVarName = node.getAttributeValue("variable");
        String strIgnoreCase = node.getAttributeValue(ATTR_IGNORE_CASE);
        strIgnoreCase = session.replaceVariables(strIgnoreCase);
        boolean ignoreCase = runner.ensureBoolean(strIgnoreCase, this.getHandledNodeType(), ATTR_IGNORE_CASE, node.getAttributeValue(ATTR_IGNORE_CASE));
        HashMap<String, String> groups = new HashMap<String, String>();
        List children = node.getChildren(PARAM_GROUP);
        for (Element elem : children) {
            String strIndex = elem.getAttributeValue(ATTR_GROUP_INDEX);
            strIndex = session.replaceVariables(strIndex);
            String var = elem.getAttributeValue("variable");
            var = session.replaceVariables(var);
            groups.put(strIndex, var);
        }
        boolean matchFound = false;
        try {
            String varName = this.getVariableNameChecked(origVarName, true, session, runner, contract);
            String varValue = session.getVariableValue(varName);
            Pattern p = runner.getPattern(this.getHandledNodeType(), pattern, origPattern, ATTR_PATTERN, ignoreCase, contract);
            Matcher m = p.matcher(varValue);
            matchFound = m.find();
            if (matchFound) {
                this.handleMatchFound(runner, session, m, groups, contract);
            }
        }
        catch (Exception e) {
            ResourceBundle msg = this.getErrorBundle();
            String desc = msg.getString("Error.ApplyingRegEx.fmt.txt");
            String text = e.getMessage();
            if (text == null) {
                text = e.toString();
            }
            desc = MessageFormat.format(desc, this.getHandledNodeType(), text);
            throw new InvalidContractException(desc, contract);
        }
        if (resVar != null) {
            session.setVariableValue(resVar, "" + matchFound);
        }
        DefaultNodeHandlerResults res = new DefaultNodeHandlerResults();
        return res;
    }
}

