/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.parser.AbstractActionNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.regex.Pattern;
import org.jdom2.Element;

public class VarIterNodeHandler
extends AbstractActionNodeHandler {
    public static final String HANDLED_NODE_TYPE = "varIter";
    private static final String ATTR_INCLUDE_READ_ONLY = "includeReadOnlyVars";
    private static final String ATTR_MATCHING_REGEX = "matchingRegex";
    private static final String ATTR_MATCHING_REGEX_IGNORE_CASE = "matchingRegexIgnoreCase";
    private static final String ATTR_VARIABLE = "variable";

    public VarIterNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    protected NodeHandlerResults createNodeHandlerResults(String var, String[] varNames) {
        return new VarIterNodeHandlerResults(var, varNames);
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        String orig = node.getAttributeValue(ATTR_VARIABLE);
        String var = this.getVariableNameChecked(orig, false, session, runner, contract);
        boolean includeReadOnly = false;
        orig = node.getAttributeValue(ATTR_INCLUDE_READ_ONLY);
        if (orig != null) {
            String value = session.replaceVariables(orig);
            includeReadOnly = runner.ensureBoolean(value, this.getHandledNodeType(), ATTR_INCLUDE_READ_ONLY, orig);
        }
        Pattern p = null;
        orig = node.getAttributeValue(ATTR_MATCHING_REGEX);
        if (orig != null) {
            String regex = session.replaceVariables(orig);
            boolean ignoreCase = false;
            orig = node.getAttributeValue(ATTR_MATCHING_REGEX_IGNORE_CASE);
            if (orig != null) {
                String value = session.replaceVariables(orig);
                ignoreCase = runner.ensureBoolean(value, this.getHandledNodeType(), ATTR_MATCHING_REGEX_IGNORE_CASE, orig);
            }
            p = runner.getPattern(this.getHandledNodeType(), regex, orig, ATTR_MATCHING_REGEX, ignoreCase, contract);
        }
        String[] vars = session.getVariableNames(includeReadOnly, p);
        NodeHandlerResults res = this.createNodeHandlerResults(var, vars);
        return res;
    }

    static class VarIterNodeHandlerResults
    extends DefaultNodeHandlerResults {
        String var;
        String[] varNames;

        public VarIterNodeHandlerResults(String var, String[] varNames) {
            this.var = var;
            this.varNames = varNames;
        }

        @Override
        public boolean getShouldParseChildren(ContractSession s, int iter) throws InvalidContractException {
            boolean shouldParse = false;
            if (--iter < this.varNames.length) {
                String value = this.varNames[iter];
                s.setVariableValue(this.var, value);
                shouldParse = true;
            }
            return shouldParse;
        }
    }
}

