/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.parser.AbstractActionNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.jdom2.Element;

public class VarCopyNodeHandler
extends AbstractActionNodeHandler {
    public static final String HANDLED_NODE_TYPE = "varCopy";
    private static final String ATTR_FAIL_IF_NULL = "failIfNull";
    private static final String ATTR_FROM_VAR = "fromVar";
    private static final String ATTR_TO_VAR = "toVar";
    private static final boolean DEFAULT_FAIL_IF_NULL = false;
    private static final String ERROR_MSG = "com.sas.dpro.contract.parser.VarCopyNodeHandler";
    private static ResourceBundle errorMsg;

    public VarCopyNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    private static synchronized ResourceBundle getErrorBundle() {
        if (errorMsg == null) {
            errorMsg = ResourceBundle.getBundle(ERROR_MSG);
        }
        return errorMsg;
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        String origFromVar = node.getAttributeValue(ATTR_FROM_VAR);
        String fromVar = this.getVariableNameChecked(origFromVar, false, session, runner, contract);
        String fromValue = session.getVariableValue(fromVar);
        boolean failIfNull = false;
        String orig = node.getAttributeValue(ATTR_FAIL_IF_NULL);
        if (orig != null) {
            String temp = session.replaceVariables(orig);
            failIfNull = runner.ensureBoolean(temp, this.getHandledNodeType(), ATTR_FAIL_IF_NULL, orig);
        }
        if (failIfNull && fromValue == null) {
            ResourceBundle msg = VarCopyNodeHandler.getErrorBundle();
            String desc = msg.getString("Error.NullFromValue.fmt.txt");
            desc = MessageFormat.format(desc, this.getHandledNodeType(), fromVar, origFromVar);
            throw new InvalidContractException(desc, contract);
        }
        orig = node.getAttributeValue(ATTR_TO_VAR);
        String toVar = this.getVariableNameChecked(orig, false, session, runner, contract);
        session.setVariableValue(toVar, fromValue);
        return new DefaultNodeHandlerResults();
    }
}

