/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.FileListImpl;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.SerializableMap;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultInternalServiceNodeHandler;
import com.sas.dpro.controller.ContractSession;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jdom2.Element;

public class UpdateNodeHandler
extends DefaultInternalServiceNodeHandler {
    private static final String PARAM_CONTRACT = "contract";
    private static final String PARAM_UPDATES = "updates";
    private static final String PARAM_ZIP_FILE = "zipFile";

    public UpdateNodeHandler() {
        super("Update");
    }

    @Override
    protected void handleChildNodes(List childNodeList, ContractRunner runner, ContractSession session, File contract, SerializableMap params) throws IOException, InvalidContractException {
        ContainerContext cc = this.getContainer(session, this.getHandledNodeType(), params);
        FileListImpl updatesFilesFS = new FileListImpl(cc.getDirectory(), cc.getProviderName(), "_updatesTemp");
        boolean doUpdates = false;
        boolean clean = true;
        for (Element child : childNodeList) {
            if (!PARAM_UPDATES.equals(child.getName())) continue;
            doUpdates = true;
            String orig = child.getAttributeValue("clean");
            if (orig != null) {
                String cleanStr = session.replaceVariables(orig);
                clean = runner.ensureBoolean(cleanStr, this.getHandledNodeType(), "clean", orig);
            }
            for (Element grandKid : child.getChildren()) {
                String grandKidName = grandKid.getName();
                if (PARAM_ZIP_FILE.equals(grandKidName)) {
                    String zipFile = grandKid.getText();
                    zipFile = session.replaceVariables(zipFile);
                    updatesFilesFS.add(zipFile);
                    continue;
                }
                if (!PARAM_CONTRACT.equals(grandKidName)) continue;
                String contractName = grandKid.getText();
                contractName = session.replaceVariables(contractName);
                updatesFilesFS.add(contractName);
            }
        }
        params.put("doUpdates", "" + doUpdates);
        if (doUpdates) {
            params.put("clean", "" + clean);
            params.put("_updateFiles", updatesFilesFS);
        }
    }
}

