/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.ContractSyntaxException;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.contract.parser.TokenizeNodeHandler;
import com.sas.dpro.controller.ContractSession;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.jdom2.Element;

public class TokenIterNodeHandler
extends TokenizeNodeHandler {
    public static final String HANDLED_NODE_TYPE = "tokenIter";
    private static final String ATTR_INDEX_VAR = "indexVar";
    private static final String ATTR_VARIABLE = "variable";

    public TokenIterNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    protected NodeHandlerResults createNodeHandlerResults(String variable, String indexVar, String[] tokens) {
        return new TokenIterNodeHandlerResults(variable, indexVar, tokens);
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        String variable = node.getAttributeValue(ATTR_VARIABLE);
        variable = session.replaceVariables(variable);
        String orig = node.getAttributeValue("toSplit");
        String toSplit = session.replaceVariables(orig);
        String countVar = null;
        orig = node.getAttributeValue("countVar");
        if (orig != null) {
            countVar = this.getVariableNameChecked(orig, false, session, runner, contract);
        }
        String indexVar = null;
        orig = node.getAttributeValue(ATTR_INDEX_VAR);
        if (orig != null) {
            indexVar = this.getVariableNameChecked(orig, false, session, runner, contract);
        }
        String type = "text";
        orig = node.getAttributeValue("delimType");
        if (orig != null && !TokenIterNodeHandler.isValidDelimType(type = session.replaceVariables(orig))) {
            ResourceBundle msg = runner.getErrorBundle();
            String desc = msg.getString("Error.InvalidAttribute.fmt.txt");
            desc = MessageFormat.format(desc, this.getHandledNodeType(), "delimType", type, orig);
            throw new ContractSyntaxException(desc, contract);
        }
        String origDelim = node.getAttributeValue("delimiter");
        String delim = session.replaceVariables(origDelim);
        boolean ignoreCase = false;
        orig = node.getAttributeValue("ignoreCase");
        if (orig != null) {
            String value = session.replaceVariables(orig);
            ignoreCase = runner.ensureBoolean(value, this.getHandledNodeType(), "ignoreCase", orig);
        }
        String[] tokens = null;
        if ("regex".equals(type)) {
            Pattern p = runner.getPattern(this.getHandledNodeType(), delim, origDelim, "delimiter", ignoreCase, contract);
            tokens = p.split(toSplit);
        } else if ("text".equals(type)) {
            String quoteDelim = Pattern.quote(delim);
            Pattern p = runner.getPattern(this.getHandledNodeType(), quoteDelim, origDelim, "delimiter", ignoreCase, contract);
            tokens = p.split(toSplit);
        }
        if (countVar != null) {
            int count = tokens == null ? 0 : tokens.length;
            session.setVariableValue(countVar, "" + count);
        }
        NodeHandlerResults res = this.createNodeHandlerResults(variable, indexVar, tokens);
        return res;
    }

    static class TokenIterNodeHandlerResults
    extends DefaultNodeHandlerResults {
        private String variable;
        private String indexVar;
        private String[] tokens;

        public TokenIterNodeHandlerResults(String variable, String indexVar, String[] tokens) {
            this.variable = variable;
            this.indexVar = indexVar;
            this.tokens = tokens;
        }

        @Override
        public boolean getShouldParseChildren(ContractSession s, int iter) throws InvalidContractException {
            int count;
            boolean shouldParse = false;
            int n = count = this.tokens == null ? 0 : this.tokens.length;
            if (--iter < count) {
                s.setVariableValue(this.variable, this.tokens[iter]);
                if (this.indexVar != null) {
                    s.setVariableValue(this.indexVar, "" + iter);
                }
                shouldParse = true;
            }
            return shouldParse;
        }
    }
}

