/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.messages.ResultsMessageImpl;
import com.sas.dpro.contract.parser.AbstractResultsActionNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import com.sas.dpro.controller.HonorContractContext;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import org.jdom2.Element;
import org.jdom2.output.XMLOutputter;

public class StartResultsNodeHandler
extends AbstractResultsActionNodeHandler {
    public static final String HANDLED_NODE_TYPE = "startResults";
    private static final String ATTR_REPORT_INFO_DATA = "data";
    private static final String ATTR_TYPE = "type";
    private static final String ELEM_REPORT_INFO = "reportInfo";
    private static final String ELEM_REPORT_INFO_FIELD = "field";

    public StartResultsNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        String orig = node.getAttributeValue("id");
        String id = session.replaceVariables(orig);
        orig = node.getAttributeValue(ATTR_TYPE);
        String type = session.replaceVariables(orig);
        StringBuilder paramXML = new StringBuilder("<params>\n");
        StringBuilder reportInfoXML = new StringBuilder("<reportInfo>\n");
        XMLOutputter outputter = new XMLOutputter();
        for (Element child : node.getChildren()) {
            String str;
            String value;
            String paramName;
            String eName;
            String childName = child.getName();
            if ("params".equals(childName)) {
                for (Element e : child.getChildren()) {
                    eName = e.getName();
                    if (!"param".equals(eName)) continue;
                    orig = e.getAttributeValue("name");
                    paramName = session.replaceVariables(orig);
                    e.setAttribute("name", paramName);
                    orig = e.getText();
                    value = session.replaceVariables(orig);
                    e.setText(value);
                    str = outputter.outputString(e);
                    paramXML.append('\t').append(str).append('\n');
                }
                continue;
            }
            if (!ELEM_REPORT_INFO.equals(childName)) continue;
            for (Element e : child.getChildren()) {
                eName = e.getName();
                if (!ELEM_REPORT_INFO_FIELD.equals(eName)) continue;
                orig = e.getAttributeValue(ATTR_REPORT_INFO_DATA);
                paramName = session.replaceVariables(orig);
                e.setAttribute(ATTR_REPORT_INFO_DATA, paramName);
                orig = e.getText();
                value = session.replaceVariables(orig);
                e.setText(value);
                str = outputter.outputString(e);
                reportInfoXML.append('\t').append(str).append('\n');
            }
        }
        reportInfoXML.append("</reportInfo>\n\n");
        paramXML.append("</params>").append("\n\n");
        HonorContractContext hcc = session.getHonorContractContext();
        ResultsMessageImpl rm = new ResultsMessageImpl(hcc, 0);
        rm.setResultID(id);
        rm.setResultsType(type);
        rm.setResultXML(reportInfoXML.append((CharSequence)paramXML).toString());
        session.getMessageQueue().enqueue(rm);
        DefaultNodeHandlerResults results = new DefaultNodeHandlerResults();
        return results;
    }
}

