/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.ContractSyntaxException;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.InvalidProviderNameException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.common.ProviderNotAvailableException;
import com.sas.dpro.contract.parser.AbstractActionNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.GetContainerInfoNodeHandler;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import com.sas.dpro.provider.CreateContainerContextParmsImpl;
import com.sas.dpro.provider.Provider;
import com.sas.dpro.provider.ProviderFactory;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import org.jdom2.Element;

public class OpenContainerNodeHandler
extends AbstractActionNodeHandler {
    public static final String HANDLED_NODE_TYPE = "openContainer";
    private static final String ATTR_DIR_CREATED_VAR = "dirCreatedVar";
    private static final String ATTR_LIFESPAN = "lifeSpan";
    private static final String MSG = "com.sas.dpro.contract.parser.OpenContainerNodeHandler";

    public OpenContainerNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    protected ContainerContext createContainerContext(Element node, ContractRunner runner, ContractSession session, File contract) throws RemoteException, ContractSyntaxException, InvalidContractException {
        String lifespanStr;
        String provider = session.replaceVariables(node.getAttributeValue("server"));
        if (provider == null) {
            provider = "server-local";
        }
        String contractID = session.replaceVariables(node.getAttributeValue("id"));
        boolean isRootDir = false;
        int lifespan = 1;
        String dir = node.getAttributeValue("dir");
        if (dir != null) {
            dir = session.replaceVariables(dir);
            lifespan = 0;
            if (node.getAttributeValue("root") != null) {
                ResourceBundle msg = runner.getErrorBundle();
                String desc = msg.getString("Error.CannotSpecifyBoth.fmt.txt");
                desc = MessageFormat.format(desc, "dir", "root", this.getHandledNodeType());
                throw new InvalidContractException(desc, contract);
            }
        } else {
            dir = node.getAttributeValue("root");
            if (dir != null) {
                dir = session.replaceVariables(dir);
                isRootDir = true;
            }
        }
        if ((lifespanStr = node.getAttributeValue(ATTR_LIFESPAN)) != null) {
            if (!isRootDir) {
                ResourceBundle msg = ResourceBundle.getBundle(MSG);
                String desc = msg.getString("Error.CannotSpecifyLifespan.fmt.txt");
                desc = MessageFormat.format(desc, contractID);
                throw new InvalidContractException(desc, contract);
            }
            if ("permanent".equals(lifespanStr = session.replaceVariables(lifespanStr))) {
                lifespan = 0;
            } else if ("temporary-contract".equals(lifespanStr)) {
                lifespan = 1;
            } else if ("temporary-controller".equals(lifespanStr)) {
                lifespan = 2;
            } else {
                ResourceBundle msg = ResourceBundle.getBundle(MSG);
                String desc = msg.getString("Error.InvalidLifespan.fmt.txt");
                desc = MessageFormat.format(desc, lifespanStr, node.getAttributeValue(ATTR_LIFESPAN), contractID);
                throw new InvalidContractException(desc, contract);
            }
        }
        if (contractID.length() == 0 || contractID.startsWith("_")) {
            ResourceBundle msg = ResourceBundle.getBundle(MSG);
            String desc = msg.getString("Error.InvalidContainerID.txt");
            desc = MessageFormat.format(desc, contractID);
            throw new InvalidContractException(desc, contract);
        }
        Provider p = null;
        try {
            p = ProviderFactory.getProvider(provider);
        }
        catch (ProviderNotAvailableException e) {
            ResourceBundle msg = ResourceBundle.getBundle(MSG);
            String desc = msg.getString("Error.Generic.fmt.txt");
            String text = e.getMessage();
            if (text == null) {
                text = e.toString();
            }
            desc = MessageFormat.format(desc, this.getHandledNodeType(), text);
            throw new ProviderNotAvailableException(e.getProviderName(), desc, contract);
        }
        catch (InvalidProviderNameException e) {
            ResourceBundle msg = ResourceBundle.getBundle(MSG);
            String desc = msg.getString("Error.Generic.fmt.txt");
            String text = e.getMessage();
            if (text == null) {
                text = e.toString();
            }
            desc = MessageFormat.format(desc, this.getHandledNodeType(), text);
            throw new InvalidProviderNameException(e.getProviderName(), desc, contract);
        }
        CreateContainerContextParmsImpl parms = new CreateContainerContextParmsImpl(runner.getClientDPROVersion());
        parms.setContractID(contractID);
        parms.setContractSessionID(session.getSessionID());
        parms.setDirectory(dir);
        parms.setLifespan(lifespan);
        parms.setIsRootDir(isRootDir);
        ContainerContext container = p.createContainerContext(parms);
        String orig = node.getAttributeValue(ATTR_DIR_CREATED_VAR);
        if (orig != null) {
            String var = this.getVariableNameChecked(orig, false, session, runner, contract);
            String value = "" + container.getWasNewlyCreated();
            session.setVariableValue(var, value);
        }
        return container;
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        ContainerContext container = this.createContainerContext(node, runner, session, contract);
        session.addContainerContext(container);
        List children = node.getChildren();
        for (Element child : children) {
            String name = child.getName();
            if (!"property".equals(name)) continue;
            String propName = child.getAttributeValue("name");
            propName = session.replaceVariables(propName);
            String orig = child.getAttributeValue("variable");
            String var = this.getVariableNameChecked(orig, false, session, runner, contract);
            String propValue = GetContainerInfoNodeHandler.getPropValue(propName, container);
            session.setVariableValue(var, propValue);
        }
        return new DefaultNodeHandlerResults();
    }
}

