/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.DirList;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.SerializableMap;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultInternalServiceNodeHandler;
import com.sas.dpro.controller.ContractSession;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.jdom2.Element;

public class MakeDirNodeHandler
extends DefaultInternalServiceNodeHandler {
    private static final String PARAM_DIR = "dir";
    private static final String PARAM_DIR_LIST_REF = "dirListRef";
    private static final String ATTR_FAIL_IF_NOTHING_TO_MAKE = "failIfNothingToMake";
    private static final String MSG = "com.sas.dpro.contract.parser";

    public MakeDirNodeHandler() {
        super("MakeDir");
    }

    @Override
    protected void handleChildNodes(List childNodeList, ContractRunner runner, ContractSession session, File contract, SerializableMap params) throws IOException, InvalidContractException {
        ArrayList<String> dirList = new ArrayList<String>(1);
        for (Element child : childNodeList) {
            String name = child.getName();
            if (PARAM_DIR.equals(name)) {
                if (!this.checkIfAttribute(child, session, contract)) continue;
                dirList.add(session.replaceVariables(child.getText()));
                continue;
            }
            if (!PARAM_DIR_LIST_REF.equals(name) || !this.checkIfAttribute(child, session, contract)) continue;
            String orig = child.getAttributeValue("refId");
            DirList dl = this.getDirListChecked(orig, session, runner, contract, true);
            for (int j = 0; j < dl.getSize(); ++j) {
                dirList.add(dl.get(j));
            }
        }
        int count = dirList.size();
        if (count == 0) {
            boolean failIfNothingToMake = true;
            String param = (String)params.get(ATTR_FAIL_IF_NOTHING_TO_MAKE);
            if (param != null) {
                failIfNothingToMake = Boolean.parseBoolean(param);
            }
            if (failIfNothingToMake) {
                ResourceBundle msg = ResourceBundle.getBundle(MSG);
                String desc = msg.getString("Error.NoInput.fmt.txt");
                desc = MessageFormat.format(desc, this.getHandledNodeType());
                throw new InvalidContractException(desc, contract);
            }
        }
        String[] dirs = new String[count];
        dirs = dirList.toArray(dirs);
        params.put(PARAM_DIR, dirs);
    }
}

