/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.messages.MailReportMessageImpl;
import com.sas.dpro.contract.parser.AbstractActionNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import com.sas.dpro.controller.HonorContractContext;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import org.jdom2.Element;

public class MailReportNodeHandler
extends AbstractActionNodeHandler {
    public static final String HANDLED_NODE_TYPE = "mailReport";
    private static final String PARAM_REPORT_ID = "reportID";
    private static final String PARAM_SUMMARY_ONLY = "summaryOnly";
    private static final String PARAM_ZIP = "zip";
    private static final String PARAM_ZIP_FILE_NAME = "zipFileName";
    private static final boolean DEFAULT_DO_ZIP = false;
    private static final boolean DEFAULT_SUMMARY_ONLY = true;

    public MailReportNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        if (!this.checkIfAttribute(node, session, contract)) {
            return new DefaultNodeHandlerResults();
        }
        String orig = node.getAttributeValue(PARAM_REPORT_ID);
        String reportID = session.replaceVariables(orig);
        HonorContractContext hcc = session.getHonorContractContext();
        MailReportMessageImpl mrm = new MailReportMessageImpl(hcc, reportID);
        boolean summaryOnly = true;
        orig = node.getAttributeValue(PARAM_SUMMARY_ONLY);
        if (orig != null) {
            String summaryOnlyStr = session.replaceVariables(orig);
            summaryOnly = Boolean.parseBoolean(summaryOnlyStr);
        }
        mrm.setSummaryOnly(summaryOnly);
        boolean doZip = false;
        orig = node.getAttributeValue(PARAM_ZIP);
        if (orig != null) {
            String doZipStr = session.replaceVariables(orig);
            doZip = Boolean.parseBoolean(doZipStr);
        }
        if (doZip) {
            String zipFileName = null;
            orig = node.getAttributeValue(PARAM_ZIP_FILE_NAME);
            if (orig != null) {
                zipFileName = session.replaceVariables(orig);
            }
            mrm.setZipReport(doZip, zipFileName);
        }
        for (Element child : node.getChildren()) {
            String childName = child.getName();
            if ("bcc".equals(childName)) {
                if (!this.checkIfAttribute(child, session, contract)) continue;
                String bcc = child.getText();
                bcc = session.replaceVariables(bcc);
                mrm.setBCC(bcc);
                continue;
            }
            if ("cc".equals(childName)) {
                if (!this.checkIfAttribute(child, session, contract)) continue;
                String cc = child.getText();
                cc = session.replaceVariables(cc);
                mrm.setCC(cc);
                continue;
            }
            if ("from".equals(childName)) {
                String from = child.getText();
                from = session.replaceVariables(from);
                mrm.setFrom(from);
                continue;
            }
            if ("subject".equals(childName)) {
                String subject = child.getText();
                subject = session.replaceVariables(subject);
                mrm.setSubject(subject);
                continue;
            }
            if (!"to".equals(childName)) continue;
            String to = child.getText();
            to = session.replaceVariables(to);
            mrm.setTo(to);
        }
        session.getMessageQueue().enqueue(mrm);
        return new DefaultNodeHandlerResults();
    }
}

