/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.FileList;
import com.sas.dpro.common.FileSet;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.SerializableMap;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultInternalServiceNodeHandler;
import com.sas.dpro.controller.ContractSession;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.jdom2.Element;

public class MailNodeHandler
extends DefaultInternalServiceNodeHandler {
    private static final String ATTR_FAIL_IF_NO_ATTACHMENTS = "failIfNoAttachments";
    private static final String ATTR_TYPE = "type";
    private static final String PARAM_ATTACH_FILE = "file";
    private static final String DEFAULT_CONTENT_MIME_TYPE = "text/plain";
    private static final String PARAM_BODY_FROM_FILE = "bodyFromFile";
    private static final String MSG = "com.sas.dpro.contract.parser.MailNodeHandler";

    public MailNodeHandler() {
        super("Mail");
    }

    private void addBodyParam(SerializableMap params, String type, String text, File contract) throws InvalidContractException {
        if (DEFAULT_CONTENT_MIME_TYPE.equals(type)) {
            params.put("body", text);
        } else if ("text/html".equals(type)) {
            params.put("bodyHtml", text);
        } else {
            ResourceBundle msg = ResourceBundle.getBundle(MSG);
            String desc = msg.getString("Error.UnknownMimeType.fmt.txt");
            desc = MessageFormat.format(desc, this.getHandledNodeType(), type);
            throw new InvalidContractException(desc, contract);
        }
    }

    private ContainerContext[] getAttachCCArray(List attachCCs) {
        if (attachCCs == null || attachCCs.size() == 0) {
            return null;
        }
        boolean allNull = true;
        for (ContainerContext cc : attachCCs) {
            if (cc == null) continue;
            allNull = false;
            break;
        }
        if (allNull) {
            return null;
        }
        ContainerContext[] ccs = new ContainerContext[attachCCs.size()];
        ccs = attachCCs.toArray(ccs);
        return ccs;
    }

    private String getMimeType(Element elem, ContractSession session) {
        String type = DEFAULT_CONTENT_MIME_TYPE;
        String orig = elem.getAttributeValue(ATTR_TYPE);
        if (orig != null) {
            type = session.replaceVariables(orig);
        }
        return type;
    }

    private int handleAttachmentsNode(Element elem, ContractSession session, ContractRunner runner, File contract, List attachments, List attachCCs, List attachmentFLs, List attachmentFSs) throws InvalidContractException {
        if (!this.checkIfAttribute(elem, session, contract)) {
            return 0;
        }
        int count = 0;
        for (Element e : elem.getChildren()) {
            String orig;
            String name = e.getName();
            if (PARAM_ATTACH_FILE.equals(name)) {
                if (!this.checkIfAttribute(e, session, contract)) continue;
                orig = e.getText();
                String fileName = session.replaceVariables(orig);
                ContainerContext cc = null;
                orig = e.getAttributeValue("container");
                if (orig != null) {
                    cc = this.getContainerContextChecked(orig, session, runner, contract);
                }
                attachments.add(fileName);
                attachCCs.add(cc);
                ++count;
                continue;
            }
            if ("fileListRef".equals(name)) {
                if (!this.checkIfAttribute(e, session, contract)) continue;
                orig = e.getAttributeValue("refId");
                FileList fl = this.getFileListChecked(orig, session, runner, contract, true);
                attachmentFLs.add(fl);
                count += fl.getSize();
                continue;
            }
            if (!"fileSetRef".equals(name) || !this.checkIfAttribute(e, session, contract)) continue;
            orig = e.getAttributeValue("refId");
            FileSet fs = this.getFileSetChecked(orig, session, runner, contract, true);
            attachmentFSs.add(fs);
            ++count;
        }
        return count;
    }

    @Override
    protected void handleChildNodes(List childNodeList, ContractRunner runner, ContractSession session, File contract, SerializableMap params) throws IOException, InvalidContractException {
        ArrayList attachments = null;
        ArrayList attachCCs = null;
        ArrayList attachFLs = null;
        ArrayList attachFSs = null;
        for (Element elem : childNodeList) {
            String orig;
            String name = elem.getName();
            if ("attachments".equals(name)) {
                attachments = new ArrayList(1);
                attachCCs = new ArrayList(1);
                attachFLs = new ArrayList(1);
                attachFSs = new ArrayList(1);
                int count = this.handleAttachmentsNode(elem, session, runner, contract, attachments, attachCCs, attachFLs, attachFSs);
                if (count != 0) continue;
                boolean fail = true;
                orig = elem.getAttributeValue(ATTR_FAIL_IF_NO_ATTACHMENTS);
                if (orig != null) {
                    String value = session.replaceVariables(orig);
                    fail = runner.ensureBoolean(value, "attachments", ATTR_FAIL_IF_NO_ATTACHMENTS, orig);
                }
                if (!fail) continue;
                ResourceBundle msg = ResourceBundle.getBundle(MSG);
                String desc = msg.getString("Error.NoAttachments.fmt.txt");
                desc = MessageFormat.format(desc, this.getHandledNodeType());
                throw new InvalidContractException(desc, contract);
            }
            if ("bcc".equals(name)) {
                if (!this.checkIfAttribute(elem, session, contract)) continue;
                String bcc = elem.getText();
                bcc = session.replaceVariables(bcc);
                params.put("bcc", bcc);
                continue;
            }
            if ("body".equals(name)) {
                String text = elem.getText();
                text = session.replaceVariables(text);
                String type = this.getMimeType(elem, session);
                this.addBodyParam(params, type, text, contract);
                continue;
            }
            if (PARAM_BODY_FROM_FILE.equals(name)) {
                String fileName = elem.getText();
                if (fileName == null || fileName.length() == 0) {
                    ResourceBundle msg = ResourceBundle.getBundle(MSG);
                    String desc = msg.getString("Error.EmptyFileSpecified.fmt.txt");
                    desc = MessageFormat.format(desc, this.getHandledNodeType(), name);
                    throw new InvalidContractException(desc, contract);
                }
                fileName = session.replaceVariables(fileName);
                ContainerContext cc = session.getDefaultContainer();
                orig = elem.getAttributeValue("container");
                if (orig != null) {
                    cc = this.getContainerContextChecked(orig, session, runner, contract);
                }
                String charset = null;
                orig = elem.getAttributeValue("characterSet");
                charset = orig != null ? session.replaceVariables(orig) : Charset.defaultCharset().name();
                InputStream in = DProUtil.getFileContents(cc, fileName);
                BufferedReader r = new BufferedReader(new InputStreamReader(in, charset));
                StringBuilder sb = new StringBuilder();
                String line = null;
                while ((line = r.readLine()) != null) {
                    sb.append(line).append('\n');
                }
                r.close();
                String type = this.getMimeType(elem, session);
                this.addBodyParam(params, type, sb.toString(), contract);
                continue;
            }
            if ("cc".equals(name)) {
                if (!this.checkIfAttribute(elem, session, contract)) continue;
                String cc = elem.getText();
                cc = session.replaceVariables(cc);
                params.put("cc", cc);
                continue;
            }
            if ("from".equals(name)) {
                String from = elem.getText();
                from = session.replaceVariables(from);
                params.put("from", from);
                continue;
            }
            if ("smtpServer".equals(name)) {
                String smtpServer = elem.getText();
                smtpServer = session.replaceVariables(smtpServer);
                params.put("smtpServer", smtpServer);
                continue;
            }
            if ("subject".equals(name)) {
                String subject = elem.getText();
                subject = session.replaceVariables(subject);
                params.put("subject", subject);
                continue;
            }
            if (!"to".equals(name)) continue;
            String to = elem.getText();
            to = session.replaceVariables(to);
            params.put("to", to);
        }
        if (attachments != null && attachments.size() > 0) {
            String[] files = new String[attachments.size()];
            files = attachments.toArray(files);
            params.put("attachments", files);
            ContainerContext[] ccs = this.getAttachCCArray(attachCCs);
            if (ccs != null) {
                params.put("_attachmentsContainers", ccs);
            }
        }
        if (attachFLs != null && attachFLs.size() > 0) {
            FileList[] fls = new FileList[attachFLs.size()];
            fls = attachFLs.toArray(fls);
            params.put("_fileListAttachments", fls);
        }
        if (attachFSs != null && attachFSs.size() > 0) {
            FileSet[] fss = new FileSet[attachFSs.size()];
            fss = attachFSs.toArray(fss);
            params.put("_fileSetAttachments", fss);
        }
    }
}

