/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.MacroImpl;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.parser.AbstractContractNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.rmi.RemoteException;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class MacroNodeHandler
extends AbstractContractNodeHandler {
    public static final String HANDLED_NODE_TYPE = "macro";
    private static final String ATTR_ID = "id";

    public MacroNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        String orig = node.getAttributeValue(ATTR_ID);
        String name = session.replaceVariables(orig);
        Format format = Format.getRawFormat();
        format.setOmitDeclaration(true);
        format.setOmitEncoding(true);
        XMLOutputter out = new XMLOutputter(format);
        StringWriter w = new StringWriter();
        out.output(node, (Writer)w);
        String xml = w.toString();
        w.close();
        MacroImpl macro = new MacroImpl(name);
        macro.setMacro(xml, runner.getClientDPROVersion());
        session.addMacro(macro);
        return new DefaultNodeHandlerResults();
    }
}

