/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.parser.AbstractActionNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.rmi.RemoteException;
import org.jdom2.Element;

public class LoadFileLinesNodeHandler
extends AbstractActionNodeHandler {
    public static final String HANDLED_NODE_TYPE = "loadFileLines";
    private static final String ATTR_COUNT_VAR = "countVar";
    private static final String ATTR_SKIP_EMPTY_LINES = "skipEmptyLines";
    private static final String ATTR_SKIP_PREFIX = "skipPrefix";
    private static final String ATTR_VAR_PREFIX = "varPrefix";
    private static final String ATTR_SKIP_WS_ONLY_LINES = "skipWhitespaceOnlyLines";
    private static final String ELEM_FILE = "file";

    public LoadFileLinesNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        DefaultNodeHandlerResults results = new DefaultNodeHandlerResults();
        if (!this.checkIfAttribute(node, session, contract)) {
            return results;
        }
        String orig = node.getAttributeValue(ATTR_VAR_PREFIX);
        String prefix = session.replaceVariables(orig);
        String countVar = null;
        orig = node.getAttributeValue(ATTR_COUNT_VAR);
        if (orig != null) {
            countVar = this.getVariableNameChecked(orig, false, session, runner, contract);
        }
        boolean skipWhitespaceOnlyLines = false;
        orig = node.getAttributeValue(ATTR_SKIP_WS_ONLY_LINES);
        if (orig != null) {
            String value = session.replaceVariables(orig);
            skipWhitespaceOnlyLines = runner.ensureBoolean(value, this.getHandledNodeType(), ATTR_SKIP_WS_ONLY_LINES, orig);
        }
        boolean skipEmptyLines = false;
        orig = node.getAttributeValue(ATTR_SKIP_EMPTY_LINES);
        if (orig != null) {
            String value = session.replaceVariables(orig);
            skipEmptyLines = runner.ensureBoolean(value, this.getHandledNodeType(), ATTR_SKIP_EMPTY_LINES, orig);
        }
        String skipPrefix = null;
        orig = node.getAttributeValue(ATTR_SKIP_PREFIX);
        if (orig != null) {
            skipPrefix = session.replaceVariables(orig);
        }
        ContainerContext cc = null;
        Charset cs = null;
        String fileName = null;
        for (Element child : node.getChildren()) {
            String childName = child.getName();
            if (!ELEM_FILE.equals(childName)) continue;
            cc = session.getDefaultContainer();
            orig = child.getAttributeValue("container");
            if (orig != null) {
                cc = this.getContainerContextChecked(orig, session, runner, contract);
            }
            orig = child.getAttributeValue("characterSet");
            cs = this.getCharsetChecked(orig, session, runner, contract);
            orig = child.getText();
            fileName = session.replaceVariables(orig);
        }
        InputStream in = DProUtil.getFileContents(cc, fileName);
        int count = 0;
        try (BufferedReader r = new BufferedReader(new InputStreamReader(in, cs));){
            String line = null;
            while ((line = r.readLine()) != null) {
                if (skipWhitespaceOnlyLines && line.trim().length() == 0 || skipEmptyLines && line.length() == 0 || skipPrefix != null && line.startsWith(skipPrefix)) continue;
                String varName = prefix + count;
                session.setVariableValue(varName, line);
                ++count;
            }
        }
        if (countVar != null) {
            session.setVariableValue(countVar, "" + count);
        }
        return results;
    }
}

