/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.messages.InfoMessageImpl;
import com.sas.dpro.contract.parser.AbstractActionNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.jdom2.Element;

public class InfoNodeHandler
extends AbstractActionNodeHandler {
    public static final String HANDLED_NODE_TYPE = "info";
    private static final String ATTR_LOGGING_LEVEL = "loggingLevel";
    private static final String ATTR_TEXT = "text";

    public InfoNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        String text = node.getAttributeValue(ATTR_TEXT);
        text = session.replaceVariables(text);
        String orig = node.getAttributeValue(ATTR_LOGGING_LEVEL);
        String levelStr = session.replaceVariables(orig);
        int loggingLevel = -1;
        if (levelStr != null) {
            try {
                loggingLevel = Integer.parseInt(levelStr);
            }
            catch (NumberFormatException nfe) {
                ResourceBundle msg = runner.getErrorBundle();
                String desc = msg.getString("Error.InvalidInteger.fmt.txt");
                desc = MessageFormat.format(desc, this.getHandledNodeType(), levelStr);
                throw new InvalidContractException(desc, contract);
            }
        }
        InfoMessageImpl im = new InfoMessageImpl(session.getHonorContractContext(), text);
        im.setLoggingLevel(loggingLevel);
        session.getMessageQueue().enqueue(im);
        DefaultNodeHandlerResults res = new DefaultNodeHandlerResults();
        return res;
    }
}

