/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.parser.AbstractActionNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.ExpressionParser;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import org.jdom2.Element;

public class IfNodeHandler
extends AbstractActionNodeHandler {
    public static final String HANDLED_NODE_TYPE = "if";
    private static final String ATTR_TEST = "test";
    static final String EVALUATED_VALUE = "_evaluatedValue";

    public IfNodeHandler() {
        this(HANDLED_NODE_TYPE);
    }

    protected IfNodeHandler(String handledNodeType) {
        super(handledNodeType);
    }

    protected NodeHandlerResults createNodeHandlerResults(Element node, boolean evaluatedValue) {
        DefaultNodeHandlerResults results = null;
        if (node.getChild("then") != null || node.getChild("else") != null) {
            String valString = Boolean.toString(evaluatedValue);
            node.setAttribute(EVALUATED_VALUE, valString);
            results = new IfNodeHandlerResults_16();
        } else {
            results = new IfNodeHandlerResults_15(evaluatedValue);
        }
        return results;
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        String test = node.getAttributeValue(ATTR_TEST);
        boolean value = ExpressionParser.getInstance().parseBooleanExpression(test, this.getHandledNodeType(), session);
        NodeHandlerResults res = this.createNodeHandlerResults(node, value);
        return res;
    }

    static class IfNodeHandlerResults_16
    extends DefaultNodeHandlerResults {
        IfNodeHandlerResults_16() {
        }

        @Override
        public boolean getCouldParseChildren(ContractSession session) {
            return true;
        }

        @Override
        public boolean getShouldParseChildren(ContractSession s, int iter) throws InvalidContractException {
            return iter == 1;
        }
    }

    static class IfNodeHandlerResults_15
    extends DefaultNodeHandlerResults {
        protected boolean evaluatedValue;

        public IfNodeHandlerResults_15(boolean evaluatedValue) {
            this.evaluatedValue = evaluatedValue;
        }

        @Override
        public boolean getCouldParseChildren(ContractSession session) {
            return true;
        }

        @Override
        public boolean getShouldParseChildren(ContractSession s, int iter) throws InvalidContractException {
            return iter == 1 && this.evaluatedValue;
        }
    }
}

