/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.common.ProviderNotAvailableException;
import com.sas.dpro.contract.parser.AbstractActionNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import com.sas.dpro.provider.Provider;
import com.sas.dpro.provider.ProviderFactory;
import com.sas.dpro.service.ServiceInfo;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import org.jdom2.Element;

public class GetServiceInfoNodeHandler
extends AbstractActionNodeHandler {
    public static final String HANDLED_NODE_TYPE = "getServiceInfo";
    public static final String SERVER_UNAVAILABLE = "ServerUnavailable";
    public static final String SERVICE_UNAVAILABLE = "ServiceUnavailable";
    public static final String UNKNOWN_PROPERTY = "UnknownProperty";
    public static final String PROPERTY_COMMAND = "command";
    public static final String PROPERTY_DEFAULT_TIMEOUT = "defaultTimeout";
    public static final String PROPERTY_DESCRIPTION = "description";
    public static final String PROPERTY_HOST = "host";
    public static final String PROPERTY_INTERNAL_SERVICE = "internalService";
    public static final String PROPERTY_KEYWORDS = "keywords";
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_SERVER_AVAILABLE = "serverAvailable";
    public static final String PROPERTY_SERVICE_AVAILABLE = "available";
    private static final String PARAM_PROPERTY = "property";
    private static final String ATTR_FAIL_IF_NO_SUCH_SERVICE = "failIfNoSuchService";
    private static final String ATTR_FAIL_IF_UNAVAILABLE = "failIfServerUnavailable";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_SERVER = "server";
    private static final String ATTR_VARIABLE = "variable";
    private static final String ATTR_SERVICE = "service";

    public GetServiceInfoNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        Provider p;
        String server;
        boolean failIfNoSuchService;
        block30: {
            boolean failIfUnavailable = false;
            String orig = node.getAttributeValue(ATTR_FAIL_IF_UNAVAILABLE);
            if (orig != null) {
                String failStr = session.replaceVariables(orig);
                failIfUnavailable = runner.ensureBoolean(failStr, this.getHandledNodeType(), ATTR_FAIL_IF_UNAVAILABLE, orig);
            }
            failIfNoSuchService = false;
            orig = node.getAttributeValue(ATTR_FAIL_IF_NO_SUCH_SERVICE);
            if (orig != null) {
                String failStr = session.replaceVariables(orig);
                failIfNoSuchService = runner.ensureBoolean(failStr, this.getHandledNodeType(), ATTR_FAIL_IF_NO_SUCH_SERVICE, orig);
            }
            orig = node.getAttributeValue(ATTR_SERVER);
            server = session.replaceVariables(orig);
            p = null;
            try {
                p = ProviderFactory.getProvider(server);
            }
            catch (ProviderNotAvailableException pnae) {
                if (!failIfUnavailable) break block30;
                ResourceBundle msg = runner.getErrorBundle();
                String desc = msg.getString("Error.ServerNotAvailable.fmt.txt");
                desc = MessageFormat.format(desc, this.getHandledNodeType(), server);
                throw new InvalidContractException(desc, contract, pnae);
            }
        }
        String origService = node.getAttributeValue(ATTR_SERVICE);
        String service = session.replaceVariables(origService);
        ServiceInfo info = null;
        if (p != null) {
            info = p.getServiceInfo(service);
        }
        if (p != null && info == null && failIfNoSuchService) {
            ResourceBundle msg = runner.getErrorBundle();
            String desc = msg.getString("Error.NoSuchService.fmt.txt");
            desc = MessageFormat.format(desc, this.getHandledNodeType(), server, service, origService);
            throw new InvalidContractException(desc, contract);
        }
        List children = node.getChildren();
        for (Element child : children) {
            String name = child.getName();
            if (!PARAM_PROPERTY.equals(name)) continue;
            String propName = child.getAttributeValue("name");
            propName = session.replaceVariables(propName);
            String origVar = child.getAttributeValue(ATTR_VARIABLE);
            String var = session.replaceVariables(origVar);
            if (!DProUtil.isValidVariableName(var)) {
                ResourceBundle msg = runner.getErrorBundle();
                String desc = msg.getString("Error.InvalidVarName.fmt.txt");
                desc = MessageFormat.format(desc, this.getHandledNodeType(), origVar, var);
                throw new InvalidContractException(desc, contract);
            }
            String propValue = UNKNOWN_PROPERTY;
            if (PROPERTY_SERVER_AVAILABLE.equals(propName)) {
                propValue = "" + (p != null);
            } else if (PROPERTY_SERVICE_AVAILABLE.equals(propName)) {
                propValue = "" + (info != null);
            } else if (p == null) {
                propValue = SERVER_UNAVAILABLE;
            } else if (info == null) {
                propValue = SERVICE_UNAVAILABLE;
            } else if (PROPERTY_COMMAND.equals(propName)) {
                propValue = info.getCommand();
            } else if (PROPERTY_DEFAULT_TIMEOUT.equals(propName)) {
                propValue = "" + info.getDefaultTimeout();
            } else if (PROPERTY_DESCRIPTION.equals(propName)) {
                propValue = "" + info.getDescription();
            } else if (PROPERTY_HOST.equals(propName)) {
                propValue = info.getHost();
                if (propValue == null) {
                    propValue = server;
                }
            } else if (PROPERTY_INTERNAL_SERVICE.equals(propName)) {
                propValue = "" + info.isInternalService();
            } else if (PROPERTY_KEYWORDS.equals(propName)) {
                propValue = info.getKeywords();
            } else if ("name".equals(propName)) {
                propValue = info.getName();
            }
            session.setVariableValue(var, propValue);
        }
        return new DefaultNodeHandlerResults();
    }
}

