/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.ContractSyntaxException;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.FileCollection;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.parser.AbstractActionNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.List;
import java.util.ResourceBundle;
import org.jdom2.Element;

public class GetFileCollectionInfoNodeHandler
extends AbstractActionNodeHandler {
    public static final String HANDLED_NODE_TYPE = "getFileCollectionInfo";
    public static final String TYPE_DIR_LIST = "dirList";
    public static final String TYPE_FILE_LIST = "fileList";
    public static final String PROPERTY_ABS_NAME_AT_PREFIX = "absolutePathAt_";
    public static final String PROPERTY_ITEM_AT_PREFIX = "itemAt_";
    public static final String PROPERTY_NAME_AT_PREFIX = "nameAt_";
    public static final String PROPERTY_ROOT = "root";
    public static final String PROPERTY_SERVER = "server";
    public static final String PROPERTY_SIZE = "size";
    public static final String UNKNOWN_PROPERTY = "UnknownProperty";
    private static final String ATTR_COLLECTION_ID = "id";
    private static final String ATTR_COLLECTION_TYPE = "collectionType";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_VARIABLE = "variable";
    private static final String PARAM_PROPERTY = "property";
    private static final String MSG = "com.sas.dpro.contract.parser.GetFileCollectionInfoNodeHandler";
    private static ResourceBundle errorMsg;

    public GetFileCollectionInfoNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    private static synchronized ResourceBundle getErrorBundle() {
        if (errorMsg == null) {
            errorMsg = ResourceBundle.getBundle(MSG);
        }
        return errorMsg;
    }

    private int getIndex(FileCollection fc, String intStr, String origIntStr, File contract) throws InvalidContractException {
        int index = 0;
        try {
            index = Integer.parseInt(intStr);
        }
        catch (NumberFormatException nfe) {
            ResourceBundle msg = GetFileCollectionInfoNodeHandler.getErrorBundle();
            String key = "Error.InvalidItemIndex.fmt.txt";
            String desc = DProUtil.formatString(msg, key, this.getHandledNodeType(), intStr, origIntStr);
            throw new InvalidContractException(desc, contract);
        }
        if (index < 0 || index >= fc.getSize()) {
            ResourceBundle msg = GetFileCollectionInfoNodeHandler.getErrorBundle();
            String key = "Error.InvalidItemIndex.fmt.txt";
            String desc = DProUtil.formatString(msg, key, this.getHandledNodeType(), intStr, origIntStr);
            throw new InvalidContractException(desc, contract);
        }
        return index;
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        FileCollection fc = null;
        String origType = node.getAttributeValue(ATTR_COLLECTION_TYPE);
        String type = session.replaceVariables(origType);
        String orig = node.getAttributeValue(ATTR_COLLECTION_ID);
        if (TYPE_FILE_LIST.equals(type)) {
            fc = this.getFileListChecked(orig, session, runner, contract, true);
        } else if (TYPE_DIR_LIST.equals(type)) {
            fc = this.getDirListChecked(orig, session, runner, contract, true);
        } else {
            ResourceBundle msg = GetFileCollectionInfoNodeHandler.getErrorBundle();
            String key = "Error.InvalidFCType.fmt.txt";
            String desc = DProUtil.formatString(msg, key, this.getHandledNodeType(), type, origType);
            throw new ContractSyntaxException(desc, contract);
        }
        List children = node.getChildren();
        for (Element child : children) {
            int index;
            String name = child.getName();
            if (!PARAM_PROPERTY.equals(name)) continue;
            String origPropName = child.getAttributeValue(ATTR_NAME);
            String propName = session.replaceVariables(origPropName);
            String origVar = child.getAttributeValue(ATTR_VARIABLE);
            String var = session.replaceVariables(origVar);
            if (!DProUtil.isValidVariableName(var)) {
                ResourceBundle msg = runner.getErrorBundle();
                String key = "Error.InvalidVarName.fmt.txt";
                String desc = DProUtil.formatString(msg, key, this.getHandledNodeType(), origVar, var);
                throw new InvalidContractException(desc, contract);
            }
            String propValue = UNKNOWN_PROPERTY;
            if (propName.startsWith(PROPERTY_ABS_NAME_AT_PREFIX)) {
                propName = propName.substring(PROPERTY_ABS_NAME_AT_PREFIX.length());
                index = this.getIndex(fc, propName, origPropName, contract);
                propValue = fc.getAbsolute(index);
            } else if (propName.startsWith(PROPERTY_ITEM_AT_PREFIX)) {
                propName = propName.substring(PROPERTY_ITEM_AT_PREFIX.length());
                index = this.getIndex(fc, propName, origPropName, contract);
                propValue = fc.get(index);
            } else if (propName.startsWith(PROPERTY_NAME_AT_PREFIX)) {
                propName = propName.substring(PROPERTY_NAME_AT_PREFIX.length());
                index = this.getIndex(fc, propName, origPropName, contract);
                propValue = fc.getName(index);
            } else if (PROPERTY_SERVER.equals(propName)) {
                propValue = fc.getProvider();
            } else if (PROPERTY_ROOT.equals(propName)) {
                propValue = fc.getRoot();
            } else if (PROPERTY_SIZE.equals(propName)) {
                propValue = "" + fc.getSize();
            }
            session.setVariableValue(var, propValue);
        }
        return new DefaultNodeHandlerResults();
    }
}

