/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.FilterSet;
import com.sas.dpro.common.FilterSetImpl;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.parser.AbstractContractNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.Properties;
import org.jdom2.Element;

public class FilterSetNodeHandler
extends AbstractContractNodeHandler {
    public static final String HANDLED_NODE_TYPE = "filterSet";
    private static final String ATTR_BEGIN_TOKEN = "beginToken";
    private static final String ATTR_END_TOKEN = "endToken";
    private static final String ATTR_ID = "id";
    private static final String ATTR_FILTER_TOKEN = "token";
    private static final String ATTR_FILTER_VALUE = "value";
    private static final String ATTR_RECURSE = "recurse";
    private static final String PARAM_FILTER = "filter";
    private static final String PARAM_FILTERS_FILE = "filtersFile";

    public FilterSetNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FilterSet getFilterSet(Element elem, String handledNodeType, ContractRunner runner, ContractSession session, File contract) throws IOException, InvalidContractException {
        String endToken;
        FilterSetImpl fs = new FilterSetImpl();
        String beginToken = elem.getAttributeValue(ATTR_BEGIN_TOKEN);
        if (beginToken != null) {
            beginToken = session.replaceVariables(beginToken);
            fs.setBeginToken(beginToken);
        }
        if ((endToken = elem.getAttributeValue(ATTR_END_TOKEN)) != null) {
            endToken = session.replaceVariables(endToken);
            fs.setEndToken(endToken);
        }
        boolean recurse = false;
        String orig = elem.getAttributeValue(ATTR_RECURSE);
        if (orig != null) {
            String temp = session.replaceVariables(orig);
            recurse = runner.ensureBoolean(temp, handledNodeType, ATTR_RECURSE, orig);
        }
        for (Element child : elem.getChildren()) {
            boolean doAdd;
            String name = child.getName();
            if (PARAM_FILTER.equals(name)) {
                doAdd = FilterSetNodeHandler.checkIfAttribute(child, handledNodeType, session, contract);
                if (!doAdd) continue;
                String token = child.getAttributeValue(ATTR_FILTER_TOKEN);
                token = session.replaceVariables(token);
                String value = child.getAttributeValue(ATTR_FILTER_VALUE);
                if (value == null) {
                    value = child.getText();
                }
                value = session.replaceVariables(value);
                fs.addFilter(token, value);
                continue;
            }
            if (!PARAM_FILTERS_FILE.equals(name) || !(doAdd = FilterSetNodeHandler.checkIfAttribute(child, handledNodeType, session, contract))) continue;
            ContainerContext cc = session.getDefaultContainer();
            orig = child.getAttributeValue("container");
            if (orig != null) {
                cc = FilterSetNodeHandler.getContainerContextChecked(elem.getName(), orig, session, runner, contract);
            }
            String fileName = child.getText();
            fileName = session.replaceVariables(fileName);
            InputStream in = DProUtil.getFileContents(cc, fileName);
            Properties props = new Properties();
            try (BufferedInputStream bin = new BufferedInputStream(in);){
                props.load(bin);
            }
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String token = (String)entry.getKey();
                String value = (String)entry.getValue();
                fs.addFilter(token, value);
            }
        }
        if (recurse) {
            fs.recurse();
        }
        return fs;
    }

    @Override
    public String getHandledNodeType() {
        return HANDLED_NODE_TYPE;
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        FilterSet fs = FilterSetNodeHandler.getFilterSet(node, this.getHandledNodeType(), runner, session, contract);
        String id = node.getAttributeValue(ATTR_ID);
        id = session.replaceVariables(id);
        session.addFilterSet(id, fs);
        return new DefaultNodeHandlerResults();
    }
}

