/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.ContractSyntaxException;
import com.sas.dpro.common.FileList;
import com.sas.dpro.common.FileSet;
import com.sas.dpro.common.FileSetImpl;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.Macro;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.common.PatternSetImpl;
import com.sas.dpro.common.SerializableHashMap;
import com.sas.dpro.common.SerializableMap;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.contract.parser.AbstractServiceNodeHandler;
import com.sas.dpro.contract.parser.CallMacroNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.FileSetNodeHandler;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.contract.parser.TokenizeNodeHandler;
import com.sas.dpro.controller.ContractSession;
import com.sas.dpro.provider.Provider;
import com.sas.dpro.provider.ProviderFactory;
import com.sas.dpro.provider.ServiceRequestParmsImpl;
import com.sas.dpro.service.ServiceParmsImpl;
import com.sas.dpro.service.ServiceResults;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.jdom2.Attribute;
import org.jdom2.Element;

public class ExternalServiceNodeHandler
extends AbstractServiceNodeHandler {
    public static final String HANDLED_NODE_TYPE = "Service";
    private static final String PARAM_ARG = "arg";
    private static final String PARAM_ARG_DIR_LIST = "argDirList";
    private static final String PARAM_ARG_DIR_SET = "argDirSet";
    private static final String PARAM_ARG_FILE_LIST = "argFileList";
    private static final String PARAM_ARG_FILE_PATH = "argFilePath";
    private static final String PARAM_ARG_FILE_SET = "argFileSet";
    private static final String PARAM_ARG_TOKENIZE = "argTokenize";
    private static final String PARAM_ENV_VARS = "environmentVars";
    private static final String PARAM_ERROR_HANDLER = "errorHandler";
    private static final String PARAM_OUTPUT = "output";
    private static final String ATTR_DELIM = "delimiter";
    private static final String ATTR_ENV_VAR_APPEND = "append";
    private static final String ATTR_FILE_LIST_ID = "fileListID";
    private static final String ATTR_IGNORE_CASE = "ignoreCase";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TYPE = "delimType";
    private static final String ATTR_VALUE = "value";
    private static final boolean DEFAULT_IGNORE_CASE = false;

    public ExternalServiceNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    protected String[] handleEnvVarsNode(Element node, Provider provider, ContainerContext container, SerializableMap params, ContractRunner runner, ContractSession session, File contract) throws InvalidContractException, IOException {
        String append = "false";
        String orig = node.getAttributeValue(ATTR_ENV_VAR_APPEND);
        if (orig != null) {
            append = session.replaceVariables(orig);
            runner.ensureBoolean(append, this.getHandledNodeType(), ATTR_ENV_VAR_APPEND, orig);
        }
        params.put("_AppendEnvVars", append);
        ArrayList envVarList = new ArrayList();
        this.parseVarList(node, runner, session, contract, envVarList);
        if (envVarList.size() == 0) {
            return null;
        }
        String[] envVars = new String[envVarList.size()];
        envVars = envVarList.toArray(envVars);
        return envVars;
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, InvalidContractException, NodeHandlerException {
        String serviceName = null;
        SerializableHashMap params = new SerializableHashMap();
        ArrayList<String> argList = new ArrayList<String>();
        String stdin = null;
        String[] envVars = null;
        FileSet outputFileSet = null;
        String containerName = null;
        String captureOutputStreams = null;
        boolean failIfFailure = true;
        boolean failIfTimeout = true;
        String rcRulesStr = null;
        String rcVar = null;
        long timeout = -1L;
        Macro errorHandler = null;
        List attributes = node.getAttributes();
        for (Attribute a : attributes) {
            String name = a.getName();
            String origValue = a.getValue();
            String value = session.replaceVariables(origValue);
            if (ATTR_NAME.equals(name)) {
                serviceName = value;
                continue;
            }
            if ("captureOutputStreams".equals(name)) {
                if (!("true".equals(value) || "false".equals(value) || "combine".equals(value))) {
                    ResourceBundle msg = runner.getErrorBundle();
                    String desc = msg.getString("Error.InvalidAttribute.fmt.txt");
                    desc = MessageFormat.format(desc, this.getHandledNodeType(), name, value, origValue);
                    throw new ContractSyntaxException(desc, contract);
                }
                captureOutputStreams = value;
                continue;
            }
            if ("redirectStderr".equals(name)) {
                boolean redirectStderr = runner.ensureBoolean(value, this.getHandledNodeType(), name, origValue);
                params.put(name, "" + redirectStderr);
                continue;
            }
            if ("container".equals(name)) {
                containerName = value;
                continue;
            }
            if ("failIfFailure".equals(name)) {
                failIfFailure = runner.ensureBoolean(value, this.getHandledNodeType(), name, origValue);
                continue;
            }
            if ("failIfTimeOut".equals(name)) {
                failIfTimeout = runner.ensureBoolean(value, this.getHandledNodeType(), name, origValue);
                continue;
            }
            if ("rc".equals(name)) {
                rcRulesStr = value;
                continue;
            }
            if ("rcVar".equals(name)) {
                rcVar = this.getVariableNameChecked(origValue, false, session, runner, contract);
                continue;
            }
            if ("timeOut".equals(name)) {
                timeout = this.getTimeoutChecked(value, runner, contract);
                continue;
            }
            if (name.startsWith("_")) {
                ResourceBundle msg = runner.getErrorBundle();
                String desc = msg.getString("Error.BadAttribute.fmt.txt");
                desc = MessageFormat.format(desc, name, node.getName());
                throw new ContractSyntaxException(desc, contract);
            }
            params.put(name, value);
        }
        ContainerContext container = session.getDefaultContainer();
        if (containerName != null && (container = session.getContainerContext(containerName)) == null) {
            ResourceBundle msg = runner.getErrorBundle();
            String desc = msg.getString("Error.NoSuchContainerContext.fmt.txt");
            desc = MessageFormat.format(desc, this.getHandledNodeType(), containerName);
            throw new InvalidContractException(desc);
        }
        if (captureOutputStreams != null) {
            params.put("captureOutputStreams", captureOutputStreams);
        }
        String providerName = container.getProviderName();
        Provider provider = ProviderFactory.getProvider(providerName);
        List childNodes = node.getChildren();
        for (Element child : childNodes) {
            String value;
            String name = child.getName();
            if (PARAM_ARG.equals(name)) {
                if (!this.checkIfAttribute(child, session, contract)) continue;
                value = child.getText();
                if (value == null || value.length() == 0) {
                    value = child.getAttributeValue(ATTR_VALUE);
                    ExternalServiceNodeHandler.ensureNonNullAttr(value, runner, contract, ATTR_VALUE, PARAM_ARG);
                }
                argList.add(session.replaceVariables(value));
                continue;
            }
            if (PARAM_ARG_DIR_LIST.equals(name)) {
                this.parseAddDirListContentsNode(child, argList, session, runner, contract);
                continue;
            }
            if (PARAM_ARG_DIR_SET.equals(name)) {
                this.parseAddDirSetContentsNode(child, argList, session, runner, contract);
                continue;
            }
            if (PARAM_ARG_FILE_PATH.equals(name)) {
                if (!this.checkIfAttribute(child, session, contract)) continue;
                ContainerContext fileCont = container;
                String temp = child.getAttributeValue("container");
                if (temp != null) {
                    fileCont = this.getContainerContextChecked(temp, session, runner, contract);
                }
                String value2 = child.getText();
                value2 = session.replaceVariables(value2);
                try {
                    argList.add(fileCont.getAbsoluteFilePath(value2));
                    continue;
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new ServiceFailedException(e);
                }
            }
            if (PARAM_ARG_FILE_LIST.equals(name)) {
                this.parseAddFileListContentsNode(child, argList, session, runner, contract);
                continue;
            }
            if (PARAM_ARG_FILE_SET.equals(name)) {
                this.parseAddFileSetContentsNode(child, argList, session, runner, contract);
                continue;
            }
            if (PARAM_ARG_TOKENIZE.equals(name)) {
                if (!this.checkIfAttribute(child, session, contract)) continue;
                value = child.getText();
                if (value == null || value.length() == 0) {
                    value = child.getAttributeValue(ATTR_VALUE);
                    ExternalServiceNodeHandler.ensureNonNullAttr(value, runner, contract, ATTR_VALUE, PARAM_ARG_TOKENIZE);
                }
                value = session.replaceVariables(value);
                String type = "text";
                String orig = child.getAttributeValue(ATTR_TYPE);
                if (orig != null && !TokenizeNodeHandler.isValidDelimType(type = session.replaceVariables(orig))) {
                    ResourceBundle msg = runner.getErrorBundle();
                    String desc = msg.getString("Error.InvalidAttribute.fmt.txt");
                    desc = MessageFormat.format(desc, this.getHandledNodeType(), ATTR_TYPE, type, orig);
                    throw new ContractSyntaxException(desc, contract);
                }
                String origDelim = child.getAttributeValue(ATTR_DELIM);
                String delim = session.replaceVariables(origDelim);
                boolean ignoreCase = false;
                orig = node.getAttributeValue(ATTR_IGNORE_CASE);
                if (orig != null) {
                    String temp = session.replaceVariables(orig);
                    ignoreCase = runner.ensureBoolean(temp, this.getHandledNodeType(), ATTR_IGNORE_CASE, orig);
                }
                String[] tokens = null;
                if ("regex".equals(type)) {
                    Pattern p = runner.getPattern(this.getHandledNodeType(), delim, origDelim, ATTR_DELIM, ignoreCase, contract);
                    tokens = p.split(value);
                } else if ("text".equals(type)) {
                    String quoteDelim = Pattern.quote(delim);
                    Pattern p = runner.getPattern(this.getHandledNodeType(), quoteDelim, origDelim, ATTR_DELIM, ignoreCase, contract);
                    tokens = p.split(value);
                }
                int count = tokens == null ? 0 : tokens.length;
                for (int j = 0; j < count; ++j) {
                    if (tokens[j].length() <= 0) continue;
                    argList.add(tokens[j]);
                }
                continue;
            }
            if (PARAM_OUTPUT.equals(name)) {
                outputFileSet = this.handleOutputFilesNode(child, provider, container, runner, session, contract);
                continue;
            }
            if ("stdin".equals(name)) {
                stdin = child.getText();
                continue;
            }
            if (PARAM_ENV_VARS.equals(name)) {
                envVars = this.handleEnvVarsNode(child, provider, container, params, runner, session, contract);
                continue;
            }
            if (PARAM_ERROR_HANDLER.equals(name)) {
                String temp = child.getAttributeValue("macroID");
                ExternalServiceNodeHandler.ensureNonNullAttr(temp, runner, contract, "macroID", PARAM_ERROR_HANDLER);
                errorHandler = this.getMacroChecked(temp, session, runner, contract, true);
                continue;
            }
            ResourceBundle msg = runner.getErrorBundle();
            String desc = msg.getString("Error.UnknownAttribute.fmt.txt");
            desc = MessageFormat.format(desc, name, node.getName());
            throw new ContractSyntaxException(desc, contract);
        }
        if (argList.size() > 0) {
            String[] cmdLineArgs = new String[argList.size()];
            cmdLineArgs = argList.toArray(cmdLineArgs);
            params.put("_CommandLineArgs", cmdLineArgs);
        }
        if (stdin != null) {
            params.put("stdin", stdin);
        }
        if (envVars != null) {
            params.put("_EnvironmentVars", envVars);
        }
        if (outputFileSet != null) {
            params.put("_outputFileSet", outputFileSet);
        }
        ExternalServiceNodeHandler.ensureNonNullAttr(serviceName, runner, contract, ATTR_NAME, this.getHandledNodeType());
        ServiceRequestParmsImpl srp = new ServiceRequestParmsImpl();
        srp.setClientDPROVersion(runner.getClientDPROVersion());
        srp.setContainerContext(container);
        srp.setFailIfFailure(failIfFailure);
        srp.setFailIfTimeout(failIfTimeout);
        srp.setReturnServiceResults(true);
        srp.setServiceName(serviceName);
        ServiceParmsImpl sp = new ServiceParmsImpl();
        sp.params = params;
        srp.setServiceParameters(sp);
        srp.setTimeout(timeout);
        ServiceResults results = null;
        try {
            FileList outputFileList;
            results = provider.serviceRequest(srp);
            if (outputFileSet != null && (outputFileList = results.getOutputFiles()) != null) {
                session.addFileList(outputFileList);
            }
            String rc = results.getStatusString();
            if (rcVar != null) {
                session.setVariableValue(rcVar, rc);
            }
            this.checkReturnCode(serviceName, runner, contract, results, rcRulesStr);
        }
        catch (ServiceFailedException sfe) {
            if (errorHandler != null) {
                if (sfe.getServiceResults() != null) {
                    session.addServiceResults(sfe.getServiceResults());
                }
                Element parent = node.getParentElement();
                int i = 0;
                for (i = 0; i < parent.getContentSize(); ++i) {
                    if (!parent.getContent(i).equals((Object)node)) continue;
                    ++i;
                    break;
                }
                CallMacroNodeHandler.addMacroTo(errorHandler, parent, i);
                session.setVariableValue("serviceName", serviceName);
                String desc = sfe.getMessage();
                if (sfe.getCause() != null && (desc = sfe.getCause().getMessage()) == null) {
                    desc = sfe.getCause().toString();
                }
                session.setVariableValue("errorDescription", desc);
                StringWriter sw = new StringWriter();
                sfe.printStackTrace(new PrintWriter(sw));
                session.setVariableValue("errorStackTrace", sw.toString());
                sw.close();
            }
            throw sfe;
        }
        DefaultNodeHandlerResults res = new DefaultNodeHandlerResults(results);
        return res;
    }

    protected FileSet handleOutputFilesNode(Element node, Provider provider, ContainerContext container, ContractRunner runner, ContractSession session, File contract) throws RemoteException, InvalidContractException {
        String id = node.getAttributeValue(ATTR_FILE_LIST_ID);
        id = session.replaceVariables(id);
        String root = container.getDirectory();
        String orig = node.getAttributeValue("subDir");
        if (orig != null) {
            String subdir = session.replaceVariables(orig);
            try {
                root = this.addSubDir(root, subdir, runner, contract);
            }
            catch (IOException ioe) {
                String desc = ioe.getMessage();
                if (desc == null) {
                    desc = ioe.toString();
                }
                ResourceBundle msg = runner.getErrorBundle();
                String text = msg.getString("Error.UnexpectedIOError.fmt.txt");
                text = MessageFormat.format(text, this.getHandledNodeType(), desc);
                throw new InvalidContractException(text, contract, ioe);
            }
        }
        String providerName = provider.getProviderName();
        FileSetImpl fileSet = new FileSetImpl(root, providerName, id);
        FileSetNodeHandler.parseIncludeExcludes(node, runner, session, contract, this.getHandledNodeType(), (PatternSetImpl)fileSet);
        return fileSet;
    }
}

