/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.ContractSyntaxException;
import com.sas.dpro.contract.parser.ExpressionToken;
import com.sas.dpro.contract.parser.ExpressionTokenTypes;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ExpressionScanner
implements ExpressionTokenTypes {
    public static final String DEBUG = "com.sas.dpro.contract.parser.ExpressionScanner.debug";
    public static final String STR_EQ = "eq";
    public static final String STR_NE = "ne";
    private String str;
    private int pos;
    private int len;
    private static final Pattern PATTERN_IDENTIFIER = Pattern.compile("[A-Za-z][A-Za-z0-9]*");
    private static final Pattern PATTERN_VAR = Pattern.compile("\\$\\{[_A-Za-z0-9_\\.]+\\}");
    private static final Pattern PATTERN_STRING = Pattern.compile("([\"])(\\\\.|[^\"])*[\"]|(['])(\\\\.|[^'])*[']");
    private static final Pattern PATTERN_INT = Pattern.compile("[0-9]+");
    private static final String MSG = "com.sas.dpro.contract.parser.ExpressionScanner";

    public ExpressionScanner(String str) {
        this.str = str;
        this.len = str.length();
        this.pos = 0;
    }

    private ExpressionToken createToken(int type, String lexeme) {
        ExpressionToken token = new ExpressionToken(type, lexeme);
        this.debugPrint("Token parsed: " + token);
        return token;
    }

    private void debugPrint(String text) {
        if (Boolean.getBoolean(DEBUG)) {
            System.out.println("[ExpressionScanner DEBUG]: " + text);
        }
    }

    private ResourceBundle getErrorBundle() {
        return ResourceBundle.getBundle(MSG);
    }

    public int getPosition() {
        return this.pos;
    }

    public ExpressionToken nextToken(String action) throws ContractSyntaxException {
        while (this.pos < this.len && Character.isWhitespace(this.str.charAt(this.pos))) {
            ++this.pos;
        }
        if (this.pos == this.len) {
            return this.createToken(0, null);
        }
        char ch = this.str.charAt(this.pos);
        Matcher m = null;
        switch (ch) {
            case '$': {
                m = PATTERN_VAR.matcher(this.str);
                if (m.find(this.pos) && m.start() == this.pos) {
                    String var = m.group();
                    this.pos += var.length();
                    return this.createToken(24, var);
                }
                String desc = this.getErrorBundle().getString("Error.InvalidVariableAtPos.fmt.txt");
                desc = MessageFormat.format(desc, action, new Integer(this.pos + 1));
                throw new ContractSyntaxException(desc);
            }
            case '\"': 
            case '\'': {
                m = PATTERN_STRING.matcher(this.str);
                if (m.find(this.pos) && m.start() == this.pos) {
                    String var = m.group();
                    this.pos += var.length();
                    return this.createToken(20, var);
                }
                String desc = this.getErrorBundle().getString("Error.InvalidStringAtPos.fmt.txt");
                desc = MessageFormat.format(desc, action, new Integer(this.pos + 1));
                throw new ContractSyntaxException(desc);
            }
            case '(': {
                ++this.pos;
                return this.createToken(11, "(");
            }
            case ')': {
                ++this.pos;
                return this.createToken(19, ")");
            }
            case '+': {
                ++this.pos;
                return this.createToken(1, "+");
            }
            case '-': {
                ++this.pos;
                if (this.pos < this.len) {
                    m = PATTERN_IDENTIFIER.matcher(this.str);
                    if (m.find(this.pos) && m.start() == this.pos) {
                        String temp = m.group();
                        if (STR_EQ.equals(temp)) {
                            this.pos += STR_EQ.length();
                            return this.createToken(21, "-eq");
                        }
                        if (STR_NE.equals(temp)) {
                            this.pos += STR_NE.length();
                            return this.createToken(22, "-ne");
                        }
                    } else {
                        m = PATTERN_INT.matcher(this.str);
                        if (m.find(this.pos) && m.start() == this.pos) {
                            String val = m.group();
                            this.pos += val.length();
                            val = '-' + val;
                            return this.createToken(8, val);
                        }
                    }
                }
                return this.createToken(23, "-");
            }
            case '*': {
                ++this.pos;
                return this.createToken(15, "*");
            }
            case '/': {
                ++this.pos;
                return this.createToken(4, "/");
            }
            case '%': {
                ++this.pos;
                return this.createToken(14, "%");
            }
            case '<': {
                ++this.pos;
                if (this.pos < this.len && this.str.charAt(this.pos) == '=') {
                    ++this.pos;
                    return this.createToken(13, "<=");
                }
                return this.createToken(12, "<");
            }
            case '>': {
                ++this.pos;
                if (this.pos < this.len && this.str.charAt(this.pos) == '=') {
                    ++this.pos;
                    return this.createToken(7, ">=");
                }
                return this.createToken(6, ">");
            }
            case '=': {
                ++this.pos;
                if (this.pos < this.len) {
                    if (this.str.charAt(this.pos) == '=') {
                        ++this.pos;
                        return this.createToken(5, "==");
                    }
                    if (this.str.charAt(this.pos) == '~') {
                        ++this.pos;
                        return this.createToken(17, "=~");
                    }
                }
                String desc = this.getErrorBundle().getString("Error.ExpectedTokenAtPos.fmt.txt");
                desc = MessageFormat.format(desc, action, "==", new Integer(this.pos + 1));
                throw new ContractSyntaxException(desc);
            }
            case '&': {
                ++this.pos;
                if (this.pos < this.len && this.str.charAt(this.pos) == '&') {
                    ++this.pos;
                    return this.createToken(9, "&&");
                }
                return this.createToken(2, "&");
            }
            case '|': {
                ++this.pos;
                if (this.pos < this.len && this.str.charAt(this.pos) == '|') {
                    ++this.pos;
                    return this.createToken(10, "||");
                }
                return this.createToken(3, "|");
            }
            case '!': {
                ++this.pos;
                if (this.pos < this.len) {
                    if (this.str.charAt(this.pos) == '=') {
                        ++this.pos;
                        return this.createToken(16, "!=");
                    }
                    if (this.str.charAt(this.pos) == '~') {
                        ++this.pos;
                        return this.createToken(18, "!~");
                    }
                }
                String desc = this.getErrorBundle().getString("Error.ExpectedTokenAtPos.fmt.txt");
                desc = MessageFormat.format(desc, action, "!=", new Integer(this.pos + 1));
                throw new ContractSyntaxException(desc);
            }
        }
        if (Character.isDigit(ch)) {
            m = PATTERN_INT.matcher(this.str);
            if (m.find(this.pos) && m.start() == this.pos) {
                String var = m.group();
                this.pos += var.length();
                return this.createToken(8, var);
            }
            String desc = this.getErrorBundle().getString("Error.ExpectedTokenAtPos.fmt.txt");
            desc = MessageFormat.format(desc, action, "integer", new Integer(this.pos + 1));
            throw new ContractSyntaxException(desc);
        }
        String desc = this.getErrorBundle().getString("Error.InvalidInputAtPos.fmt.txt");
        desc = MessageFormat.format(desc, action, new Integer(this.pos + 1));
        throw new ContractSyntaxException(desc);
    }
}

