/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.ContractSyntaxException;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.contract.parser.ExpressionScanner;
import com.sas.dpro.contract.parser.ExpressionToken;
import com.sas.dpro.contract.parser.ExpressionTokenTypes;
import com.sas.dpro.controller.ContractSession;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

class ExpressionParser
implements ExpressionTokenTypes {
    private static final ExpressionParser INSTANCE = new ExpressionParser();
    private static final String MSG = "com.sas.dpro.contract.parser.ExpressionParser";

    private ExpressionParser() {
    }

    private ResourceBundle getErrorBundle() {
        return ResourceBundle.getBundle(MSG);
    }

    public static ExpressionParser getInstance() {
        return INSTANCE;
    }

    private int getInt(String lexeme, String action) throws ContractSyntaxException {
        try {
            return Integer.parseInt(lexeme);
        }
        catch (NumberFormatException nfe) {
            String desc = this.getErrorBundle().getString("Error.InvalidInteger.fmt.txt");
            desc = MessageFormat.format(desc, action, lexeme);
            throw new ContractSyntaxException(desc);
        }
    }

    public boolean parseBooleanExpression(String test, String action, ContractSession session) throws ContractSyntaxException {
        ExpressionToken comp;
        ExpressionScanner scanner = new ExpressionScanner(test);
        int state = 0;
        boolean retVal = false;
        ExpressionToken param1 = scanner.nextToken(action);
        block4 : switch (param1.type) {
            case 24: {
                comp = scanner.nextToken(action);
                switch (comp.type) {
                    case 0: {
                        String varName = param1.lexeme;
                        varName = varName.substring(2, varName.length() - 1);
                        return session.getVariableValue(varName) != null;
                    }
                    case 21: 
                    case 22: {
                        state = 1;
                        break block4;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 12: 
                    case 13: 
                    case 16: {
                        state = 2;
                        break block4;
                    }
                    case 17: 
                    case 18: {
                        state = 3;
                        break block4;
                    }
                }
                String desc = this.getErrorBundle().getString("Error.UnexpectedToken.fmt.txt");
                desc = MessageFormat.format(desc, action, comp.lexeme);
                throw new ContractSyntaxException(desc);
            }
            default: {
                String desc = this.getErrorBundle().getString("Error.ExpectedVariable.fmt.txt");
                desc = MessageFormat.format(desc, action, param1.lexeme);
                throw new ContractSyntaxException(desc);
            }
        }
        ExpressionToken param2 = scanner.nextToken(action);
        block13 : switch (state) {
            case 1: {
                switch (param2.type) {
                    case 20: {
                        String s1 = session.replaceVariables(param1.lexeme);
                        String s2 = param2.lexeme;
                        s2 = s2.substring(1, s2.length() - 1);
                        boolean equal = s1.equals(s2);
                        retVal = comp.type == 21 ? equal : !equal;
                        break block13;
                    }
                    case 24: {
                        String s1 = session.replaceVariables(param1.lexeme);
                        String s2 = session.replaceVariables(param2.lexeme);
                        boolean equal = s1.equals(s2);
                        retVal = comp.type == 21 ? equal : !equal;
                        break block13;
                    }
                }
                String desc = this.getErrorBundle().getString("Error.ExpectedStringOrVariable.fmt.txt");
                desc = MessageFormat.format(desc, action, param2.lexeme);
                throw new ContractSyntaxException(desc);
            }
            case 2: {
                switch (param2.type) {
                    case 8: 
                    case 24: {
                        int val1;
                        int val2;
                        String s;
                        try {
                            s = param2.lexeme;
                            if (param2.type == 24) {
                                s = session.replaceVariables(s);
                            }
                            val2 = Integer.parseInt(s);
                        }
                        catch (NumberFormatException nfe) {
                            if (param2.type == 24) {
                                retVal = false;
                                break block13;
                            }
                            String desc = this.getErrorBundle().getString("Error.InvalidInteger.fmt.txt");
                            desc = MessageFormat.format(desc, action, param2.lexeme);
                            throw new ContractSyntaxException(desc);
                        }
                        try {
                            s = session.replaceVariables(param1.lexeme);
                            val1 = Integer.parseInt(s);
                        }
                        catch (NumberFormatException nfe) {
                            retVal = false;
                            break block13;
                        }
                        switch (comp.type) {
                            case 5: {
                                retVal = val1 == val2;
                                break block13;
                            }
                            case 6: {
                                retVal = val1 > val2;
                                break block13;
                            }
                            case 7: {
                                retVal = val1 >= val2;
                                break block13;
                            }
                            case 12: {
                                retVal = val1 < val2;
                                break block13;
                            }
                            case 13: {
                                retVal = val1 <= val2;
                                break block13;
                            }
                            case 16: {
                                retVal = val1 != val2;
                                break block13;
                            }
                        }
                    }
                }
                String desc = this.getErrorBundle().getString("Error.ExpectedIntegerOrVariable.fmt.txt");
                desc = MessageFormat.format(desc, action, param2.lexeme);
                throw new ContractSyntaxException(desc);
            }
            case 3: {
                switch (param2.type) {
                    case 20: {
                        String s1 = session.replaceVariables(param1.lexeme);
                        String s2 = param2.lexeme;
                        s2 = s2.substring(1, s2.length() - 1);
                        try {
                            Pattern p = Pattern.compile(s2);
                            retVal = p.matcher(s1).find();
                        }
                        catch (PatternSyntaxException pse) {
                            String desc = DProUtil.formatString(this.getErrorBundle(), "Error.InvalidRegex1.fmt.txt", action, s2, pse.getMessage());
                            throw new ContractSyntaxException(desc);
                        }
                        if (comp.type != 18) break block13;
                        retVal = !retVal;
                        break block13;
                    }
                    case 24: {
                        String s1 = session.replaceVariables(param1.lexeme);
                        String s2 = session.replaceVariables(param2.lexeme);
                        try {
                            Pattern p = Pattern.compile(s2);
                            retVal = p.matcher(s1).find();
                        }
                        catch (PatternSyntaxException pse) {
                            String desc = DProUtil.formatString(this.getErrorBundle(), "Error.InvalidRegex2.fmt.txt", new String[]{action, s2, param2.lexeme, pse.getMessage()});
                            throw new ContractSyntaxException(desc);
                        }
                        if (comp.type != 18) break block13;
                        retVal = !retVal;
                        break block13;
                    }
                }
                String desc = this.getErrorBundle().getString("Error.ExpectedStringOrVariable.fmt.txt");
                desc = MessageFormat.format(desc, action, param2.lexeme);
                throw new ContractSyntaxException(desc);
            }
        }
        ExpressionToken next = scanner.nextToken(action);
        switch (next.type) {
            case 0: {
                break;
            }
            case 9: {
                if (!retVal) break;
                test = test.substring(scanner.getPosition());
                retVal &= this.parseBooleanExpression(test, action, session);
                break;
            }
            case 10: {
                test = test.substring(scanner.getPosition());
                retVal |= this.parseBooleanExpression(test, action, session);
                break;
            }
            default: {
                String desc = this.getErrorBundle().getString("Error.ExpectedAndOrOr.fmt.txt");
                desc = MessageFormat.format(desc, action, next.lexeme);
                throw new ContractSyntaxException(desc);
            }
        }
        return retVal;
    }

    public int parseIntegerExpression(String test, String action, ContractSession session) throws ContractSyntaxException {
        ExpressionScanner scanner = new ExpressionScanner(test);
        int val1 = 0;
        int val2 = 0;
        ExpressionToken param1 = scanner.nextToken(action);
        switch (param1.type) {
            case 8: {
                val1 = this.getInt(param1.lexeme, action);
                break;
            }
            case 24: {
                val1 = this.getInt(session.replaceVariables(param1.lexeme), action);
                break;
            }
            default: {
                String desc = this.getErrorBundle().getString("Error.ExpectedVariable.fmt.txt");
                desc = MessageFormat.format(desc, param1.lexeme);
                throw new ContractSyntaxException(desc);
            }
        }
        ExpressionToken operator = scanner.nextToken(action);
        switch (operator.type) {
            case 1: 
            case 4: 
            case 14: 
            case 15: 
            case 23: {
                break;
            }
            case 0: {
                return val1;
            }
            default: {
                String desc = this.getErrorBundle().getString("Error.ExpectedBinaryOperator.fmt.txt");
                desc = MessageFormat.format(desc, action, operator.lexeme);
                throw new ContractSyntaxException(desc);
            }
        }
        ExpressionToken param2 = scanner.nextToken(action);
        switch (param2.type) {
            case 8: {
                val2 = this.getInt(param2.lexeme, action);
                break;
            }
            case 24: {
                val2 = this.getInt(session.replaceVariables(param2.lexeme), action);
                break;
            }
            case 0: {
                String desc = this.getErrorBundle().getString("Error.UnexpectedEndOfExpression.fmt.txt");
                desc = MessageFormat.format(desc, action);
                throw new ContractSyntaxException(desc);
            }
            default: {
                String desc = this.getErrorBundle().getString("Error.ExpectedVariable.fmt.txt");
                desc = MessageFormat.format(desc, action, param2.lexeme);
                throw new ContractSyntaxException(desc);
            }
        }
        switch (operator.type) {
            case 1: {
                return val1 + val2;
            }
            case 23: {
                return val1 - val2;
            }
            case 15: {
                return val1 * val2;
            }
            case 4: {
                return val1 / val2;
            }
            case 14: {
                return val1 % val2;
            }
        }
        throw new InternalError("Unhandled operator type: " + operator.type);
    }
}

