/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.ErrorInfoImpl;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.messages.ContractCompletedMessageImpl;
import com.sas.dpro.contract.parser.AbstractActionNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import com.sas.dpro.provider.ProviderFactory;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import org.jdom2.Element;

public class ExitNodeHandler
extends AbstractActionNodeHandler {
    public static final String HANDLED_NODE_TYPE = "exit";
    private static final String ATTR_ERROR_DESC = "errorDescription";

    public ExitNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        Element child;
        DefaultNodeHandlerResults res = new DefaultNodeHandlerResults();
        if (!this.checkIfAttribute(node, session, contract)) {
            return res;
        }
        res.setStopContract(true);
        String error = null;
        String orig = node.getAttributeValue(ATTR_ERROR_DESC);
        if (orig == null && (child = node.getChild(ATTR_ERROR_DESC)) != null && (orig = child.getText()).length() == 0) {
            orig = null;
        }
        if (orig != null) {
            error = session.replaceVariables(orig);
            String server = ProviderFactory.getLocalProviderName();
            Exception e = new Exception(error);
            ContractCompletedMessageImpl ccm = new ContractCompletedMessageImpl(session.getHonorContractContext());
            ErrorInfoImpl ei = new ErrorInfoImpl(server, e);
            ccm.setErrorInfo(ei);
            res.setStoppedContractCompletedMessage(ccm);
        }
        return res;
    }
}

